/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.language.grammar;

import edu.cmu.sphinx.linguist.WordSequence;
import edu.cmu.sphinx.linguist.dictionary.Dictionary;
import edu.cmu.sphinx.linguist.dictionary.Word;
import edu.cmu.sphinx.linguist.language.grammar.Grammar;
import edu.cmu.sphinx.linguist.language.grammar.GrammarNode;
import edu.cmu.sphinx.linguist.language.ngram.LanguageModel;
import edu.cmu.sphinx.util.TimerPool;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;

public class LMGrammar
extends Grammar {
    @S4Component(type=LanguageModel.class)
    public static final String PROP_LANGUAGE_MODEL = "languageModel";
    private LanguageModel languageModel;

    public LMGrammar(LanguageModel languageModel, boolean showGrammar, boolean optimizeGrammar, boolean addSilenceWords, boolean addFillerWords, Dictionary dictionary) {
        super(showGrammar, optimizeGrammar, addSilenceWords, addFillerWords, dictionary);
        this.languageModel = languageModel;
    }

    public LMGrammar() {
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        super.newProperties(ps);
        this.languageModel = (LanguageModel)ps.getComponent(PROP_LANGUAGE_MODEL);
    }

    @Override
    protected GrammarNode createGrammar() throws IOException {
        this.languageModel.allocate();
        TimerPool.getTimer(this, "LMGrammar.create").start();
        GrammarNode firstNode = null;
        if (this.languageModel.getMaxDepth() > 2) {
            System.out.println("Warning: LMGrammar  limited to bigrams");
        }
        ArrayList<GrammarNode> nodes = new ArrayList<GrammarNode>();
        Set<String> words = this.languageModel.getVocabulary();
        for (String word : words) {
            GrammarNode node = this.createGrammarNode(word);
            if (node == null || node.isEmpty()) continue;
            if (node.getWord().equals(this.getDictionary().getSentenceStartWord())) {
                firstNode = node;
            } else if (node.getWord().equals(this.getDictionary().getSentenceEndWord())) {
                node.setFinalNode(true);
            }
            nodes.add(node);
        }
        if (firstNode == null) {
            throw new Error("No sentence start found in language model");
        }
        for (GrammarNode prevNode : nodes) {
            if (prevNode.isFinalNode()) continue;
            for (GrammarNode nextNode : nodes) {
                String prevWord = prevNode.getWord().getSpelling();
                String nextWord = nextNode.getWord().getSpelling();
                Word[] wordArray = new Word[]{this.getDictionary().getWord(prevWord), this.getDictionary().getWord(nextWord)};
                float logProbability = this.languageModel.getProbability(new WordSequence(wordArray));
                prevNode.add(nextNode, logProbability);
            }
        }
        TimerPool.getTimer(this, "LMGrammar.create").stop();
        this.languageModel.deallocate();
        return firstNode;
    }
}

