/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.language.grammar;

import edu.cmu.sphinx.linguist.dictionary.Dictionary;
import edu.cmu.sphinx.linguist.language.grammar.Grammar;
import edu.cmu.sphinx.linguist.language.grammar.GrammarNode;
import edu.cmu.sphinx.util.LogMath;
import java.util.StringTokenizer;

public class ForcedAlignerGrammar
extends Grammar {
    protected GrammarNode finalNode;

    public ForcedAlignerGrammar(boolean showGrammar, boolean optimizeGrammar, boolean addSilenceWords, boolean addFillerWords, Dictionary dictionary) {
        super(showGrammar, optimizeGrammar, addSilenceWords, addFillerWords, dictionary);
    }

    public ForcedAlignerGrammar() {
    }

    @Override
    protected GrammarNode createGrammar() {
        throw new Error("Not implemented");
    }

    @Override
    protected GrammarNode createGrammar(String referenceText) throws NoSuchMethodException {
        this.initialNode = this.createGrammarNode(false);
        this.finalNode = this.createGrammarNode(true);
        this.createForcedAlignerGrammar(this.initialNode, this.finalNode, referenceText);
        return this.initialNode;
    }

    protected GrammarNode createForcedAlignerGrammar(GrammarNode iNode, GrammarNode fNode, String transcript) throws NoSuchMethodException {
        float logArcProbability = LogMath.getLogOne();
        StringTokenizer tok = new StringTokenizer(transcript);
        GrammarNode firstNode = null;
        GrammarNode lastNode = null;
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            GrammarNode prevNode = lastNode;
            lastNode = this.createGrammarNode(token);
            if (firstNode == null) {
                firstNode = lastNode;
            }
            if (prevNode == null) continue;
            prevNode.add(lastNode, logArcProbability);
        }
        iNode.add(firstNode, logArcProbability);
        lastNode.add(fNode, logArcProbability);
        return firstNode;
    }
}

