/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.flat;

import edu.cmu.sphinx.linguist.UnitSearchState;
import edu.cmu.sphinx.linguist.acoustic.HMMPosition;
import edu.cmu.sphinx.linguist.acoustic.Unit;
import edu.cmu.sphinx.linguist.acoustic.UnitManager;
import edu.cmu.sphinx.linguist.flat.PronunciationState;
import edu.cmu.sphinx.linguist.flat.SentenceHMMState;

public class UnitState
extends SentenceHMMState
implements UnitSearchState {
    private final Unit unit;
    private HMMPosition position = HMMPosition.INTERNAL;

    public UnitState(PronunciationState parent, int which, Unit unit) {
        super("U", parent, which);
        this.unit = unit;
        Unit[] units = parent.getPronunciation().getUnits();
        int length = units.length;
        if (units[length - 1] == UnitManager.SILENCE && length > 1) {
            --length;
        }
        if (length == 1) {
            this.position = HMMPosition.SINGLE;
        } else if (which == 0) {
            this.position = HMMPosition.BEGIN;
        } else if (which == length - 1) {
            this.position = HMMPosition.END;
        }
    }

    public UnitState(Unit unit, HMMPosition position) {
        this.unit = unit;
        this.position = position;
    }

    @Override
    public Unit getUnit() {
        return this.unit;
    }

    public boolean isLast() {
        return this.position == HMMPosition.SINGLE || this.position == HMMPosition.END;
    }

    @Override
    public String getName() {
        return super.getName() + '<' + this.unit + '>';
    }

    @Override
    public String getValueSignature() {
        return this.unit.toString();
    }

    @Override
    public String getPrettyName() {
        return this.unit.toString();
    }

    @Override
    public String getTypeLabel() {
        return "Unit";
    }

    public HMMPosition getPosition() {
        return this.position;
    }

    @Override
    public boolean isUnit() {
        return true;
    }

    @Override
    public int getOrder() {
        return 5;
    }
}

