/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.dictionary;

import edu.cmu.sphinx.linguist.acoustic.Unit;
import edu.cmu.sphinx.linguist.dictionary.Word;
import edu.cmu.sphinx.linguist.dictionary.WordClassification;
import java.util.List;

public class Pronunciation {
    public static final Pronunciation UNKNOWN = new Pronunciation(Unit.EMPTY_ARRAY, null, null, 1.0f);
    private Word word;
    private final WordClassification wordClassification;
    private final Unit[] units;
    private final String tag;
    private final float probability;

    protected Pronunciation(Unit[] units, String tag, WordClassification wordClassification, float probability) {
        this.wordClassification = wordClassification;
        this.units = units;
        this.tag = tag;
        this.probability = probability;
    }

    protected Pronunciation(List<Unit> units, String tag, WordClassification wordClassification, float probability) {
        Unit[] unitsArray = units.toArray(new Unit[units.size()]);
        this.wordClassification = wordClassification;
        this.units = unitsArray;
        this.tag = tag;
        this.probability = probability;
    }

    protected Pronunciation(List<Unit> units) {
        this(units, null, null, 1.0f);
    }

    protected void setWord(Word word) {
        if (this.word != null) {
            throw new Error("Word of Pronunciation cannot be set twice.");
        }
        this.word = word;
    }

    public Word getWord() {
        return this.word;
    }

    public WordClassification getWordClassification() {
        return this.wordClassification;
    }

    public Unit[] getUnits() {
        return this.units;
    }

    public String getTag() {
        return this.tag;
    }

    public float getProbability() {
        return this.probability;
    }

    public void dump() {
        System.out.println(this.toString());
    }

    public String toString() {
        StringBuilder result = new StringBuilder().append(this.word).append('(');
        for (Unit unit : this.units) {
            result.append(unit).append(' ');
        }
        result.append(')');
        return result.toString();
    }

    public String toDetailedString() {
        StringBuilder result = new StringBuilder().append(this.word).append(' ');
        for (Unit unit : this.units) {
            result.append(unit).append(' ');
        }
        result.append("\n   class: ").append(this.wordClassification).append(" tag: ").append(this.tag).append(" prob: ").append(this.probability);
        return result.toString();
    }
}

