/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.acoustic.tiedstate.HTK;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.StringTokenizer;

public class NamesConversion {
    final HashMap<String, String> phoneConv = new HashMap();
    final HashMap<String, String> wordConv = new HashMap();
    String left;
    String base;
    String right;

    void addInConv(String item, HashMap<String, String> conv) {
        if (!conv.containsKey(item)) {
            String cand = item.toUpperCase();
            while (conv.containsValue(cand)) {
                cand = cand + "_X";
            }
            conv.put(item, cand);
        }
    }

    void buildPhoneConversion(String MMFfile) {
        try {
            String s;
            BufferedReader bf = new BufferedReader(new FileReader(MMFfile));
            while ((s = bf.readLine()) != null) {
                int i = s.indexOf("~h");
                if (i < 0) continue;
                i = s.indexOf(34);
                int j = s.lastIndexOf(34);
                String nom = s.substring(i + 1, j);
                this.split3ph(nom);
                if (this.left != null) {
                    this.addInConv(this.left, this.phoneConv);
                }
                if (this.base != null) {
                    this.addInConv(this.base, this.phoneConv);
                }
                if (this.right == null) continue;
                this.addInConv(this.right, this.phoneConv);
            }
            bf.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void buildWordConversion(String lexFile) {
        try {
            String s;
            BufferedReader bf = new BufferedReader(new FileReader(lexFile));
            while ((s = bf.readLine()) != null) {
                StringTokenizer st = new StringTokenizer(s);
                if (!st.hasMoreTokens()) continue;
                String word = st.nextToken();
                this.addInConv(word, this.wordConv);
            }
            bf.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void split3ph(String nom) {
        int i = nom.indexOf(45);
        if (i >= 0) {
            this.left = nom.substring(0, i);
        } else {
            this.left = null;
            i = -1;
        }
        String s = nom.substring(i + 1);
        i = s.indexOf(43);
        if (i >= 0) {
            this.right = s.substring(i + 1);
        } else {
            this.right = null;
            i = s.length();
        }
        this.base = s.substring(0, i);
    }

    String conv3ph() {
        String rep = this.left != null ? this.conv1ph(this.left) + '-' : "";
        rep = rep + this.conv1ph(this.base);
        if (this.right != null) {
            rep = rep + '+' + this.conv1ph(this.right);
        }
        if (rep.equals("null")) {
            System.err.println("detson error " + this.left + ' ' + this.base + ' ' + this.right);
            System.exit(1);
        }
        return rep;
    }

    String conv1ph(String p) {
        return this.phoneConv.get(p);
    }

    void convertMMF(String MMFfile) {
        try {
            String s;
            BufferedReader bf = new BufferedReader(new FileReader(MMFfile));
            PrintWriter pf = new PrintWriter(new FileWriter(MMFfile + ".conv"));
            while ((s = bf.readLine()) != null) {
                int i = s.indexOf("~h");
                if (i >= 0) {
                    i = s.indexOf(34);
                    int j = s.lastIndexOf(34);
                    String nom = s.substring(i + 1, j);
                    this.split3ph(nom);
                    String newnom = this.conv3ph();
                    pf.println("~h \"" + newnom + '\"');
                    continue;
                }
                pf.println(s);
            }
            pf.close();
            bf.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void convertWordGrammar(String gramFile) {
        try {
            String newmot;
            String mot;
            StringTokenizer st;
            int i;
            String s;
            int i2;
            BufferedReader bf = new BufferedReader(new FileReader(gramFile));
            PrintWriter pf = new PrintWriter(new FileWriter(gramFile + ".conv"));
            do {
                if ((s = bf.readLine()) == null) {
                    pf.close();
                    bf.close();
                    return;
                }
                pf.println(s);
            } while ((i2 = s.indexOf("\\data\\")) != 0);
            do {
                if ((s = bf.readLine()) == null) {
                    pf.close();
                    bf.close();
                    return;
                }
                pf.println(s);
            } while ((i2 = s.indexOf("\\1-grams:")) != 0);
            boolean fin = false;
            while (!fin) {
                s = bf.readLine();
                if (s == null) {
                    pf.close();
                    bf.close();
                    return;
                }
                i = s.indexOf("\\2-grams:");
                if (i == 0) {
                    pf.println(s);
                    break;
                }
                i = s.indexOf("\\end\\");
                if (i == 0) {
                    fin = true;
                    pf.println(s);
                    break;
                }
                st = new StringTokenizer(s);
                if (!(st != null & st.hasMoreTokens())) continue;
                pf.print(st.nextToken() + ' ');
                if (st.hasMoreTokens()) {
                    mot = st.nextToken();
                    newmot = this.wordConv.get(mot);
                    if (newmot == null) {
                        System.err.println("WARNING word " + mot + " not in lexicon !");
                        this.addInConv(mot, this.wordConv);
                        newmot = this.wordConv.get(mot);
                    }
                    pf.print(newmot + ' ');
                    while (st.hasMoreTokens()) {
                        pf.print(st.nextToken() + ' ');
                    }
                }
                pf.println();
            }
            while (!fin) {
                s = bf.readLine();
                if (s == null) {
                    pf.close();
                    bf.close();
                    return;
                }
                i = s.indexOf("\\3-grams:");
                if (i == 0) {
                    pf.println(s);
                    break;
                }
                i = s.indexOf("\\end\\");
                if (i == 0) {
                    fin = true;
                    pf.println(s);
                    break;
                }
                st = new StringTokenizer(s);
                if (!(st != null & st.hasMoreTokens())) continue;
                pf.print(st.nextToken() + ' ');
                if (st.hasMoreTokens()) {
                    mot = st.nextToken();
                    newmot = this.wordConv.get(mot);
                    if (newmot == null) {
                        newmot = mot;
                    }
                    pf.print(newmot + ' ');
                    if (st.hasMoreTokens()) {
                        mot = st.nextToken();
                        newmot = this.wordConv.get(mot);
                        if (newmot == null) {
                            newmot = mot;
                        }
                        pf.print(newmot + ' ');
                        while (st.hasMoreTokens()) {
                            pf.print(st.nextToken() + ' ');
                        }
                    }
                }
                pf.println();
            }
            while (!fin) {
                s = bf.readLine();
                if (s == null) {
                    pf.close();
                    bf.close();
                    return;
                }
                i = s.indexOf("\\end\\");
                if (i == 0) {
                    fin = true;
                    pf.println(s);
                    break;
                }
                st = new StringTokenizer(s);
                if (!(st != null & st.hasMoreTokens())) continue;
                pf.print(st.nextToken() + ' ');
                if (st.hasMoreTokens()) {
                    mot = st.nextToken();
                    newmot = this.wordConv.get(mot);
                    if (newmot == null) {
                        newmot = mot;
                    }
                    pf.print(newmot + ' ');
                    if (st.hasMoreTokens()) {
                        mot = st.nextToken();
                        newmot = this.wordConv.get(mot);
                        if (newmot == null) {
                            newmot = mot;
                        }
                        pf.print(newmot + ' ');
                        if (st.hasMoreTokens()) {
                            mot = st.nextToken();
                            newmot = this.wordConv.get(mot);
                            if (newmot == null) {
                                newmot = mot;
                            }
                            pf.print(newmot + ' ');
                            while (st.hasMoreTokens()) {
                                pf.print(st.nextToken() + ' ');
                            }
                        }
                    }
                }
                pf.println();
            }
            pf.close();
            bf.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void convertLexicon(String lexFile) {
        try {
            String s;
            BufferedReader bf = new BufferedReader(new FileReader(lexFile));
            PrintWriter pf = new PrintWriter(new FileWriter(lexFile + ".conv"));
            while ((s = bf.readLine()) != null) {
                StringTokenizer st = new StringTokenizer(s);
                if (st == null || !st.hasMoreTokens()) continue;
                String mot = st.nextToken();
                String newmot = this.wordConv.get(mot);
                if (newmot != null) {
                    mot = newmot;
                }
                pf.print(mot + ' ');
                while (st.hasMoreTokens()) {
                    String ph = st.nextToken();
                    if (ph.charAt(0) == '[') {
                        while (!ph.endsWith("]")) {
                            ph = st.nextToken();
                        }
                        ph = st.nextToken();
                    }
                    this.split3ph(ph);
                    String newnom = this.conv3ph();
                    pf.print(newnom + ' ');
                }
                pf.println();
            }
            pf.close();
            bf.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        String MMFfile = null;
        String lexFile = null;
        String fillerFile = null;
        String gramFile = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-lex")) {
                lexFile = args[++i];
                continue;
            }
            if (args[i].equals("-gram")) {
                gramFile = args[++i];
                continue;
            }
            if (args[i].equals("-mmf")) {
                MMFfile = args[++i];
                continue;
            }
            if (!args[i].equals("-filler")) continue;
            fillerFile = args[++i];
        }
        if (MMFfile != null) {
            NamesConversion nc = new NamesConversion();
            nc.buildPhoneConversion(MMFfile);
            nc.buildWordConversion(lexFile);
            System.out.println("converting phones in MMF to " + MMFfile + ".conv");
            nc.convertMMF(MMFfile);
            if (lexFile != null) {
                System.out.println("converting phones and words in lexicon to " + lexFile + ".conv");
                nc.convertLexicon(lexFile);
            }
            if (fillerFile != null) {
                System.out.println("converting phones in filler to " + fillerFile + ".conv");
                nc.convertLexicon(fillerFile);
            }
            if (gramFile != null) {
                System.out.println("converting words in gram to " + gramFile + ".conv");
                nc.convertWordGrammar(gramFile);
            }
        }
    }
}

