/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.acoustic;

import edu.cmu.sphinx.linguist.acoustic.Context;
import edu.cmu.sphinx.linguist.acoustic.Unit;
import java.util.HashMap;
import java.util.Map;

public class LeftRightContext
extends Context {
    String stringRepresentation;
    final Unit[] leftContext;
    final Unit[] rightContext;
    private static final boolean CACHING_CONTEXTS = true;
    private static final Map<String, LeftRightContext> cache = new HashMap<String, LeftRightContext>();

    private LeftRightContext(Unit[] leftContext, Unit[] rightContext) {
        this.leftContext = leftContext;
        this.rightContext = rightContext;
    }

    @Override
    public String toString() {
        if (this.stringRepresentation == null) {
            this.stringRepresentation = LeftRightContext.getStringRepresentation(this.leftContext, this.rightContext);
        }
        return this.stringRepresentation;
    }

    public static LeftRightContext get(Unit[] leftContext, Unit[] rightContext) {
        String name = LeftRightContext.getStringRepresentation(leftContext, rightContext);
        LeftRightContext context = cache.get(name);
        if (context == null) {
            context = new LeftRightContext(leftContext, rightContext);
            cache.put(name, context);
        }
        return context;
    }

    private static String getStringRepresentation(Unit[] leftContext, Unit[] rightContext) {
        return LeftRightContext.getContextName(leftContext) + ',' + LeftRightContext.getContextName(rightContext);
    }

    public Unit[] getLeftContext() {
        return this.leftContext;
    }

    public Unit[] getRightContext() {
        return this.rightContext;
    }

    public static String getContextName(Unit[] context) {
        if (context == null) {
            return "*";
        }
        if (context.length == 0) {
            return "(empty)";
        }
        StringBuilder sb = new StringBuilder();
        for (Unit unit : context) {
            sb.append(unit == null ? null : unit.getName()).append('.');
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    @Override
    public boolean isPartialMatch(Context context) {
        if (context instanceof LeftRightContext) {
            LeftRightContext lrContext = (LeftRightContext)context;
            Unit[] lc = lrContext.getLeftContext();
            Unit[] rc = lrContext.getRightContext();
            return !(lc != null && this.leftContext != null && !Unit.isContextMatch(lc, this.leftContext) || rc != null && this.rightContext != null && !Unit.isContextMatch(rc, this.rightContext));
        }
        return context == Context.EMPTY_CONTEXT && this.leftContext == null && this.rightContext == null;
    }
}

