/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist;

import edu.cmu.sphinx.linguist.dictionary.Word;
import java.util.ArrayList;
import java.util.List;

public final class WordSequence {
    private final Word[] words;
    private transient int hashCode = -1;
    public static final WordSequence EMPTY = new WordSequence(0);

    private WordSequence(int size) {
        this.words = new Word[size];
    }

    public WordSequence(Word[] words) {
        this.words = (Word[])words.clone();
        this.check();
    }

    public WordSequence(List<Word> list) {
        this.words = list.toArray(new Word[list.size()]);
        this.check();
    }

    private void check() {
        for (Word word : this.words) {
            if (word != null) continue;
            throw new Error("WordSequence should not have null Words.");
        }
    }

    public WordSequence addWord(Word word, int maxSize) {
        if (maxSize <= 0) {
            return EMPTY;
        }
        int nextSize = this.size() + 1 > maxSize ? maxSize : this.size() + 1;
        WordSequence next = new WordSequence(nextSize);
        int nextIndex = nextSize - 1;
        int thisIndex = this.size() - 1;
        next.words[nextIndex--] = word;
        while (nextIndex >= 0 && thisIndex >= 0) {
            next.words[nextIndex--] = this.words[thisIndex--];
        }
        next.check();
        return next;
    }

    public WordSequence getOldest() {
        WordSequence next = EMPTY;
        if (this.size() >= 1) {
            next = new WordSequence(this.words.length - 1);
            System.arraycopy(this.words, 0, next.words, 0, next.words.length);
        }
        return next;
    }

    public WordSequence getNewest() {
        WordSequence next = EMPTY;
        if (this.size() >= 1) {
            next = new WordSequence(this.words.length - 1);
            System.arraycopy(this.words, 1, next.words, 0, next.words.length);
        }
        return next;
    }

    public WordSequence trim(int maxSize) {
        if (maxSize <= 0 || this.size() == 0) {
            return EMPTY;
        }
        if (maxSize == this.size()) {
            return this;
        }
        if (maxSize > this.size()) {
            maxSize = this.size();
        }
        WordSequence next = new WordSequence(maxSize);
        int thisIndex = this.words.length - 1;
        int nextIndex = next.words.length - 1;
        for (int i = 0; i < maxSize; ++i) {
            next.words[nextIndex--] = this.words[thisIndex--];
        }
        return next;
    }

    public Word getWord(int n) {
        if (n >= this.words.length) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return this.words[n];
    }

    public int size() {
        return this.words.length;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Word word : this.words) {
            sb.append('[').append(word).append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            int code = 123;
            for (int i = 0; i < this.words.length; ++i) {
                code += this.words[i].hashCode() * (2 * i + 1);
            }
            this.hashCode = code;
        }
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof WordSequence) {
            WordSequence other = (WordSequence)o;
            if (this.words.length == other.words.length) {
                for (int i = 0; i < this.words.length; ++i) {
                    if (this.words[i].equals(other.words[i])) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public WordSequence getSubSequence(int startIndex, int stopIndex) {
        ArrayList<Word> subseqWords = new ArrayList<Word>();
        for (int i = startIndex; i < stopIndex; ++i) {
            subseqWords.add(this.getWord(i));
        }
        return new WordSequence(subseqWords);
    }

    public Word[] getWords() {
        return this.getSubSequence((int)0, (int)this.size()).words;
    }
}

