/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.util;

import edu.cmu.sphinx.frontend.util.VUMeter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JPanel;

public class VUMeterPanel
extends JPanel {
    VUMeter vu;
    boolean quit;
    Thread thread;
    final int numberOfLights = 50;
    final int greenLevel = 15;
    final int yellowLevel = 35;
    final int redLevel = 45;

    public void setVu(VUMeter vu) {
        this.vu = vu;
    }

    public void start() {
        this.quit = false;
        this.thread = new VUMeterPanelThread();
        this.thread.start();
    }

    public void stop() {
        this.quit = true;
        boolean hasQuit = false;
        while (!hasQuit) {
            try {
                this.thread.join();
                hasQuit = true;
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.vu != null) {
            this.paintVUMeter(g);
        }
    }

    public VUMeter getVu() {
        return this.vu;
    }

    private void paintVUMeter(Graphics g) {
        int level = (int)(this.vu.getRmsDB() / this.vu.getMaxDB() * 50.0);
        int peak = (int)(this.vu.getPeakDB() / this.vu.getMaxDB() * 50.0);
        assert (level >= 0);
        assert (level < 50);
        Dimension sz = this.getSize();
        int w = sz.width;
        int h = sz.height / 50;
        g.setColor(Color.BLACK);
        g.fillRect(0, 0, sz.width - 1, sz.height - 1);
        for (int i = 0; i < level; ++i) {
            this.setLevelColor(i, g);
            g.fillRect(1, sz.height - i * h + 1, w - 2, h - 2);
        }
        this.setLevelColor(peak, g);
        g.fillRect(1, sz.height - peak * h + 1, w - 2, h - 2);
    }

    private void setLevelColor(int i, Graphics g) {
        if (i < 15) {
            g.setColor(Color.BLUE);
        } else if (i < 35) {
            g.setColor(Color.GREEN);
        } else if (i < 45) {
            g.setColor(Color.YELLOW);
        } else {
            g.setColor(Color.RED);
        }
    }

    class VUMeterPanelThread
    extends Thread {
        VUMeterPanelThread() {
        }

        @Override
        public void run() {
            while (!VUMeterPanel.this.quit) {
                VUMeterPanel.this.repaint();
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

