/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.util;

import edu.cmu.sphinx.frontend.util.AudioFileDataSource;
import edu.cmu.sphinx.frontend.util.AudioFileProcessListener;
import edu.cmu.sphinx.util.ReferenceSource;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.SequenceInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;

public class ConcatAudioFileDataSource
extends AudioFileDataSource
implements ReferenceSource {
    private URL nextFile;
    private List<String> referenceList;
    private boolean isInitialized;
    List<URL> batchFiles;

    public ConcatAudioFileDataSource(int bytesPerRead, List<AudioFileProcessListener> listeners) {
        super(bytesPerRead, listeners);
    }

    public ConcatAudioFileDataSource() {
    }

    @Override
    public void initialize() {
        super.initialize();
        if (this.batchFiles == null) {
            return;
        }
        try {
            this.referenceList = new ArrayList<String>();
            this.dataStream = new SequenceInputStream(new InputStreamEnumeration(this.batchFiles));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setBatchFile(File batchFile) {
        assert (batchFile.isFile()) : "given batch file is not a file";
        this.setBatchUrls(ConcatAudioFileDataSource.readDriver(batchFile.getAbsolutePath()));
    }

    public void setBatchFiles(List<File> files) {
        assert (files != null);
        ArrayList<URL> urls = new ArrayList<URL>();
        try {
            for (File file : files) {
                urls.add(file.toURI().toURL());
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        this.setBatchUrls(urls);
    }

    public void setBatchUrls(List<URL> urls) {
        this.batchFiles = new ArrayList<URL>(urls);
        this.initialize();
    }

    private static List<URL> readDriver(String fileName) {
        File inputFile = new File(fileName);
        ArrayList<URL> driverFiles = null;
        try {
            String line;
            if (!inputFile.isFile() || !inputFile.canRead()) {
                throw new IllegalArgumentException("file to read is not valid");
            }
            BufferedReader bf = new BufferedReader(new FileReader(inputFile));
            driverFiles = new ArrayList<URL>();
            while ((line = bf.readLine()) != null && line.trim().length() != 0) {
                File file = new File(line);
                assert (file.isFile()) : "file " + file + " does not exist!";
                driverFiles.add(file.toURI().toURL());
            }
            bf.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        assert (driverFiles != null);
        return driverFiles;
    }

    @Override
    public void setAudioFile(URL audioFileURL, String streamName) {
        throw new RuntimeException("Not supported for ConcatAudioFileDataSource");
    }

    @Override
    public List<String> getReferences() {
        return this.referenceList;
    }

    class InputStreamEnumeration
    implements Enumeration<AudioInputStream> {
        private URL lastFile;
        final Iterator<URL> fileIt;

        InputStreamEnumeration(List<URL> files) throws IOException {
            this.fileIt = new ArrayList<URL>(files).iterator();
        }

        @Override
        public boolean hasMoreElements() {
            if (ConcatAudioFileDataSource.this.nextFile == null) {
                ConcatAudioFileDataSource.this.nextFile = this.readNext();
            }
            return ConcatAudioFileDataSource.this.nextFile != null;
        }

        @Override
        public AudioInputStream nextElement() {
            AudioInputStream stream = null;
            if (this.lastFile == null) {
                ConcatAudioFileDataSource.this.nextFile = this.readNext();
            }
            if (ConcatAudioFileDataSource.this.nextFile != null) {
                try {
                    AudioInputStream ais = AudioSystem.getAudioInputStream(ConcatAudioFileDataSource.this.nextFile);
                    AudioFormat format = ais.getFormat();
                    if (!ConcatAudioFileDataSource.this.isInitialized) {
                        ConcatAudioFileDataSource.this.isInitialized = true;
                        ConcatAudioFileDataSource.this.bigEndian = format.isBigEndian();
                        ConcatAudioFileDataSource.this.sampleRate = (int)format.getSampleRate();
                        ConcatAudioFileDataSource.this.signedData = format.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED);
                        ConcatAudioFileDataSource.this.bytesPerValue = format.getSampleSizeInBits() / 8;
                    }
                    if (format.getSampleRate() != (float)ConcatAudioFileDataSource.this.sampleRate || format.getChannels() != 1 || format.isBigEndian() != ConcatAudioFileDataSource.this.bigEndian) {
                        throw new RuntimeException("format mismatch for subsequent files");
                    }
                    stream = ais;
                    ConcatAudioFileDataSource.this.logger.finer("Strating processing of '" + this.lastFile.getFile() + '\'');
                    for (AudioFileProcessListener fl : ConcatAudioFileDataSource.this.fileListeners) {
                        fl.audioFileProcStarted(new File(ConcatAudioFileDataSource.this.nextFile.getFile()));
                    }
                    this.lastFile = ConcatAudioFileDataSource.this.nextFile;
                    ConcatAudioFileDataSource.this.nextFile = null;
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    throw new Error("Cannot convert " + ConcatAudioFileDataSource.this.nextFile + " to a FileInputStream");
                }
                catch (UnsupportedAudioFileException e) {
                    e.printStackTrace();
                }
            }
            return stream;
        }

        public URL readNext() {
            if (this.lastFile != null) {
                ConcatAudioFileDataSource.this.logger.finest("Finished processing of '" + this.lastFile.getFile() + '\'');
                for (AudioFileProcessListener fl : ConcatAudioFileDataSource.this.fileListeners) {
                    fl.audioFileProcFinished(new File(this.lastFile.getFile()));
                }
                this.lastFile = null;
            }
            if (this.fileIt.hasNext()) {
                this.lastFile = this.fileIt.next();
            }
            return this.lastFile;
        }
    }
}

