/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.frequencywarp;

import edu.cmu.sphinx.frontend.BaseDataProcessor;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DataProcessingException;
import edu.cmu.sphinx.frontend.DoubleData;
import edu.cmu.sphinx.frontend.frequencywarp.MelFilter;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Double;
import edu.cmu.sphinx.util.props.S4Integer;

public class MelFrequencyFilterBank
extends BaseDataProcessor {
    @S4Integer(defaultValue=40)
    public static final String PROP_NUMBER_FILTERS = "numberFilters";
    @S4Double(defaultValue=130.0)
    public static final String PROP_MIN_FREQ = "minimumFrequency";
    @S4Double(defaultValue=6800.0)
    public static final String PROP_MAX_FREQ = "maximumFrequency";
    private int sampleRate;
    private int numberFftPoints;
    private int numberFilters;
    private double minFreq;
    private double maxFreq;
    private MelFilter[] filter;

    public MelFrequencyFilterBank(double minFreq, double maxFreq, int numberFilters) {
        this.initLogger();
        this.minFreq = minFreq;
        this.maxFreq = maxFreq;
        this.numberFilters = numberFilters;
    }

    public MelFrequencyFilterBank() {
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        super.newProperties(ps);
        this.minFreq = ps.getDouble(PROP_MIN_FREQ);
        this.maxFreq = ps.getDouble(PROP_MAX_FREQ);
        this.numberFilters = ps.getInt(PROP_NUMBER_FILTERS);
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    private double linToMelFreq(double inputFreq) {
        return 2595.0 * (Math.log(1.0 + inputFreq / 700.0) / Math.log(10.0));
    }

    private double melToLinFreq(double inputFreq) {
        return 700.0 * (Math.pow(10.0, inputFreq / 2595.0) - 1.0);
    }

    private double setToNearestFrequencyBin(double inFreq, double stepFreq) throws IllegalArgumentException {
        if (stepFreq == 0.0) {
            throw new IllegalArgumentException("stepFreq is zero");
        }
        return stepFreq * (double)Math.round(inFreq / stepFreq);
    }

    private void buildFilterbank(int numberFftPoints, int numberFilters, double minFreq, double maxFreq) throws IllegalArgumentException {
        double nextEdge;
        int i;
        double[] leftEdge = new double[numberFilters];
        double[] centerFreq = new double[numberFilters];
        double[] rightEdge = new double[numberFilters];
        this.filter = new MelFilter[numberFilters];
        if (numberFftPoints == 0) {
            throw new IllegalArgumentException("Number of FFT points is zero");
        }
        double deltaFreq = (double)this.sampleRate / (double)numberFftPoints;
        if (numberFilters < 1) {
            throw new IllegalArgumentException("Number of filters illegal: " + numberFilters);
        }
        double minFreqMel = this.linToMelFreq(minFreq);
        double maxFreqMel = this.linToMelFreq(maxFreq);
        double deltaFreqMel = (maxFreqMel - minFreqMel) / (double)(numberFilters + 1);
        leftEdge[0] = this.setToNearestFrequencyBin(minFreq, deltaFreq);
        double nextEdgeMel = minFreqMel;
        for (i = 0; i < numberFilters; ++i) {
            nextEdge = this.melToLinFreq(nextEdgeMel += deltaFreqMel);
            centerFreq[i] = this.setToNearestFrequencyBin(nextEdge, deltaFreq);
            if (i > 0) {
                rightEdge[i - 1] = centerFreq[i];
            }
            if (i >= numberFilters - 1) continue;
            leftEdge[i + 1] = centerFreq[i];
        }
        nextEdge = this.melToLinFreq(nextEdgeMel += deltaFreqMel);
        rightEdge[numberFilters - 1] = this.setToNearestFrequencyBin(nextEdge, deltaFreq);
        for (i = 0; i < numberFilters; ++i) {
            double initialFreqBin = this.setToNearestFrequencyBin(leftEdge[i], deltaFreq);
            if (initialFreqBin < leftEdge[i]) {
                initialFreqBin += deltaFreq;
            }
            this.filter[i] = new MelFilter(leftEdge[i], centerFreq[i], rightEdge[i], initialFreqBin, deltaFreq);
        }
    }

    private DoubleData process(DoubleData input) throws IllegalArgumentException {
        double[] in = input.getValues();
        if (this.filter == null || this.sampleRate != input.getSampleRate()) {
            this.numberFftPoints = in.length - 1 << 1;
            this.sampleRate = input.getSampleRate();
            this.buildFilterbank(this.numberFftPoints, this.numberFilters, this.minFreq, this.maxFreq);
        } else if (in.length != (this.numberFftPoints >> 1) + 1) {
            throw new IllegalArgumentException("Window size is incorrect: in.length == " + in.length + ", numberFftPoints == " + ((this.numberFftPoints >> 1) + 1));
        }
        double[] output = new double[this.numberFilters];
        for (int i = 0; i < this.numberFilters; ++i) {
            output[i] = this.filter[i].filterOutput(in);
        }
        DoubleData outputMelSpectrum = new DoubleData(output, this.sampleRate, input.getCollectTime(), input.getFirstSampleNumber());
        return outputMelSpectrum;
    }

    @Override
    public Data getData() throws DataProcessingException {
        Data input = this.getPredecessor().getData();
        this.getTimer().start();
        if (input != null && input instanceof DoubleData) {
            input = this.process((DoubleData)input);
        }
        this.getTimer().stop();
        return input;
    }
}

