/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.feature;

import edu.cmu.sphinx.frontend.BaseDataProcessor;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DataProcessingException;
import edu.cmu.sphinx.frontend.FloatData;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.Loader;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Component;

public class FeatureTransform
extends BaseDataProcessor {
    @S4Component(type=Loader.class)
    public static final String PROP_LOADER = "loader";
    float[][] transformMatrix;
    protected Loader loader;
    int rows;
    int values;

    public FeatureTransform(Loader loader) {
        this.initLogger();
        this.init(loader);
    }

    public FeatureTransform() {
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        super.newProperties(ps);
        this.init((Loader)ps.getComponent(PROP_LOADER));
    }

    private void init(Loader loader) {
        this.loader = loader;
        try {
            loader.load();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.transformMatrix = loader.getTransformMatrix();
        if (this.transformMatrix == null) {
            throw new RuntimeException("Model doesn't include transformation matrix");
        }
        this.rows = this.transformMatrix.length;
        this.values = this.transformMatrix[0].length;
    }

    @Override
    public Data getData() throws DataProcessingException {
        Data output;
        Data input = this.getPredecessor().getData();
        this.getTimer().start();
        if (input != null && input instanceof FloatData) {
            FloatData inputData = (FloatData)input;
            float[] in = inputData.getValues();
            float[] out = new float[this.rows];
            assert (in.length == this.values);
            for (int i = 0; i < this.rows; ++i) {
                out[i] = 0.0f;
                float[] transform_matrix_i = this.transformMatrix[i];
                for (int j = 0; j < this.values; ++j) {
                    int n = i;
                    out[n] = out[n] + in[j] * transform_matrix_i[j];
                }
            }
            output = new FloatData(out, inputData.getSampleRate(), inputData.getCollectTime(), inputData.getFirstSampleNumber());
        } else {
            output = input;
        }
        this.getTimer().stop();
        return output;
    }
}

