/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.feature;

import edu.cmu.sphinx.frontend.BaseDataProcessor;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DataEndSignal;
import edu.cmu.sphinx.frontend.DataProcessingException;
import edu.cmu.sphinx.frontend.DoubleData;
import edu.cmu.sphinx.frontend.endpoint.SpeechEndSignal;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import java.util.LinkedList;
import java.util.List;

public class BatchAGC
extends BaseDataProcessor {
    private List<Data> cepstraList;
    private double agc;

    public BatchAGC() {
        this.initLogger();
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        super.newProperties(ps);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.cepstraList = new LinkedList<Data>();
    }

    @Override
    public Data getData() throws DataProcessingException {
        Data output = null;
        if (!this.cepstraList.isEmpty()) {
            output = this.cepstraList.remove(0);
        } else {
            this.agc = 0.0;
            this.cepstraList.clear();
            if (this.readUtterance() > 0) {
                this.normalizeList();
                output = this.cepstraList.remove(0);
            }
        }
        return output;
    }

    private int readUtterance() throws DataProcessingException {
        Data input = null;
        int numFrames = 0;
        while ((input = this.getPredecessor().getData()) != null) {
            if (input instanceof DataEndSignal || input instanceof SpeechEndSignal) {
                this.cepstraList.add(input);
                break;
            }
            if (input instanceof DoubleData) {
                this.cepstraList.add(input);
                double c0 = ((DoubleData)input).getValues()[0];
                if (this.agc < c0) {
                    this.agc = c0;
                }
            } else {
                this.cepstraList.add(input);
            }
            ++numFrames;
        }
        return numFrames;
    }

    private void normalizeList() {
        for (Data data : this.cepstraList) {
            if (!(data instanceof DoubleData)) continue;
            double[] dArray = ((DoubleData)data).getValues();
            dArray[0] = dArray[0] - this.agc;
            System.out.println(((DoubleData)data).getValues()[0]);
        }
    }
}

