/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend;

import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DoubleData;
import edu.cmu.sphinx.util.MatrixUtils;

public class FloatData
implements Data,
Cloneable {
    private final float[] values;
    private final int sampleRate;
    private final long firstSampleNumber;
    private final long collectTime;

    public FloatData(float[] values, int sampleRate, long collectTime, long firstSampleNumber) {
        this.values = values;
        this.sampleRate = sampleRate;
        this.collectTime = collectTime;
        this.firstSampleNumber = firstSampleNumber;
    }

    public float[] getValues() {
        return this.values;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public long getFirstSampleNumber() {
        return this.firstSampleNumber;
    }

    public long getCollectTime() {
        return this.collectTime;
    }

    public FloatData clone() throws CloneNotSupportedException {
        try {
            FloatData data = (FloatData)super.clone();
            return data;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.toString());
        }
    }

    public static FloatData toFloatData(Data data) {
        FloatData convertData;
        if (data instanceof FloatData) {
            convertData = (FloatData)data;
        } else if (data instanceof DoubleData) {
            DoubleData dd = (DoubleData)data;
            convertData = new FloatData(MatrixUtils.double2float(dd.getValues()), dd.getSampleRate(), dd.getCollectTime(), dd.getFirstSampleNumber());
        } else {
            throw new IllegalArgumentException("data type '" + data.getClass() + "' is not supported");
        }
        return convertData;
    }
}

