/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend;

import edu.cmu.sphinx.frontend.Signal;

public class DataStartSignal
extends Signal {
    private final int sampleRate;
    public static final String SPEECH_TAGGED_FEATURE_STREAM = "vadTaggedFeatureStream";

    public DataStartSignal(int sampleRate) {
        this(sampleRate, System.currentTimeMillis());
    }

    public DataStartSignal(int sampleRate, long time) {
        this(sampleRate, time, false);
    }

    public DataStartSignal(int sampleRate, boolean tagAsVadStream) {
        this(sampleRate, System.currentTimeMillis(), tagAsVadStream);
    }

    public DataStartSignal(int sampleRate, long time, boolean tagAsVadStream) {
        super(time);
        this.sampleRate = sampleRate;
        if (tagAsVadStream) {
            this.getProps().put(SPEECH_TAGGED_FEATURE_STREAM, tagAsVadStream);
        }
    }

    public String toString() {
        return "DataStartSignal: creation time: " + this.getTime();
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public static void tagAsVadStream(DataStartSignal dsSignal) {
        dsSignal.getProps().put(SPEECH_TAGGED_FEATURE_STREAM, true);
    }

    public static void untagAsVadStream(DataStartSignal dsSignal) {
        dsSignal.getProps().remove(SPEECH_TAGGED_FEATURE_STREAM);
    }
}

