/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.autocomplete;

import java.awt.BorderLayout;
import java.awt.Rectangle;
import java.awt.Window;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import org.fife.ui.autocomplete.AutoCompletion;
import org.fife.ui.autocomplete.ParameterizedCompletion;
import org.fife.ui.autocomplete.ParameterizedCompletionContext;
import org.fife.ui.autocomplete.TipUtil;
import org.fife.ui.autocomplete.Util;
import org.fife.ui.rsyntaxtextarea.PopupWindowDecorator;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;

class ParameterizedCompletionDescriptionToolTip {
    private JWindow tooltip;
    private JLabel descLabel;
    private ParameterizedCompletion pc;

    public ParameterizedCompletionDescriptionToolTip(Window window, ParameterizedCompletionContext parameterizedCompletionContext, AutoCompletion autoCompletion, ParameterizedCompletion parameterizedCompletion) {
        this.tooltip = new JWindow(window);
        this.pc = parameterizedCompletion;
        this.descLabel = new JLabel();
        this.descLabel.setBorder(BorderFactory.createCompoundBorder(TipUtil.getToolTipBorder(), BorderFactory.createEmptyBorder(2, 5, 2, 5)));
        this.descLabel.setOpaque(true);
        this.descLabel.setBackground(TipUtil.getToolTipBackground());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add(this.descLabel);
        this.tooltip.setContentPane(jPanel);
        PopupWindowDecorator popupWindowDecorator = PopupWindowDecorator.get();
        if (popupWindowDecorator != null) {
            popupWindowDecorator.decorate(this.tooltip);
        }
        this.updateText(0);
        this.tooltip.setFocusableWindowState(false);
    }

    public boolean isVisible() {
        return this.tooltip.isVisible();
    }

    public void setLocationRelativeTo(Rectangle rectangle) {
        int n;
        Rectangle rectangle2 = Util.getScreenBoundsForPoint(rectangle.x, rectangle.y);
        int n2 = rectangle.y - 5 - this.tooltip.getHeight();
        if (n2 < 0) {
            n2 = rectangle.y + rectangle.height + 5;
        }
        if ((n = rectangle.x) < rectangle2.x) {
            n = rectangle2.x;
        } else if (n + this.tooltip.getWidth() > rectangle2.x + rectangle2.width) {
            n = rectangle2.x + rectangle2.width - this.tooltip.getWidth();
        }
        this.tooltip.setLocation(n, n2);
    }

    public void setVisible(boolean bl) {
        this.tooltip.setVisible(bl);
    }

    public boolean updateText(int n) {
        ParameterizedCompletion.Parameter parameter;
        String string;
        StringBuffer stringBuffer = new StringBuffer("<html>");
        int n2 = this.pc.getParamCount();
        for (int i = 0; i < n2; ++i) {
            if (i == n) {
                stringBuffer.append("<b>");
            }
            string = this.pc.getParam(i).toString();
            stringBuffer.append(RSyntaxUtilities.escapeForHtml(string, "<br>", false));
            if (i == n) {
                stringBuffer.append("</b>");
            }
            if (i >= n2 - 1) continue;
            stringBuffer.append(this.pc.getProvider().getParameterListSeparator());
        }
        if (n >= 0 && n < n2 && (string = (parameter = this.pc.getParam(n)).getDescription()) != null) {
            stringBuffer.append("<br>");
            stringBuffer.append(string);
        }
        this.descLabel.setText(stringBuffer.toString());
        this.tooltip.pack();
        return true;
    }

    public void updateUI() {
        SwingUtilities.updateComponentTreeUI(this.tooltip);
    }
}

