/*
 * Decompiled with CFR 0.152.
 */
package org.op.chess;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ImageProducer;
import java.beans.PropertyVetoException;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.op.chess.Move;
import org.op.chess.Square;

public class ChessBoard
extends JPanel {
    private static final int EMPTY = 6;
    private static final int[] START_COLOR;
    private static final int[] START_PIECE;
    private final Square[][] square = new Square[8][8];
    private boolean first = true;
    private final JLabel wtm;
    private final JLabel btm;
    private final JPanel mmPanel;
    private static Icon[][] pieceImage;
    private static final String[][] imageFilename;
    private int startCol;
    private int startRow;
    private int pieceSize = 32;
    private int squareSize = 42;
    private boolean moving = false;
    private Move move = null;

    public ChessBoard() {
        this.loadImages();
        JPanel boardPanel = new JPanel();
        boardPanel.setLayout(new GridLayout(10, 10));
        this.letterRow(boardPanel);
        int i = 0;
        while (i < 8) {
            boardPanel.add(new BLabel(this.convertNum(i, false)));
            int j = 0;
            while (j < 8) {
                this.square[i][j] = new Square(i, j, this);
                boardPanel.add(this.square[i][j]);
                ++j;
            }
            boardPanel.add(new BLabel(this.convertNum(i, false)));
            ++i;
        }
        this.letterRow(boardPanel);
        this.setupBoard();
        this.mmPanel = new JPanel();
        this.mmPanel.setLayout(new GridLayout(2, 1));
        ImageIcon whiteMoveIcon = new ImageIcon(this.getImage("wMove.gif"));
        this.wtm = new JLabel(whiteMoveIcon);
        ImageIcon blackMoveIcon = new ImageIcon(this.getImage("bMove.gif"));
        this.btm = new JLabel(blackMoveIcon);
        this.wtm.setVerticalAlignment(3);
        this.wtm.setHorizontalAlignment(0);
        this.wtm.setPreferredSize(new Dimension(104, 168));
        this.btm.setVerticalAlignment(1);
        this.btm.setHorizontalAlignment(0);
        this.btm.setPreferredSize(new Dimension(104, 168));
        this.btm.setVisible(false);
        this.mmPanel.add(this.btm);
        this.mmPanel.add(this.wtm);
        this.setLayout(new FlowLayout());
        this.add(boardPanel);
        this.add(this.mmPanel);
    }

    public void setupBoard() {
        int i = 0;
        while (i < 8) {
            int j = 0;
            while (j < 8) {
                int c = START_COLOR[j + 8 * i];
                if (c != 6) {
                    int p = START_PIECE[j + 8 * i];
                    this.square[i][j].setIcon(pieceImage[c][p]);
                } else {
                    this.square[i][j].setIcon(null);
                }
                ++j;
            }
            ++i;
        }
        this.first = true;
    }

    public void makeMove() {
        this.makeMove(this.move);
    }

    public void makeMove(Move move) {
        int fromCol = move.getFromCol();
        int fromRow = move.getFromRow();
        this.square[move.getToRow()][move.getToCol()].setIcon(this.square[fromRow][fromCol].getIcon());
        this.square[fromRow][fromCol].setIcon(null);
    }

    public void makeMoveWithPromote(Move move, int promote, boolean whiteToMove) {
        this.square[move.getToRow()][move.getToCol()].setIcon(pieceImage[whiteToMove ? 0 : 1][promote]);
        this.square[move.getFromRow()][move.getFromCol()].setIcon(null);
    }

    public void clear(int row, int col) {
        this.square[row][col].setIcon(null);
    }

    public void switchMoveMarkers(boolean whiteToMove) {
        if (whiteToMove) {
            this.wtm.setVisible(true);
            this.btm.setVisible(false);
        } else {
            this.btm.setVisible(true);
            this.wtm.setVisible(false);
        }
    }

    public int promotionDialog(boolean whiteMoving) {
        int index = whiteMoving ? 0 : 1;
        Object[] options = new Object[]{pieceImage[index][1], pieceImage[index][2], pieceImage[index][3], pieceImage[index][4]};
        int choice = JOptionPane.showOptionDialog(this, "Promote to which piece?", "Promotion", 1, 3, null, options, options[3]);
        if (choice == -1) {
            choice = 3;
        }
        return choice + 1;
    }

    public int getPieceSize() {
        return this.pieceSize;
    }

    public void setPieceSize(int size) {
        this.pieceSize = size;
    }

    public int getSquareSize() {
        return this.squareSize;
    }

    public void setSquareSize(int size) {
        this.squareSize = size;
    }

    public boolean isMoving() {
        return this.moving;
    }

    public void setMoving(boolean m) {
        this.moving = m;
    }

    public Move getMove() {
        return this.move;
    }

    void selected(int row, int col, boolean empty) {
        if (this.moving) {
            return;
        }
        if (this.first) {
            if (empty) {
                return;
            }
            this.startCol = col;
            this.startRow = row;
            this.first = false;
            return;
        }
        int from = (this.startRow << 3) + this.startCol;
        int to = (row << 3) + col;
        Move newMove = new Move(from, to);
        this.moving = true;
        try {
            this.fireVetoableChange("move", null, newMove);
            this.move = newMove;
            this.firePropertyChange("move", null, this.move);
        }
        catch (PropertyVetoException pve) {
            this.moving = false;
        }
        this.first = true;
    }

    private void letterRow(JPanel p) {
        p.add(new JPanel());
        int i = 0;
        while (i < 8) {
            p.add(new BLabel(this.convertNum(i, true)));
            ++i;
        }
        p.add(new JPanel());
    }

    private String convertNum(int temp, boolean first) {
        if (first) {
            return new Character((char)(97 + temp)).toString();
        }
        return Integer.toString(8 - temp);
    }

    private void loadImages() {
        int i = 0;
        while (i < 2) {
            int j = 0;
            while (j < 6) {
                ChessBoard.pieceImage[i][j] = new ImageIcon(this.getImage(imageFilename[i][j]));
                ++j;
            }
            ++i;
        }
    }

    private Image getImage(String path) {
        Toolkit tool = Toolkit.getDefaultToolkit();
        URL imURL = this.getClass().getResource("images/" + path);
        if (imURL == null) {
            throw new RuntimeException("Huh? No resource");
        }
        ImageProducer ip = null;
        try {
            ip = (ImageProducer)imURL.getContent();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return tool.createImage(ip);
    }

    static {
        EMPTY = 6;
        START_COLOR = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        START_PIECE = new int[]{3, 1, 2, 4, 5, 2, 1, 3, 0, 0, 0, 0, 0, 0, 0, 0, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 4, 5, 2, 1, 3};
        pieceImage = new ImageIcon[2][6];
        imageFilename = new String[][]{{"wp.gif", "wn.gif", "wb.gif", "wr.gif", "wq.gif", "wk.gif"}, {"bp.gif", "bn.gif", "bb.gif", "br.gif", "bq.gif", "bk.gif"}};
    }

    final class BLabel
    extends JLabel {
        BLabel(String s) {
            super(s);
            this.setHorizontalAlignment(0);
            this.setVerticalAlignment(0);
        }
    }
}

