/*
 * Decompiled with CFR 0.152.
 */
package org.jfugue.extras;

import org.jfugue.Note;
import org.jfugue.PatternTransformer;

public class DiatonicIntervalPatternTransformer
extends PatternTransformer {
    private int interval = 1;
    private static byte[] NoteToDegree = new byte[]{1, -2, 2, -3, 3, 4, -5, 5, -6, 6, -7, 7};
    private static byte[] DegreeToNote;

    static {
        byte[] byArray = new byte[14];
        byArray[0] = -128;
        byArray[2] = 2;
        byArray[3] = 4;
        byArray[4] = 5;
        byArray[5] = 7;
        byArray[6] = 9;
        byArray[7] = 11;
        byArray[8] = 12;
        byArray[9] = 14;
        byArray[10] = 16;
        byArray[11] = 17;
        byArray[12] = 19;
        byArray[13] = 21;
        DegreeToNote = byArray;
    }

    public DiatonicIntervalPatternTransformer(int interval) {
        this.interval = interval;
    }

    private Note adjustNote(Note note, int interval) {
        boolean isPassingNote;
        int octave = 0;
        int noteValue = note.getValue();
        if (interval > 7) {
            octave = interval / 8;
            interval = (interval + 1) % 8;
        } else if (interval < 1) {
            System.err.println("Error! DiatonicIntervalPatternTransformer can handle only positive intervals (" + interval + ")");
        }
        byte scaleDegree = NoteToDegree[noteValue % 12];
        boolean bl = isPassingNote = scaleDegree < 0;
        if (isPassingNote) {
            scaleDegree = -scaleDegree;
            ++noteValue;
        }
        noteValue += DegreeToNote[scaleDegree + interval - 1] - DegreeToNote[scaleDegree];
        if (isPassingNote) {
            --noteValue;
        }
        if ((noteValue += octave * 12) > 128 || noteValue < 0) {
            System.err.println("Warning! Note value overflow (" + noteValue + ") in DiatonicIntervalPatternTransformer");
            noteValue %= 128;
        }
        note.setValue((byte)noteValue);
        return note;
    }

    public void noteEvent(Note note) {
        note = this.adjustNote(note, this.interval);
        this.getReturnPattern().addElement(note);
    }

    public void sequentialNoteEvent(Note note) {
        note = this.adjustNote(note, this.interval);
        this.getReturnPattern().addElement(note);
    }

    public void parallelNoteEvent(Note note) {
        note = this.adjustNote(note, this.interval);
        this.getReturnPattern().addElement(note);
    }
}

