/*
 * Decompiled with CFR 0.152.
 */
package org.jfugue;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaEventListener;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiFileFormat;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Synthesizer;
import org.jfugue.Anticipator;
import org.jfugue.JFugueException;
import org.jfugue.MidiRenderer;
import org.jfugue.MusicStringParser;
import org.jfugue.Pattern;
import org.jfugue.Rhythm;

public class Player {
    private Sequencer sequencer;
    private MusicStringParser parser;
    private MidiRenderer renderer;
    private float sequenceTiming = 0.0f;
    private int resolution = 120;
    private boolean paused = false;
    private boolean started = false;
    private boolean finished = false;

    public Player() {
        this(true);
    }

    public Player(boolean connected) {
        try {
            this.setSequencer(MidiSystem.getSequencer(connected));
        }
        catch (MidiUnavailableException e) {
            throw new JFugueException("The MIDI System cannot instantiate a sequencer.  Although this error is reported by JFugue, the problem is not with JFugue itself.  Find resources for using MIDI on your specific system.  The exception message from MidiSystem.getSequencer() is: " + e.getMessage());
        }
        this.initParser();
    }

    public Player(Sequencer sequencer) {
        this.setSequencer(sequencer);
        this.initParser();
    }

    public Player(Synthesizer synth) throws MidiUnavailableException {
        this(Player.getSequencerConnectedToSynthesizer(synth));
    }

    private void initParser() {
        this.parser = new MusicStringParser();
        this.renderer = new MidiRenderer(this.sequenceTiming, this.resolution);
        this.parser.addParserListener(this.renderer);
    }

    private void initSequencer() {
        this.getSequencer().addMetaEventListener(new MetaEventListener(){

            public void meta(MetaMessage event) {
                if (event.getType() == 47) {
                    Player.this.close();
                }
            }
        });
    }

    private void openSequencer() {
        if (this.getSequencer() == null) {
            throw new JFugueException("The MIDI System cannot instantiate a sequencer.  Although this error is reported by JFugue, the problem is not with JFugue itself.  Find resources for using MIDI on your specific system.");
        }
        if (!this.getSequencer().isOpen()) {
            try {
                this.getSequencer().open();
            }
            catch (MidiUnavailableException e) {
                throw new JFugueException("The MIDI System cannot instantiate a sequencer.  Although this error is reported by JFugue, the problem is not with JFugue itself.  Find resources for using MIDI on your specific system.  The exception message from MidiSystem.getSequencer() is: " + e.getMessage());
            }
        }
    }

    public void play(Pattern pattern) {
        Sequence sequence = this.getSequence(pattern);
        this.play(sequence);
    }

    public void play(Rhythm rhythm) {
        Pattern pattern = rhythm.getPattern();
        Sequence sequence = this.getSequence(pattern);
        this.play(sequence);
    }

    private void play(Sequence sequence) {
        this.openSequencer();
        try {
            this.getSequencer().setSequence(sequence);
        }
        catch (Exception e) {
            throw new JFugueException("Error playing music: " + e.getMessage());
        }
        this.setStarted(true);
        this.getSequencer().start();
        while (this.isPlaying() || this.isPaused()) {
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException e) {
                throw new JFugueException("Error while sleeping");
            }
        }
        this.getSequencer().close();
        this.setStarted(false);
        this.setFinished(true);
    }

    public void play(String musicString) {
        if (musicString.indexOf(".mid") > 0) {
            throw new JFugueException("play(String) plays a music string, not a filename.  Try using play(File).");
        }
        Pattern pattern = new Pattern(musicString);
        this.play(pattern);
    }

    public void playMidiDirectly(File file) throws IOException, InvalidMidiDataException {
        Sequence sequence = MidiSystem.getSequence(file);
        this.play(sequence);
    }

    public void playMidiDirectly(URL url) throws IOException, InvalidMidiDataException {
        Sequence sequence = MidiSystem.getSequence(url);
        this.play(sequence);
    }

    public void play(Anticipator anticipator, Pattern pattern, long offset) {
        Sequence sequence = this.getSequence(pattern);
        Sequence sequence2 = this.getSequence(pattern);
        this.play(anticipator, sequence, sequence2, offset);
    }

    public void play(Anticipator anticipator, Sequence sequence, Sequence sequence2, long offset) {
        anticipator.play(sequence);
        if (offset > 0L) {
            try {
                Thread.sleep(offset);
            }
            catch (InterruptedException e) {
                throw new JFugueException("Error while sleeping");
            }
        }
        this.play(sequence2);
    }

    public void close() {
        this.getSequencer().close();
        try {
            if (MidiSystem.getSynthesizer() != null) {
                MidiSystem.getSynthesizer().close();
            }
        }
        catch (MidiUnavailableException e) {
            throw new JFugueException("General error: " + e.getMessage());
        }
    }

    private void setStarted(boolean started) {
        this.started = started;
    }

    private void setFinished(boolean finished) {
        this.finished = finished;
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public boolean isPlaying() {
        return this.getSequencer().isRunning();
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void pause() {
        this.paused = true;
        if (this.isPlaying()) {
            this.getSequencer().stop();
        }
    }

    public void resume() {
        this.paused = false;
        this.getSequencer().start();
    }

    public void stop() {
        this.paused = false;
        this.getSequencer().stop();
        this.getSequencer().setMicrosecondPosition(0L);
    }

    public void jumpTo(long microseconds) {
        this.getSequencer().setMicrosecondPosition(microseconds);
    }

    public long getSequenceLength(Sequence sequence) {
        return sequence.getMicrosecondLength();
    }

    public long getSequencePosition() {
        return this.getSequencer().getMicrosecondPosition();
    }

    public void saveMidi(Pattern pattern, File file) throws IOException {
        Sequence sequence = this.getSequence(pattern);
        int[] writers = MidiSystem.getMidiFileTypes(sequence);
        if (writers.length == 0) {
            return;
        }
        MidiSystem.write(sequence, writers[0], file);
    }

    public void saveMidi(String musicString, File file) throws IOException {
        Pattern pattern = new Pattern(musicString);
        this.saveMidi(pattern, file);
    }

    public Pattern loadMidi(File file) throws IOException, InvalidMidiDataException {
        MidiFileFormat format = MidiSystem.getMidiFileFormat(file);
        this.sequenceTiming = format.getDivisionType();
        this.resolution = format.getResolution();
        return Pattern.loadMidi(file);
    }

    public static void allNotesOff() {
        try {
            Player.allNotesOff(MidiSystem.getSynthesizer());
        }
        catch (MidiUnavailableException e) {
            throw new JFugueException("General error: ");
        }
    }

    public static void allNotesOff(Synthesizer synth) {
        try {
            if (!synth.isOpen()) {
                synth.open();
            }
            MidiChannel[] channels = synth.getChannels();
            int i = 0;
            while (i < channels.length) {
                channels[i].allNotesOff();
                ++i;
            }
        }
        catch (MidiUnavailableException e) {
            throw new JFugueException("General error: ");
        }
    }

    public Sequencer getSequencer() {
        return this.sequencer;
    }

    private void setSequencer(Sequencer sequencer) {
        this.sequencer = sequencer;
        this.initSequencer();
    }

    public Sequence getSequence(Pattern pattern) {
        this.renderer.reset();
        this.parser.parse(pattern);
        Sequence sequence = this.renderer.getSequence();
        return sequence;
    }

    public static Sequencer getSequencerConnectedToSynthesizer(Synthesizer synth) throws MidiUnavailableException {
        Sequencer sequencer = MidiSystem.getSequencer(false);
        sequencer.open();
        if (!synth.isOpen()) {
            synth.open();
        }
        sequencer.getTransmitter().setReceiver(synth.getReceiver());
        return sequencer;
    }
}

