/*
 * Decompiled with CFR 0.152.
 */
package org.jfugue;

import org.jfugue.JFugueElement;

public final class Note
implements JFugueElement {
    private byte value = 0;
    private long duration = 0L;
    private double decimalDuration = 0.0;
    private boolean isStartOfTie = false;
    private boolean isEndOfTie = false;
    private byte attackVelocity = (byte)64;
    private byte decayVelocity = (byte)64;
    private boolean rest = false;
    private byte type = 0;
    private boolean accompanyingNotes = false;
    public static final byte FIRST = 0;
    public static final byte SEQUENTIAL = 1;
    public static final byte PARALLEL = 2;
    public static final byte DEFAULT_VELOCITY = 64;
    public static final String[] NOTES = new String[]{"C", "C#", "D", "Eb", "E", "F", "F#", "G", "G#", "A", "Bb", "B"};
    public static final byte ACOUSTIC_BASS_DRUM = 35;
    public static final byte BASS_DRUM = 36;
    public static final byte SIDE_STICK = 37;
    public static final byte ACOUSTIC_SNARE = 38;
    public static final byte HAND_CLAP = 39;
    public static final byte ELECTRIC_SNARE = 40;
    public static final byte LOW_FLOOR_TOM = 41;
    public static final byte CLOSED_HI_HAT = 42;
    public static final byte HIGH_FLOOR_TOM = 43;
    public static final byte PEDAL_HI_HAT = 44;
    public static final byte LOW_TOM = 45;
    public static final byte OPEN_HI_HAT = 46;
    public static final byte LOW_MID_TOM = 47;
    public static final byte HI_MID_TOM = 48;
    public static final byte CRASH_CYMBAL_1 = 49;
    public static final byte HIGH_TOM = 50;
    public static final byte RIDE_CYMBAL_1 = 51;
    public static final byte CHINESE_CYMBAL = 52;
    public static final byte RIDE_BELL = 53;
    public static final byte TAMBOURINE = 54;
    public static final byte SPLASH_CYMBAL = 55;
    public static final byte COWBELL = 56;
    public static final byte CRASH_CYMBAL_2 = 57;
    public static final byte VIBRASLAP = 58;
    public static final byte RIDE_CYMBAL_2 = 59;
    public static final byte HI_BONGO = 60;
    public static final byte LOW_BONGO = 61;
    public static final byte MUTE_HI_CONGA = 62;
    public static final byte OPEN_HI_CONGA = 63;
    public static final byte LOW_CONGA = 64;
    public static final byte HIGH_TIMBALE = 65;
    public static final byte LOW_TIMBALE = 66;
    public static final byte HIGH_AGOGO = 67;
    public static final byte LOW_AGOGO = 68;
    public static final byte CABASA = 69;
    public static final byte MARACAS = 70;
    public static final byte SHORT_WHISTLE = 71;
    public static final byte LONG_WHISTLE = 72;
    public static final byte SHORT_GUIRO = 73;
    public static final byte LONG_GUIRO = 74;
    public static final byte CLAVES = 75;
    public static final byte HI_WOOD_BLOCK = 76;
    public static final byte LOW_WOOD_BLOCK = 77;
    public static final byte MUTE_CUICA = 78;
    public static final byte OPEN_CUICA = 79;
    public static final byte MUTE_TRIANGLE = 80;
    public static final byte OPEN_TRIANGLE = 81;

    public Note() {
        this.value = 0;
        this.duration = 0L;
        this.type = 0;
    }

    public Note(byte value) {
        this(value, 1L);
    }

    public Note(byte value, long duration) {
        this.value = value;
        this.duration = duration;
    }

    public Note(byte value, double decimalDuration) {
        this.value = value;
        this.decimalDuration = decimalDuration;
    }

    public Note(byte value, long duration, byte attackVelocity, byte decayVelocity) {
        this.value = value;
        this.duration = duration;
        this.attackVelocity = attackVelocity;
        this.decayVelocity = decayVelocity;
    }

    public Note(byte value, double decimalDuration, byte attackVelocity, byte decayVelocity) {
        this.value = value;
        this.decimalDuration = decimalDuration;
        this.attackVelocity = attackVelocity;
        this.decayVelocity = decayVelocity;
    }

    public void setRest(boolean rest) {
        this.rest = rest;
    }

    public boolean isRest() {
        return this.rest;
    }

    public void setValue(byte value) {
        this.value = value;
    }

    public byte getValue() {
        return this.value;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDecimalDuration(double duration) {
        this.decimalDuration = duration;
    }

    public double getDecimalDuration() {
        return this.decimalDuration;
    }

    public void setStartOfTie(boolean startOfTie) {
        this.isStartOfTie = startOfTie;
    }

    public boolean isStartOfTie() {
        return this.isStartOfTie;
    }

    public void setEndOfTie(boolean endOfTie) {
        this.isEndOfTie = endOfTie;
    }

    public boolean isEndOfTie() {
        return this.isEndOfTie;
    }

    public void setAttackVelocity(byte velocity) {
        this.attackVelocity = velocity;
    }

    public byte getAttackVelocity() {
        return this.attackVelocity;
    }

    public void setDecayVelocity(byte velocity) {
        this.decayVelocity = velocity;
    }

    public byte getDecayVelocity() {
        return this.decayVelocity;
    }

    public void setHasAccompanyingNotes(boolean accompanying) {
        this.accompanyingNotes = accompanying;
    }

    public boolean hasAccompanyingNotes() {
        return this.accompanyingNotes;
    }

    public void setType(byte type) {
        this.type = type;
    }

    public byte getType() {
        return this.type;
    }

    public String getMusicString() {
        StringBuffer buffy = new StringBuffer();
        if (1 == this.type) {
            buffy.append("_");
        } else if (2 == this.type) {
            buffy.append("+");
        }
        buffy.append(Note.getStringForNote(this.value, this.decimalDuration));
        if (this.attackVelocity != 64) {
            buffy.append("a");
            buffy.append(this.attackVelocity);
        }
        if (this.decayVelocity != 64) {
            buffy.append("d");
            buffy.append(this.decayVelocity);
        }
        return buffy.toString();
    }

    public String getVerifyString() {
        StringBuffer buffy = new StringBuffer();
        buffy.append("Note: value=");
        buffy.append(this.getValue());
        buffy.append(", duration=");
        buffy.append(this.getDecimalDuration());
        buffy.append(", startTie=");
        buffy.append(this.isStartOfTie() ? "T" : "F");
        buffy.append(", endTie=");
        buffy.append(this.isEndOfTie() ? "T" : "F");
        buffy.append(", attack=");
        buffy.append(this.getAttackVelocity());
        buffy.append(", decay=");
        buffy.append(this.getDecayVelocity());
        buffy.append(", isFirst=");
        buffy.append(this.getType() == 0 ? "T" : "F");
        buffy.append(", isParallel=");
        buffy.append(this.getType() == 2 ? "T" : "F");
        buffy.append(", isSequential=");
        buffy.append(this.getType() == 1 ? "T" : "F");
        return buffy.toString();
    }

    public static String createVerifyString(int value, double duration) {
        return Note.createVerifyString(value, duration, false, false, 64, 64, true, false, false);
    }

    public static String createVerifyString(int value, double duration, boolean startTie, boolean endTie) {
        return Note.createVerifyString(value, duration, startTie, endTie, 64, 64, true, false, false);
    }

    public static String createVerifyString(int value, double duration, int attack, int decay) {
        return Note.createVerifyString(value, duration, false, false, attack, decay, true, false, false);
    }

    public static String createVerifyString(int value, double duration, boolean isFirst, boolean isParallel, boolean isSequential) {
        return Note.createVerifyString(value, duration, false, false, 64, 64, isFirst, isParallel, isSequential);
    }

    public static String createVerifyString(int value, double duration, boolean startTie, boolean endTie, int attack, int decay, boolean isFirst, boolean isParallel, boolean isSequential) {
        StringBuffer buffy = new StringBuffer();
        buffy.append("Note: value=");
        buffy.append(value);
        buffy.append(", duration=");
        buffy.append(duration);
        buffy.append(", startTie=");
        buffy.append(startTie ? "T" : "F");
        buffy.append(", endTie=");
        buffy.append(endTie ? "T" : "F");
        buffy.append(", attack=");
        buffy.append(attack);
        buffy.append(", decay=");
        buffy.append(decay);
        buffy.append(", isFirst=");
        buffy.append(isFirst ? "T" : "F");
        buffy.append(", isParallel=");
        buffy.append(isParallel ? "T" : "F");
        buffy.append(", isSequential=");
        buffy.append(isSequential ? "T" : "F");
        return buffy.toString();
    }

    public static String createCompoundVerifyString(String ... strings) {
        StringBuffer buffy = new StringBuffer();
        String[] stringArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            buffy.append(string);
            buffy.append("; ");
            ++n2;
        }
        return buffy.toString().substring(0, buffy.toString().length() - 2);
    }

    public static String getStringForNote(byte noteValue, double decimalDuration) {
        StringBuffer buffy = new StringBuffer();
        buffy.append(Note.getStringForNote(noteValue));
        buffy.append(Note.getStringForDuration(decimalDuration));
        return buffy.toString();
    }

    public static double getFrequencyForNote(int noteValue) {
        double freq = 0.0;
        double freq0 = 8.1757989156;
        double d = 0.0;
        while (d <= (double)noteValue) {
            freq = freq0 * Math.pow(2.0, d / 12.0);
            d += 1.0;
        }
        double retVal = Math.rint(freq * 10000.0) / 10000.0;
        return retVal;
    }

    public static String getStringForNote(byte noteValue) {
        int note = noteValue % 12;
        int octave = noteValue / 12;
        StringBuffer buffy = new StringBuffer();
        buffy.append(NOTES[note]);
        buffy.append(octave);
        return buffy.toString();
    }

    public static String getStringForDuration(double decimalDuration) {
        if (decimalDuration == 1.0) {
            return "w";
        }
        if (decimalDuration == 0.75) {
            return "h.";
        }
        if (decimalDuration == 0.5) {
            return "h";
        }
        if (decimalDuration == 0.375) {
            return "q.";
        }
        if (decimalDuration == 0.25) {
            return "q";
        }
        if (decimalDuration == 0.1875) {
            return "i.";
        }
        if (decimalDuration == 0.125) {
            return "i";
        }
        if (decimalDuration == 0.09375) {
            return "s.";
        }
        if (decimalDuration == 0.0625) {
            return "s";
        }
        if (decimalDuration == 0.046875) {
            return "t.";
        }
        if (decimalDuration == 0.03125) {
            return "t";
        }
        if (decimalDuration == 0.0234375) {
            return "x.";
        }
        if (decimalDuration == 0.015625) {
            return "x";
        }
        if (decimalDuration == 0.01171875) {
            return "o.";
        }
        if (decimalDuration == 0.0078125) {
            return "o";
        }
        return "/" + decimalDuration;
    }

    public static double getDecimalForDuration(String stringDuration) {
        String stringDuration2 = stringDuration.toLowerCase();
        if (stringDuration2.equals("w")) {
            return 1.0;
        }
        if (stringDuration2.equals("h.")) {
            return 0.75;
        }
        if (stringDuration2.equals("h")) {
            return 0.5;
        }
        if (stringDuration2.equals("q.")) {
            return 0.375;
        }
        if (stringDuration2.equals("q")) {
            return 0.25;
        }
        if (stringDuration2.equals("i.")) {
            return 0.1875;
        }
        if (stringDuration2.equals("i")) {
            return 0.125;
        }
        if (stringDuration2.equals("s.")) {
            return 0.09375;
        }
        if (stringDuration2.equals("s")) {
            return 0.0625;
        }
        if (stringDuration2.equals("t.")) {
            return 0.046875;
        }
        if (stringDuration2.equals("t")) {
            return 0.03125;
        }
        if (stringDuration2.equals("x.")) {
            return 0.0234375;
        }
        if (stringDuration2.equals("x")) {
            return 0.015625;
        }
        if (stringDuration2.equals("o.")) {
            return 0.01171875;
        }
        if (stringDuration2.equals("o")) {
            return 0.0078125;
        }
        return 0.0;
    }
}

