/*
 * Decompiled with CFR 0.152.
 */
package org.jfugue;

import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Sequence;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.SysexMessage;
import javax.sound.midi.Track;
import org.jfugue.ChannelPressure;
import org.jfugue.Controller;
import org.jfugue.Instrument;
import org.jfugue.Note;
import org.jfugue.Parser;
import org.jfugue.PitchBend;
import org.jfugue.PolyphonicPressure;
import org.jfugue.Tempo;
import org.jfugue.Time;
import org.jfugue.TimeFactor;
import org.jfugue.Voice;

public final class MidiParser
extends Parser {
    long[][] tempNoteRegistry = new long[16][255];
    byte[][] tempNoteAttackRegistry = new byte[16][255];
    int tempo = 120;
    private static final int DEFAULT_TEMPO = 120;

    public MidiParser() {
        int m = 0;
        while (m < 16) {
            int n = 0;
            while (n < 255) {
                this.tempNoteRegistry[m][n] = 0L;
                this.tempNoteAttackRegistry[m][n] = 0;
                ++n;
            }
            ++m;
        }
    }

    public void parse(Sequence sequence) {
        this.tempo = 120;
        Track[] tracks = sequence.getTracks();
        long totalCount = 0L;
        long counter = 0L;
        int i = 0;
        while (i < tracks.length) {
            totalCount += (long)tracks[i].size();
            i = (byte)(i + 1);
        }
        int t = 0;
        while (t < tracks.length) {
            int trackSize = tracks[t].size();
            if (trackSize > 0) {
                this.fireVoiceEvent(new Voice((byte)t));
                int ev = 0;
                while (ev < trackSize) {
                    this.fireProgressReported("Parsing MIDI...", ++counter, totalCount);
                    MidiEvent event = tracks[t].get(ev);
                    MidiMessage message = event.getMessage();
                    this.trace("Message received: ", message);
                    this.parse(message, event.getTick());
                    ++ev;
                }
            }
            ++t;
        }
    }

    public void parse(MidiMessage message, long timestamp) {
        if (message instanceof ShortMessage) {
            this.parseShortMessage((ShortMessage)message, timestamp);
        } else if (message instanceof SysexMessage) {
            this.parseSysexMessage((SysexMessage)message, timestamp);
        } else if (message instanceof MetaMessage) {
            this.parseMetaMessage((MetaMessage)message, timestamp);
        }
    }

    private void parseShortMessage(ShortMessage message, long timestamp) {
        int track = message.getChannel();
        switch (message.getCommand()) {
            case 192: {
                this.trace("Program change to ", message.getData1());
                Instrument instrument = new Instrument((byte)message.getData1());
                this.fireTimeEvent(new Time(timestamp));
                this.fireVoiceEvent(new Voice((byte)track));
                this.fireInstrumentEvent(instrument);
                break;
            }
            case 176: {
                this.trace("Controller change to ", message.getData1(), ", value = ", message.getData2());
                Controller controller = new Controller((byte)message.getData1(), (byte)message.getData2());
                this.fireTimeEvent(new Time(timestamp));
                this.fireVoiceEvent(new Voice((byte)track));
                this.fireControllerEvent(controller);
                break;
            }
            case 144: {
                if (message.getData2() == 0) {
                    this.noteOffEvent(timestamp, track, message.getData1(), message.getData2());
                    break;
                }
                this.noteOnEvent(timestamp, track, message.getData1(), message.getData2());
                break;
            }
            case 128: {
                this.noteOffEvent(timestamp, track, message.getData1(), message.getData2());
                break;
            }
            case 208: {
                this.trace("Channel pressure, pressure = ", message.getData1());
                ChannelPressure pressure = new ChannelPressure((byte)message.getData1());
                this.fireTimeEvent(new Time(timestamp));
                this.fireVoiceEvent(new Voice((byte)track));
                this.fireChannelPressureEvent(pressure);
                break;
            }
            case 160: {
                this.trace("Poly pressure on key ", message.getData1(), ", pressure = ", message.getData2());
                PolyphonicPressure poly = new PolyphonicPressure((byte)message.getData1(), (byte)message.getData2());
                this.fireTimeEvent(new Time(timestamp));
                this.fireVoiceEvent(new Voice((byte)track));
                this.firePolyphonicPressureEvent(poly);
                break;
            }
            case 224: {
                this.trace("Pitch Bend, data1= ", message.getData1(), ", data2= ", message.getData2());
                PitchBend bend = new PitchBend((byte)message.getData1(), (byte)message.getData2());
                this.fireTimeEvent(new Time(timestamp));
                this.fireVoiceEvent(new Voice((byte)track));
                this.firePitchBendEvent(bend);
                break;
            }
            default: {
                this.trace("Unparsed message: ", message.getCommand());
            }
        }
    }

    private void noteOnEvent(long timestamp, int track, int data1, int data2) {
        this.trace("Note on ", data1, " - attack is ", data2);
        this.tempNoteRegistry[track][data1] = timestamp;
        this.tempNoteAttackRegistry[track][data1] = (byte)data2;
        Note note = new Note((byte)data1, 0L);
        note.setDecimalDuration(0.0);
        note.setAttackVelocity((byte)data2);
        this.fireNoteEvent(note);
    }

    private void noteOffEvent(long timestamp, int track, int data1, int data2) {
        long time = this.tempNoteRegistry[track][data1];
        this.trace("Note off ", data1, " - decay is ", data2, ". Duration is ", timestamp - time);
        this.fireTimeEvent(new Time(time));
        this.fireVoiceEvent(new Voice((byte)track));
        Note note = new Note((byte)data1, timestamp - time);
        note.setDecimalDuration((double)(timestamp - time) / ((double)this.tempo * 4.0));
        note.setAttackVelocity(this.tempNoteAttackRegistry[track][data1]);
        note.setDecayVelocity((byte)data2);
        this.fireNoteEvent(note);
        this.tempNoteRegistry[track][data1] = 0L;
    }

    private void parseSysexMessage(SysexMessage message, long timestamp) {
        this.trace("SysexMessage received but not parsed by JFugue (doesn't use them)");
    }

    private void parseMetaMessage(MetaMessage message, long timestamp) {
        switch (message.getType()) {
            case 81: {
                this.parseTempo(message, timestamp);
                break;
            }
            case 89: {
                break;
            }
        }
        this.trace("MetaMessage received but not parsed by JFugue (doesn't use them)");
    }

    private void parseTempo(MetaMessage message, long timestamp) {
        int beatsPerMinute = TimeFactor.parseMicrosecondsPerBeat(message, timestamp);
        this.trace("Tempo Event, bpm = ", beatsPerMinute);
        this.fireTimeEvent(new Time(timestamp));
        this.fireTempoEvent(new Tempo(beatsPerMinute));
        this.tempo = beatsPerMinute;
    }
}

