/*
 * Decompiled with CFR 0.152.
 */
package org.jfugue;

import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.Sequence;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Track;

public final class MidiEventManager {
    private final int CHANNELS = 16;
    private final int LAYERS = 16;
    private byte currentTrack = 0;
    private byte[] currentLayer = new byte[16];
    private long[][] time = new long[16][16];
    private Sequence sequence;
    private Track[] track = new Track[16];

    public MidiEventManager(float sequenceTiming, int resolution) {
        try {
            this.sequence = new Sequence(sequenceTiming, resolution);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int i = 0;
        while (i < 16) {
            int u = 0;
            while (u < 16) {
                this.time[i][u] = 0L;
                ++u;
            }
            this.currentLayer[i] = 0;
            this.track[i] = this.sequence.createTrack();
            ++i;
        }
        this.currentTrack = 0;
    }

    public void setCurrentTrack(byte track) {
        this.currentTrack = track;
    }

    public void setCurrentLayer(byte layer) {
        this.currentLayer[this.currentTrack] = layer;
    }

    public void advanceTrackTimer(long duration) {
        long[] lArray = this.time[this.currentTrack];
        byte by = this.currentLayer[this.currentTrack];
        lArray[by] = lArray[by] + duration;
    }

    public void setTrackTimer(long newTime) {
        this.time[this.currentTrack][this.currentLayer[this.currentTrack]] = newTime;
    }

    public long getTrackTimer() {
        return this.time[this.currentTrack][this.currentLayer[this.currentTrack]];
    }

    public void addMetaMessage(int type, byte[] bytes) {
        try {
            MetaMessage message = new MetaMessage();
            message.setMessage(type, bytes, bytes.length);
            MidiEvent event = new MidiEvent(message, this.getTrackTimer());
            this.track[this.currentTrack].add(event);
        }
        catch (InvalidMidiDataException e) {
            e.printStackTrace();
        }
    }

    public void addEvent(int command, int data1) {
        try {
            ShortMessage message = new ShortMessage();
            message.setMessage(command, this.currentTrack, data1);
            MidiEvent event = new MidiEvent(message, this.getTrackTimer());
            this.track[this.currentTrack].add(event);
        }
        catch (InvalidMidiDataException e) {
            e.printStackTrace();
        }
    }

    public void addEvent(int command, int data1, int data2) {
        try {
            ShortMessage message = new ShortMessage();
            message.setMessage(command, this.currentTrack, data1, data2);
            MidiEvent event = new MidiEvent(message, this.getTrackTimer());
            this.track[this.currentTrack].add(event);
        }
        catch (InvalidMidiDataException e) {
            e.printStackTrace();
        }
    }

    public void addNoteEvent(int data1, int data2, int data3, long duration, boolean addNoteOn, boolean addNoteOff) {
        try {
            if (addNoteOn) {
                ShortMessage message = new ShortMessage();
                message.setMessage(144, this.currentTrack, data1, data2);
                MidiEvent event = new MidiEvent(message, this.getTrackTimer());
                this.track[this.currentTrack].add(event);
            }
            this.advanceTrackTimer(duration);
            if (addNoteOff) {
                ShortMessage message2 = new ShortMessage();
                message2.setMessage(128, this.currentTrack, data1, data3);
                MidiEvent event2 = new MidiEvent(message2, this.getTrackTimer());
                this.track[this.currentTrack].add(event2);
            }
        }
        catch (InvalidMidiDataException e) {
            e.printStackTrace();
        }
    }

    public Sequence getSequence() {
        return this.sequence;
    }
}

