/*
 * Decompiled with CFR 0.152.
 */
package org.jfugue;

import java.util.HashMap;
import java.util.Map;
import org.jfugue.Pattern;

public class MicrotoneNotation {
    private Map<String, Double> keyToFreqDict = new HashMap<String, Double>();
    private Map<String, String> keyToMusicStringDict = new HashMap<String, String>();

    public void put(String key, double freq) {
        this.keyToFreqDict.put(key, freq);
        this.keyToMusicStringDict.put(key, MicrotoneNotation.convertFrequencyToMusicString(freq));
    }

    public double get(String key) {
        return this.keyToFreqDict.get(key);
    }

    public String getMusicString(String key) {
        return this.keyToMusicStringDict.get(key);
    }

    public static String convertFrequencyToMusicString(double freq) {
        double totalCents = 1200.0 * Math.log(freq / 16.3515978312876) / Math.log(2.0);
        double octave = Math.round(totalCents / 1200.0);
        double semitoneCents = totalCents - octave * 1200.0;
        double semitone = Math.round(semitoneCents / 100.0);
        double cents = 8192L + Math.round(semitoneCents - semitone * 100.0);
        double note = (octave + 1.0) * 12.0 + semitone;
        if (note > 127.0) {
            note = 127.0;
        }
        StringBuilder buffy = new StringBuilder();
        buffy.append("&");
        buffy.append((int)cents);
        buffy.append(" [");
        buffy.append((int)note);
        buffy.append("]");
        return buffy.toString();
    }

    public static String getResetPitchWheelString() {
        return " &8192";
    }

    public Pattern getPattern(String notation) {
        StringBuilder buddy = new StringBuilder();
        String[] tokens = notation.split(" ");
        int i = 0;
        while (i < tokens.length) {
            if (tokens[i].length() > 0 && tokens[i].charAt(0) == '<') {
                int end = tokens[i].indexOf(62);
                String possibleKey = tokens[i].substring(1, end);
                if (this.keyToMusicStringDict.containsKey(possibleKey)) {
                    buddy.append(this.keyToMusicStringDict.get(possibleKey));
                    buddy.append(tokens[i].substring(end + 1, tokens[i].length()));
                    buddy.append(MicrotoneNotation.getResetPitchWheelString());
                } else {
                    buddy.append(tokens[i]);
                }
            } else {
                buddy.append(tokens[i]);
            }
            buddy.append(" ");
            ++i;
        }
        return new Pattern(buddy.toString());
    }
}

