/*
 * Decompiled with CFR 0.152.
 */
package org.jfugue;

import org.jfugue.Instrument;
import org.jfugue.JFugueException;
import org.jfugue.Note;
import org.jfugue.ParserListenerAdapter;
import org.jfugue.Tempo;
import org.jfugue.Voice;

public abstract class EasyAnticipatorListener
extends ParserListenerAdapter {
    private Voice activeVoice = new Voice(0);
    private Instrument activeInstrument = new Instrument(0);
    private int tempo;

    public void tempoEvent(Tempo tempo) {
        this.tempo = tempo.getTempo();
        System.out.println("tempo = " + tempo.getTempo());
    }

    public void voiceEvent(Voice voice) {
        this.activeVoice = voice;
    }

    public void instrumentEvent(Instrument instrument) {
        this.activeInstrument = instrument;
    }

    public void noteEvent(Note note) {
        this.extendedNoteEvent(this.activeVoice, this.activeInstrument, note);
    }

    public void parallelNoteEvent(Note note) {
        this.extendedNoteEvent(this.activeVoice, this.activeInstrument, note);
    }

    public void sequentialNoteEvent(Note note) {
        this.extendedNoteEvent(this.activeVoice, this.activeInstrument, note);
    }

    private void sleep(long durationInPPQ) {
        try {
            long msec = durationInPPQ / 4L;
            Thread.sleep(msec);
        }
        catch (InterruptedException e) {
            throw new JFugueException("Error while sleeping");
        }
    }

    public abstract void extendedNoteEvent(Voice var1, Instrument var2, Note var3);
}

