/*
 * Decompiled with CFR 0.152.
 */
package org.alicebot.ab;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.alicebot.ab.AIMLProcessor;
import org.alicebot.ab.Chat;
import org.alicebot.ab.MagicBooleans;
import org.alicebot.ab.MagicStrings;
import org.alicebot.ab.utils.CalendarUtils;
import org.alicebot.ab.utils.NetworkUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class Sraix {
    public static HashMap<String, String> custIdMap = new HashMap();
    public static String custid = "1";

    public static String sraix(Chat chatSession, String input, String defaultResponse, String hint, String host, String botid, String apiKey, String limit) {
        String response = !MagicBooleans.enable_network_connection ? MagicStrings.sraix_failed : (host != null && botid != null ? Sraix.sraixPandorabots(input, chatSession, host, botid) : Sraix.sraixPannous(input, hint, chatSession));
        System.out.println("Sraix: response = " + response + " defaultResponse = " + defaultResponse);
        if (response.equals(MagicStrings.sraix_failed)) {
            if (chatSession != null && defaultResponse == null) {
                response = AIMLProcessor.respond(MagicStrings.sraix_failed, "nothing", "nothing", chatSession);
            } else if (defaultResponse != null) {
                response = defaultResponse;
            }
        }
        return response;
    }

    public static String sraixPandorabots(String input, Chat chatSession, String host, String botid) {
        String responseContent = Sraix.pandorabotsRequest(input, host, botid);
        if (responseContent == null) {
            return MagicStrings.sraix_failed;
        }
        return Sraix.pandorabotsResponse(responseContent, chatSession, host, botid);
    }

    public static String pandorabotsRequest(String input, String host, String botid) {
        try {
            custid = "0";
            String key = host + ":" + botid;
            if (custIdMap.containsKey(key)) {
                custid = custIdMap.get(key);
            }
            String spec = NetworkUtils.spec(host, botid, custid, input);
            if (MagicBooleans.trace_mode) {
                System.out.println("Spec = " + spec);
            }
            String responseContent = NetworkUtils.responseContent(spec);
            return responseContent;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static String pandorabotsResponse(String sraixResponse, Chat chatSession, String host, String botid) {
        String botResponse = MagicStrings.sraix_failed;
        try {
            int n1 = sraixResponse.indexOf("<that>");
            int n2 = sraixResponse.indexOf("</that>");
            if (n2 > n1) {
                botResponse = sraixResponse.substring(n1 + "<that>".length(), n2);
            }
            if ((n1 = sraixResponse.indexOf("custid=")) > 0) {
                custid = sraixResponse.substring(n1 + "custid=\"".length(), sraixResponse.length());
                n2 = custid.indexOf("\"");
                custid = n2 > 0 ? custid.substring(0, n2) : "0";
                String key = host + ":" + botid;
                custIdMap.put(key, custid);
            }
            if (botResponse.endsWith(".")) {
                botResponse = botResponse.substring(0, botResponse.length() - 1);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return botResponse;
    }

    public static String sraixPannous(String input, String hint, Chat chatSession) {
        try {
            String rawInput = input;
            if (hint == null) {
                hint = MagicStrings.sraix_no_hint;
            }
            input = " " + input + " ";
            input = input.replace(" point ", ".");
            input = input.replace(" rparen ", ")");
            input = input.replace(" lparen ", "(");
            input = input.replace(" slash ", "/");
            input = input.replace(" star ", "*");
            input = input.replace(" dash ", "-");
            input = input.trim();
            input = input.replace(" ", "+");
            int offset = CalendarUtils.timeZoneOffset();
            String locationString = "";
            if (Chat.locationKnown) {
                locationString = "&location=" + Chat.latitude + "," + Chat.longitude;
            }
            String url = "https://ask.pannous.com/api?input=" + input + "&locale=en_US&timeZone=" + offset + locationString + "&login=" + MagicStrings.pannous_login + "&ip=" + NetworkUtils.localIPAddress() + "&botid=0&key=" + MagicStrings.pannous_api_key + "&exclude=Dialogues,ChatBot&out=json&clientFeatures=show-images,reminder,say&debug=true";
            MagicBooleans.trace("in Sraix.sraixPannous, url: '" + url + "'");
            String page = NetworkUtils.responseContent(url);
            String text = "";
            String imgRef = "";
            String urlRef = "";
            if (page != null && page.length() != 0) {
                JSONArray outputJson = new JSONObject(page).getJSONArray("output");
                if (outputJson.length() == 0) {
                    text = MagicStrings.sraix_failed;
                } else {
                    JSONObject sObj;
                    Object obj;
                    JSONObject firstHandler = outputJson.getJSONObject(0);
                    JSONObject actions = firstHandler.getJSONObject("actions");
                    if (actions.has("reminder")) {
                        obj = actions.get("reminder");
                        if (obj instanceof JSONObject) {
                            if (MagicBooleans.trace_mode) {
                                System.out.println("Found JSON Object");
                            }
                            sObj = (JSONObject)obj;
                            String date = sObj.getString("date");
                            date = date.substring(0, "2012-10-24T14:32".length());
                            if (MagicBooleans.trace_mode) {
                                System.out.println("date=" + date);
                            }
                            String duration = sObj.getString("duration");
                            if (MagicBooleans.trace_mode) {
                                System.out.println("duration=" + duration);
                            }
                            Pattern datePattern = Pattern.compile("(.*)-(.*)-(.*)T(.*):(.*)");
                            Matcher m = datePattern.matcher(date);
                            String year = "";
                            String month = "";
                            String day = "";
                            String hour = "";
                            String minute = "";
                            if (m.matches()) {
                                year = m.group(1);
                                month = String.valueOf(Integer.parseInt(m.group(2)) - 1);
                                day = m.group(3);
                                hour = m.group(4);
                                minute = m.group(5);
                                text = "<year>" + year + "</year>" + "<month>" + month + "</month>" + "<day>" + day + "</day>" + "<hour>" + hour + "</hour>" + "<minute>" + minute + "</minute>" + "<duration>" + duration + "</duration>";
                            } else {
                                text = MagicStrings.schedule_error;
                            }
                        }
                    } else if (actions.has("say") && !hint.equals(MagicStrings.sraix_pic_hint) && !hint.equals(MagicStrings.sraix_shopping_hint)) {
                        MagicBooleans.trace("in Sraix.sraixPannous, found say action");
                        obj = actions.get("say");
                        if (obj instanceof JSONObject) {
                            sObj = (JSONObject)obj;
                            text = sObj.getString("text");
                            if (sObj.has("moreText")) {
                                JSONArray arr = sObj.getJSONArray("moreText");
                                for (int i = 0; i < arr.length(); ++i) {
                                    text = text + " " + arr.getString(i);
                                }
                            }
                        } else {
                            text = obj.toString();
                        }
                    }
                    if (actions.has("show") && !text.contains("Wolfram") && actions.getJSONObject("show").has("images")) {
                        MagicBooleans.trace("in Sraix.sraixPannous, found show action");
                        JSONArray arr = actions.getJSONObject("show").getJSONArray("images");
                        int i = (int)((double)arr.length() * Math.random());
                        imgRef = arr.getString(i);
                        if (imgRef.startsWith("//")) {
                            imgRef = "http:" + imgRef;
                        }
                        imgRef = "<a href=\"" + imgRef + "\"><img src=\"" + imgRef + "\"/></a>";
                    }
                    if (hint.equals(MagicStrings.sraix_shopping_hint) && actions.has("open") && actions.getJSONObject("open").has("url")) {
                        urlRef = "<oob><url>" + actions.getJSONObject("open").getString("url") + "</oob></url>";
                    }
                }
                if (hint.equals(MagicStrings.sraix_event_hint) && !text.startsWith("<year>")) {
                    return MagicStrings.sraix_failed;
                }
                if (text.equals(MagicStrings.sraix_failed)) {
                    return AIMLProcessor.respond(MagicStrings.sraix_failed, "nothing", "nothing", chatSession);
                }
                text = text.replace("&#39;", "'");
                text = text.replace("&apos;", "'");
                text = text.replaceAll("\\[(.*)\\]", "");
                String[] sentences = text.split("\\. ");
                String clippedPage = sentences[0];
                for (int i = 1; i < sentences.length; ++i) {
                    if (clippedPage.length() >= 500) continue;
                    clippedPage = clippedPage + ". " + sentences[i];
                }
                clippedPage = clippedPage + " " + imgRef + " " + urlRef;
                clippedPage = clippedPage.trim();
                Sraix.log(rawInput, clippedPage);
                return clippedPage;
            }
            text = MagicStrings.sraix_failed;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.out.println("Sraix '" + input + "' failed");
        }
        return MagicStrings.sraix_failed;
    }

    public static void log(String pattern, String template) {
        if (MagicBooleans.cache_sraix) {
            try {
                if (!template.contains("<year>") && !template.contains("No facilities")) {
                    template = template.replace("\n", "\\#Newline");
                    template = template.replace(",", MagicStrings.aimlif_split_char_name);
                    template = template.replaceAll("<a(.*)</a>", "");
                    FileWriter fstream = new FileWriter("c:/ab/bots/sraixcache/aimlif/sraixcache.aiml.csv", true);
                    BufferedWriter fbw = new BufferedWriter(fstream);
                    fbw.write("0," + pattern + ",*,*," + template + ",sraixcache.aiml.csv");
                    fbw.newLine();
                    fbw.close();
                }
            }
            catch (Exception e) {
                System.out.println("Error: " + e.getMessage());
            }
        }
    }
}

