/*
 * Decompiled with CFR 0.152.
 */
package org.alicebot.ab;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.alicebot.ab.AIMLProcessor;
import org.alicebot.ab.Bot;
import org.alicebot.ab.History;
import org.alicebot.ab.MagicBooleans;
import org.alicebot.ab.MagicNumbers;
import org.alicebot.ab.MagicStrings;
import org.alicebot.ab.Predicates;
import org.alicebot.ab.TripleStore;
import org.alicebot.ab.utils.IOUtils;
import org.alicebot.ab.utils.JapaneseUtils;

public class Chat {
    public Bot bot;
    public boolean doWrites;
    public String customerId = MagicStrings.default_Customer_id;
    public History<History> thatHistory = new History("that");
    public History<String> requestHistory = new History("request");
    public History<String> responseHistory = new History("response");
    public History<String> inputHistory = new History("input");
    public Predicates predicates = new Predicates();
    public static String matchTrace = "";
    public static boolean locationKnown = false;
    public static String longitude;
    public static String latitude;
    public TripleStore tripleStore = new TripleStore("anon", this);

    public Chat(Bot bot) {
        this(bot, true, "0");
    }

    public Chat(Bot bot, boolean doWrites) {
        this(bot, doWrites, "0");
    }

    public Chat(Bot bot, boolean doWrites, String customerId) {
        this.customerId = customerId;
        this.bot = bot;
        this.doWrites = doWrites;
        History<String> contextThatHistory = new History<String>();
        contextThatHistory.add(MagicStrings.default_that);
        this.thatHistory.add(contextThatHistory);
        this.addPredicates();
        this.addTriples();
        this.predicates.put("topic", MagicStrings.default_topic);
        this.predicates.put("jsenabled", MagicStrings.js_enabled);
        if (MagicBooleans.trace_mode) {
            System.out.println("Chat Session Created for bot " + bot.name);
        }
    }

    void addPredicates() {
        try {
            this.predicates.getPredicateDefaults(this.bot.config_path + "/predicates.txt");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    int addTriples() {
        File f;
        int tripleCnt = 0;
        if (MagicBooleans.trace_mode) {
            System.out.println("Loading Triples from " + this.bot.config_path + "/triples.txt");
        }
        if ((f = new File(this.bot.config_path + "/triples.txt")).exists()) {
            try {
                String strLine;
                FileInputStream is = new FileInputStream(f);
                BufferedReader br = new BufferedReader(new InputStreamReader(is));
                while ((strLine = br.readLine()) != null) {
                    String[] triple = strLine.split(":");
                    if (triple.length < 3) continue;
                    String subject = triple[0];
                    String predicate = triple[1];
                    String object = triple[2];
                    this.tripleStore.addTriple(subject, predicate, object);
                    ++tripleCnt;
                }
                ((InputStream)is).close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (MagicBooleans.trace_mode) {
            System.out.println("Loaded " + tripleCnt + " triples");
        }
        return tripleCnt;
    }

    public void chat() {
        BufferedWriter bw = null;
        String logFile = this.bot.log_path + "/log_" + this.customerId + ".txt";
        try {
            bw = new BufferedWriter(new FileWriter(logFile, true));
            String request = "SET PREDICATES";
            String response = this.multisentenceRespond(request);
            while (!request.equals("quit")) {
                System.out.print("Human: ");
                request = IOUtils.readInputTextLine();
                response = this.multisentenceRespond(request);
                System.out.println("Robot: " + response);
                bw.write("Human: " + request);
                bw.newLine();
                bw.write("Robot: " + response);
                bw.newLine();
                bw.flush();
            }
            bw.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    String respond(String input, String that, String topic, History contextThatHistory) {
        boolean repetition = true;
        for (int i = 0; i < MagicNumbers.repetition_count; ++i) {
            if (this.inputHistory.get(i) != null && input.toUpperCase().equals(this.inputHistory.get(i).toUpperCase())) continue;
            repetition = false;
        }
        if (input.equals(MagicStrings.null_input)) {
            repetition = false;
        }
        this.inputHistory.add(input);
        if (repetition) {
            input = MagicStrings.repetition_detected;
        }
        String response = AIMLProcessor.respond(input, that, topic, this);
        String normResponse = this.bot.preProcessor.normalize(response);
        if (MagicBooleans.jp_tokenize) {
            normResponse = JapaneseUtils.tokenizeSentence(normResponse);
        }
        String[] sentences = this.bot.preProcessor.sentenceSplit(normResponse);
        for (int i = 0; i < sentences.length; ++i) {
            that = sentences[i];
            if (that.trim().equals("")) {
                that = MagicStrings.default_that;
            }
            contextThatHistory.add(that);
        }
        String result = response.trim() + "  ";
        return result;
    }

    String respond(String input, History<String> contextThatHistory) {
        History hist = this.thatHistory.get(0);
        String that = hist == null ? MagicStrings.default_that : hist.getString(0);
        return this.respond(input, that, this.predicates.get("topic"), contextThatHistory);
    }

    public String multisentenceRespond(String request) {
        String response = "";
        matchTrace = "";
        try {
            String normalized = this.bot.preProcessor.normalize(request);
            normalized = JapaneseUtils.tokenizeSentence(normalized);
            String[] sentences = this.bot.preProcessor.sentenceSplit(normalized);
            History<String> contextThatHistory = new History<String>("contextThat");
            for (int i = 0; i < sentences.length; ++i) {
                AIMLProcessor.trace_count = 0;
                String reply = this.respond(sentences[i], contextThatHistory);
                response = response + "  " + reply;
            }
            this.requestHistory.add(request);
            this.responseHistory.add(response);
            this.thatHistory.add(contextThatHistory);
            response = response.replaceAll("[\n]+", "\n");
            response = response.trim();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return MagicStrings.error_bot_response;
        }
        if (this.doWrites) {
            this.bot.writeLearnfIFCategories();
        }
        return response;
    }

    public static void setMatchTrace(String newMatchTrace) {
        matchTrace = newMatchTrace;
    }
}

