/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javacv.cpp;

import com.googlecode.javacpp.Loader;
import com.googlecode.javacpp.Pointer;
import com.googlecode.javacpp.annotation.ByRef;
import com.googlecode.javacpp.annotation.MemberSetter;
import com.googlecode.javacpp.annotation.Name;
import com.googlecode.javacpp.annotation.Platform;
import com.googlecode.javacpp.annotation.Properties;
import com.googlecode.javacv.Parallel;
import com.googlecode.javacv.cpp.opencv_core;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.util.Arrays;

@Properties(inherit={opencv_core.class}, value={@Platform(define={"MAX_SIZE 16", "CV_INLINE static inline"}, include={"cvkernels.h"}, options={"fastfpu"})})
public class cvkernels {
    private static ThreadLocal<ParallelData[]> parallelData;

    public static native void multiWarpColorTransform32F(KernelData var0, int var1, opencv_core.CvRect var2, opencv_core.CvScalar var3);

    public static native void multiWarpColorTransform8U(KernelData var0, int var1, opencv_core.CvRect var2, opencv_core.CvScalar var3);

    public static void multiWarpColorTransform(KernelData data, opencv_core.CvRect roi, final opencv_core.CvScalar fillColor) {
        int h;
        int w;
        int y;
        int x;
        final int size = data.capacity();
        final ParallelData[] pd = parallelData.get();
        for (int i = 0; i < pd.length; ++i) {
            KernelData d;
            int j;
            if (pd[i].data == null || pd[i].data.capacity() < size) {
                pd[i].data = new KernelData(size);
                for (j = 0; j < size; ++j) {
                    d = pd[i].data.position(j);
                    data.position(j);
                    if (data.dstDstDot() == null) continue;
                    d.dstDstDot(ByteBuffer.allocateDirect(data.dstDstDot().capacity() * 8).order(ByteOrder.nativeOrder()).asDoubleBuffer());
                }
            }
            for (j = 0; j < size; ++j) {
                d = pd[i].data.position(j);
                d.put(data.position(j));
                d.dstDstDot(d.dstDstDot());
            }
        }
        opencv_core.IplImage img = data.position(0).srcImg();
        final int depth = img.depth();
        if (roi != null) {
            x = roi.x();
            y = roi.y();
            w = roi.width();
            h = roi.height();
        } else {
            x = 0;
            y = 0;
            w = img.width();
            h = img.height();
        }
        Parallel.loop(y, y + h, pd.length, new Parallel.Looper(){

            public void loop(int from, int to, int looperID) {
                opencv_core.CvRect r = pd[looperID].roi.x(x).y(from).width(w).height(to - from);
                if (depth == 32) {
                    cvkernels.multiWarpColorTransform32F(pd[looperID].data.position(0), size, r, fillColor);
                } else if (depth == 8) {
                    cvkernels.multiWarpColorTransform8U(pd[looperID].data.position(0), size, r, fillColor);
                } else assert (false);
            }
        });
        for (int i = 0; i < size; ++i) {
            int dstCount = 0;
            int dstCountZero = 0;
            int dstCountOutlier = 0;
            double srcDstDot = 0.0;
            double[] dstDstDot = null;
            if (data.dstDstDot() != null) {
                dstDstDot = new double[data.dstDstDot().capacity()];
            }
            for (int j = 0; j < pd.length; ++j) {
                KernelData d = pd[j].data.position(i);
                dstCount += d.dstCount();
                dstCountZero += d.dstCountZero();
                dstCountOutlier += d.dstCountOutlier();
                srcDstDot += d.srcDstDot();
                if (dstDstDot == null || d.dstDstDot() == null) continue;
                for (int k = 0; k < dstDstDot.length; ++k) {
                    int n = k;
                    dstDstDot[n] = dstDstDot[n] + d.dstDstDot().get(k);
                }
            }
            data.position(i);
            data.dstCount(dstCount);
            data.dstCountZero(dstCountZero);
            data.dstCountOutlier(dstCountOutlier);
            data.srcDstDot(srcDstDot);
            if (dstDstDot == null || data.dstDstDot() == null) continue;
            data.dstDstDot().position(0);
            data.dstDstDot().put(dstDstDot);
        }
    }

    static {
        Loader.load();
        parallelData = new ThreadLocal<ParallelData[]>(){

            @Override
            protected ParallelData[] initialValue() {
                ParallelData[] pd = new ParallelData[Parallel.getNumThreads()];
                for (int i = 0; i < pd.length; ++i) {
                    pd[i] = new ParallelData();
                }
                return pd;
            }
        };
    }

    private static class ParallelData {
        KernelData data = null;
        opencv_core.CvRect roi = new opencv_core.CvRect();

        private ParallelData() {
        }
    }

    public static class KernelData
    extends Pointer {
        private DoubleBuffer[] dstDstDotBuffers = new DoubleBuffer[1];

        public KernelData() {
            this.allocate();
        }

        public KernelData(int size) {
            this.allocateArray(size);
        }

        public KernelData(Pointer p) {
            super(p);
        }

        private native void allocate();

        private native void allocateArray(int var1);

        public KernelData position(int position) {
            return (KernelData)super.position(position);
        }

        public native opencv_core.IplImage srcImg();

        public native KernelData srcImg(opencv_core.IplImage var1);

        public native opencv_core.IplImage srcImg2();

        public native KernelData srcImg2(opencv_core.IplImage var1);

        public native opencv_core.IplImage subImg();

        public native KernelData subImg(opencv_core.IplImage var1);

        public native opencv_core.IplImage srcDotImg();

        public native KernelData srcDotImg(opencv_core.IplImage var1);

        public native opencv_core.IplImage mask();

        public native KernelData mask(opencv_core.IplImage var1);

        public native double zeroThreshold();

        public native KernelData zeroThreshold(double var1);

        public native double outlierThreshold();

        public native KernelData outlierThreshold(double var1);

        public native opencv_core.CvMat H1();

        public native KernelData H1(opencv_core.CvMat var1);

        public native opencv_core.CvMat H2();

        public native KernelData H2(opencv_core.CvMat var1);

        public native opencv_core.CvMat X();

        public native KernelData X(opencv_core.CvMat var1);

        public native opencv_core.IplImage transImg();

        public native KernelData transImg(opencv_core.IplImage var1);

        public native opencv_core.IplImage dstImg();

        public native KernelData dstImg(opencv_core.IplImage var1);

        public native int dstCount();

        public native KernelData dstCount(int var1);

        public native int dstCountZero();

        public native KernelData dstCountZero(int var1);

        public native int dstCountOutlier();

        public native KernelData dstCountOutlier(int var1);

        public native double srcDstDot();

        public native KernelData srcDstDot(double var1);

        @MemberSetter
        @Name(value={"dstDstDot"})
        private native KernelData setDstDstDot(DoubleBuffer var1);

        public DoubleBuffer dstDstDot() {
            return this.dstDstDotBuffers[this.position];
        }

        public KernelData dstDstDot(DoubleBuffer dstDstDot) {
            if (this.dstDstDotBuffers.length < this.capacity) {
                this.dstDstDotBuffers = Arrays.copyOf(this.dstDstDotBuffers, this.capacity);
            }
            this.dstDstDotBuffers[this.position] = dstDstDot;
            return this.setDstDstDot(dstDstDot);
        }

        @Name(value={"operator="})
        @ByRef
        private native KernelData put(@ByRef KernelData var1);

        static {
            Loader.load();
        }
    }
}

