/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javacv;

import com.googlecode.javacpp.BytePointer;
import com.googlecode.javacpp.DoublePointer;
import com.googlecode.javacpp.FloatPointer;
import com.googlecode.javacpp.IntPointer;
import com.googlecode.javacpp.Loader;
import com.googlecode.javacpp.Pointer;
import com.googlecode.javacpp.PointerPointer;
import com.googlecode.javacpp.ShortPointer;
import com.googlecode.javacv.FrameRecorder;
import com.googlecode.javacv.cpp.avcodec;
import com.googlecode.javacv.cpp.avformat;
import com.googlecode.javacv.cpp.avutil;
import com.googlecode.javacv.cpp.opencv_core;
import com.googlecode.javacv.cpp.swresample;
import com.googlecode.javacv.cpp.swscale;
import java.io.File;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.Map;

public class FFmpegFrameRecorder
extends FrameRecorder {
    private static FrameRecorder.Exception loadingException = null;
    private String filename;
    private avutil.AVFrame picture;
    private avutil.AVFrame tmp_picture;
    private BytePointer picture_buf;
    private BytePointer video_outbuf;
    private int video_outbuf_size;
    private avutil.AVFrame frame;
    private Pointer[] samples_in;
    private BytePointer[] samples_out;
    private PointerPointer samples_in_ptr;
    private PointerPointer samples_out_ptr;
    private BytePointer audio_outbuf;
    private int audio_outbuf_size;
    private int audio_input_frame_size;
    private avformat.AVOutputFormat oformat;
    private avformat.AVFormatContext oc;
    private avcodec.AVCodec video_codec;
    private avcodec.AVCodec audio_codec;
    private avcodec.AVCodecContext video_c;
    private avcodec.AVCodecContext audio_c;
    private avformat.AVStream video_st;
    private avformat.AVStream audio_st;
    private swscale.SwsContext img_convert_ctx;
    private swresample.SwrContext samples_convert_ctx;
    private avcodec.AVPacket video_pkt;
    private avcodec.AVPacket audio_pkt;
    private int[] got_video_packet;
    private int[] got_audio_packet;

    public static FFmpegFrameRecorder createDefault(File f, int w, int h) throws FrameRecorder.Exception {
        return new FFmpegFrameRecorder(f, w, h);
    }

    public static FFmpegFrameRecorder createDefault(String f, int w, int h) throws FrameRecorder.Exception {
        return new FFmpegFrameRecorder(f, w, h);
    }

    public static void tryLoad() throws FrameRecorder.Exception {
        if (loadingException != null) {
            throw loadingException;
        }
        try {
            Loader.load(avutil.class);
            Loader.load(avcodec.class);
            Loader.load(avformat.class);
            Loader.load(swscale.class);
        }
        catch (Throwable t) {
            if (t instanceof FrameRecorder.Exception) {
                loadingException = (FrameRecorder.Exception)t;
                throw loadingException;
            }
            loadingException = new FrameRecorder.Exception("Failed to load " + FFmpegFrameRecorder.class, t);
            throw loadingException;
        }
    }

    public FFmpegFrameRecorder(File file, int audioChannels) {
        this(file, 0, 0, audioChannels);
    }

    public FFmpegFrameRecorder(String filename, int audioChannels) {
        this(filename, 0, 0, audioChannels);
    }

    public FFmpegFrameRecorder(File file, int imageWidth, int imageHeight) {
        this(file, imageWidth, imageHeight, 0);
    }

    public FFmpegFrameRecorder(String filename, int imageWidth, int imageHeight) {
        this(filename, imageWidth, imageHeight, 0);
    }

    public FFmpegFrameRecorder(File file, int imageWidth, int imageHeight, int audioChannels) {
        this(file.getAbsolutePath(), imageWidth, imageHeight);
    }

    public FFmpegFrameRecorder(String filename, int imageWidth, int imageHeight, int audioChannels) {
        avformat.av_register_all();
        avformat.avformat_network_init();
        this.filename = filename;
        this.imageWidth = imageWidth;
        this.imageHeight = imageHeight;
        this.audioChannels = audioChannels;
        this.pixelFormat = -1;
        this.videoCodec = 0;
        this.videoBitrate = 400000;
        this.frameRate = 30.0;
        this.sampleFormat = -1;
        this.audioCodec = 0;
        this.audioBitrate = 64000;
        this.sampleRate = 44100;
        this.interleaved = true;
        this.video_pkt = new avcodec.AVPacket();
        this.audio_pkt = new avcodec.AVPacket();
    }

    public void release() throws FrameRecorder.Exception {
        if (this.video_c != null) {
            avcodec.avcodec_close(this.video_c);
            this.video_c = null;
        }
        if (this.audio_c != null) {
            avcodec.avcodec_close(this.audio_c);
            this.audio_c = null;
        }
        if (this.picture_buf != null) {
            avutil.av_free(this.picture_buf);
            this.picture_buf = null;
        }
        if (this.picture != null) {
            avcodec.avcodec_free_frame(this.picture);
            this.picture = null;
        }
        if (this.tmp_picture != null) {
            avcodec.avcodec_free_frame(this.tmp_picture);
            this.tmp_picture = null;
        }
        if (this.video_outbuf != null) {
            avutil.av_free(this.video_outbuf);
            this.video_outbuf = null;
        }
        if (this.frame != null) {
            avcodec.avcodec_free_frame(this.frame);
            this.frame = null;
        }
        if (this.samples_out != null) {
            for (int i = 0; i < this.samples_out.length; ++i) {
                avutil.av_free(this.samples_out[i].position(0));
            }
            this.samples_out = null;
        }
        if (this.audio_outbuf != null) {
            avutil.av_free(this.audio_outbuf);
            this.audio_outbuf = null;
        }
        this.video_st = null;
        this.audio_st = null;
        if (this.oc != null && !this.oc.isNull()) {
            if ((this.oformat.flags() & 1) == 0) {
                avformat.avio_close(this.oc.pb());
            }
            int nb_streams = this.oc.nb_streams();
            for (int i = 0; i < nb_streams; ++i) {
                avutil.av_free(this.oc.streams(i).codec());
                avutil.av_free(this.oc.streams(i));
            }
            avutil.av_free(this.oc);
            this.oc = null;
        }
        if (this.img_convert_ctx != null) {
            swscale.sws_freeContext(this.img_convert_ctx);
            this.img_convert_ctx = null;
        }
        if (this.samples_convert_ctx != null) {
            swresample.swr_free(this.samples_convert_ctx);
            this.samples_convert_ctx = null;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.release();
    }

    public int getFrameNumber() {
        return this.picture == null ? super.getFrameNumber() : (int)this.picture.pts();
    }

    public void setFrameNumber(int frameNumber) {
        if (this.picture == null) {
            super.setFrameNumber(frameNumber);
        } else {
            this.picture.pts(frameNumber);
        }
    }

    public long getTimestamp() {
        return Math.round((double)((long)this.getFrameNumber() * 1000000L) / this.getFrameRate());
    }

    public void setTimestamp(long timestamp) {
        this.setFrameNumber((int)Math.round((double)timestamp * this.getFrameRate() / 1000000.0));
    }

    public void start() throws FrameRecorder.Exception {
        int ret;
        this.picture = null;
        this.tmp_picture = null;
        this.picture_buf = null;
        this.frame = null;
        this.video_outbuf = null;
        this.audio_outbuf = null;
        this.oc = null;
        this.video_c = null;
        this.audio_c = null;
        this.video_st = null;
        this.audio_st = null;
        this.got_video_packet = new int[1];
        this.got_audio_packet = new int[1];
        String format_name = this.format == null || this.format.length() == 0 ? null : this.format;
        this.oformat = avformat.av_guess_format(format_name, this.filename, null);
        if (this.oformat == null) {
            int proto = this.filename.indexOf("://");
            if (proto > 0) {
                format_name = this.filename.substring(0, proto);
            }
            if ((this.oformat = avformat.av_guess_format(format_name, this.filename, null)) == null) {
                throw new FrameRecorder.Exception("av_guess_format() error: Could not guess output format for \"" + this.filename + "\" and " + this.format + " format.");
            }
        }
        format_name = this.oformat.name().getString();
        this.oc = avformat.avformat_alloc_context();
        if (this.oc == null) {
            throw new FrameRecorder.Exception("avformat_alloc_context() error: Could not allocate format context");
        }
        this.oc.oformat(this.oformat);
        this.oc.filename().putString(this.filename);
        if (this.imageWidth > 0 && this.imageHeight > 0) {
            if (this.videoCodec != 0) {
                this.oformat.video_codec(this.videoCodec);
            } else if ("flv".equals(format_name)) {
                this.oformat.video_codec(22);
            } else if ("mp4".equals(format_name)) {
                this.oformat.video_codec(13);
            } else if ("3gp".equals(format_name)) {
                this.oformat.video_codec(5);
            } else if ("avi".equals(format_name)) {
                this.oformat.video_codec(26);
            }
            this.video_codec = avcodec.avcodec_find_encoder(this.oformat.video_codec());
            if (this.video_codec == null) {
                this.release();
                throw new FrameRecorder.Exception("avcodec_find_encoder() error: Video codec not found.");
            }
            avutil.AVRational frame_rate = avutil.av_d2q(this.frameRate, 1001000);
            avutil.AVRational supported_framerates = this.video_codec.supported_framerates();
            if (supported_framerates != null) {
                int idx = avutil.av_find_nearest_q_idx(frame_rate, supported_framerates);
                frame_rate = supported_framerates.position(idx);
            }
            if ((this.video_st = avformat.avformat_new_stream(this.oc, this.video_codec)) == null) {
                this.release();
                throw new FrameRecorder.Exception("avformat_new_stream() error: Could not allocate video stream.");
            }
            this.video_c = this.video_st.codec();
            this.video_c.codec_id(this.oformat.video_codec());
            this.video_c.codec_type(0);
            this.video_c.bit_rate(this.videoBitrate);
            this.video_c.width((this.imageWidth + 15) / 16 * 16);
            this.video_c.height(this.imageHeight);
            this.video_c.time_base(avutil.av_inv_q(frame_rate));
            this.video_c.gop_size(12);
            if (this.videoQuality >= 0.0) {
                this.video_c.flags(this.video_c.flags() | 2);
                this.video_c.global_quality((int)Math.round(118.0 * this.videoQuality));
            }
            if (this.pixelFormat != -1) {
                this.video_c.pix_fmt(this.pixelFormat);
            } else if (this.video_c.codec_id() == 14 || this.video_c.codec_id() == 62 || this.video_c.codec_id() == 26 || this.video_c.codec_id() == 34) {
                this.video_c.pix_fmt(avutil.AV_PIX_FMT_RGB32);
            } else {
                this.video_c.pix_fmt(0);
            }
            if (this.video_c.codec_id() == 2) {
                this.video_c.max_b_frames(2);
            } else if (this.video_c.codec_id() == 1) {
                this.video_c.mb_decision(2);
            } else if (this.video_c.codec_id() == 5) {
                if (this.imageWidth <= 128 && this.imageHeight <= 96) {
                    this.video_c.width(128).height(96);
                } else if (this.imageWidth <= 176 && this.imageHeight <= 144) {
                    this.video_c.width(176).height(144);
                } else if (this.imageWidth <= 352 && this.imageHeight <= 288) {
                    this.video_c.width(352).height(288);
                } else if (this.imageWidth <= 704 && this.imageHeight <= 576) {
                    this.video_c.width(704).height(576);
                } else {
                    this.video_c.width(1408).height(1152);
                }
            } else if (this.video_c.codec_id() == 28) {
                this.video_c.profile(578);
            }
            if ((this.oformat.flags() & 0x40) != 0) {
                this.video_c.flags(this.video_c.flags() | 0x400000);
            }
            if ((this.video_codec.capabilities() & 0x200) != 0) {
                this.video_c.strict_std_compliance(-2);
            }
        }
        if (this.audioChannels > 0 && this.audioBitrate > 0 && this.sampleRate > 0) {
            if (this.audioCodec != 0) {
                this.oformat.audio_codec(this.audioCodec);
            } else if ("flv".equals(format_name) || "mp4".equals(format_name) || "3gp".equals(format_name)) {
                this.oformat.audio_codec(86018);
            } else if ("avi".equals(format_name)) {
                this.oformat.audio_codec(65536);
            }
            this.audio_codec = avcodec.avcodec_find_encoder(this.oformat.audio_codec());
            if (this.audio_codec == null) {
                this.release();
                throw new FrameRecorder.Exception("avcodec_find_encoder() error: Audio codec not found.");
            }
            this.audio_st = avformat.avformat_new_stream(this.oc, this.audio_codec);
            if (this.audio_st == null) {
                this.release();
                throw new FrameRecorder.Exception("avformat_new_stream() error: Could not allocate audio stream.");
            }
            this.audio_c = this.audio_st.codec();
            this.audio_c.codec_id(this.oformat.audio_codec());
            this.audio_c.codec_type(1);
            this.audio_c.bit_rate(this.audioBitrate);
            this.audio_c.sample_rate(this.sampleRate);
            this.audio_c.channels(this.audioChannels);
            this.audio_c.channel_layout(avutil.av_get_default_channel_layout(this.audioChannels));
            if (this.sampleFormat != -1) {
                this.audio_c.sample_fmt(this.sampleFormat);
            } else if (this.audio_c.codec_id() == 86018 && (this.audio_codec.capabilities() & 0x200) != 0) {
                this.audio_c.sample_fmt(8);
            } else {
                this.audio_c.sample_fmt(1);
            }
            this.audio_c.time_base().num(1).den(this.sampleRate);
            switch (this.audio_c.sample_fmt()) {
                case 0: 
                case 5: {
                    this.audio_c.bits_per_raw_sample(8);
                    break;
                }
                case 1: 
                case 6: {
                    this.audio_c.bits_per_raw_sample(16);
                    break;
                }
                case 2: 
                case 7: {
                    this.audio_c.bits_per_raw_sample(32);
                    break;
                }
                case 3: 
                case 8: {
                    this.audio_c.bits_per_raw_sample(32);
                    break;
                }
                case 4: 
                case 9: {
                    this.audio_c.bits_per_raw_sample(64);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            if (this.audioQuality >= 0.0) {
                this.audio_c.flags(this.audio_c.flags() | 2);
                this.audio_c.global_quality((int)Math.round(118.0 * this.audioQuality));
            }
            if ((this.oformat.flags() & 0x40) != 0) {
                this.audio_c.flags(this.audio_c.flags() | 0x400000);
            }
            if ((this.audio_codec.capabilities() & 0x200) != 0) {
                this.audio_c.strict_std_compliance(-2);
            }
        }
        avformat.av_dump_format(this.oc, 0, this.filename, 1);
        if (this.video_st != null) {
            avutil.AVDictionary options = new avutil.AVDictionary(null);
            if (this.videoQuality >= 0.0) {
                avutil.av_dict_set(options, "crf", "" + this.videoQuality, 0);
            }
            for (Map.Entry e : this.videoOptions.entrySet()) {
                avutil.av_dict_set(options, (String)e.getKey(), (String)e.getValue(), 0);
            }
            ret = avcodec.avcodec_open2(this.video_c, this.video_codec, options);
            if (ret < 0) {
                this.release();
                throw new FrameRecorder.Exception("avcodec_open2() error " + ret + ": Could not open video codec.");
            }
            avutil.av_dict_free(options);
            this.video_outbuf = null;
            if ((this.oformat.flags() & 0x20) == 0) {
                this.video_outbuf_size = Math.max(262144, 8 * this.video_c.width() * this.video_c.height());
                this.video_outbuf = new BytePointer(avutil.av_malloc(this.video_outbuf_size));
            }
            if ((this.picture = avcodec.avcodec_alloc_frame()) == null) {
                this.release();
                throw new FrameRecorder.Exception("avcodec_alloc_frame() error: Could not allocate picture.");
            }
            this.picture.pts(0L);
            int size = avcodec.avpicture_get_size(this.video_c.pix_fmt(), this.video_c.width(), this.video_c.height());
            this.picture_buf = new BytePointer(avutil.av_malloc(size));
            if (this.picture_buf.isNull()) {
                this.release();
                throw new FrameRecorder.Exception("av_malloc() error: Could not allocate picture buffer.");
            }
            this.tmp_picture = avcodec.avcodec_alloc_frame();
            if (this.tmp_picture == null) {
                this.release();
                throw new FrameRecorder.Exception("avcodec_alloc_frame() error: Could not allocate temporary picture.");
            }
        }
        if (this.audio_st != null) {
            avutil.AVDictionary options = new avutil.AVDictionary(null);
            if (this.audioQuality >= 0.0) {
                avutil.av_dict_set(options, "crf", "" + this.audioQuality, 0);
            }
            for (Map.Entry e : this.audioOptions.entrySet()) {
                avutil.av_dict_set(options, (String)e.getKey(), (String)e.getValue(), 0);
            }
            ret = avcodec.avcodec_open2(this.audio_c, this.audio_codec, options);
            if (ret < 0) {
                this.release();
                throw new FrameRecorder.Exception("avcodec_open2() error " + ret + ": Could not open audio codec.");
            }
            avutil.av_dict_free(options);
            this.audio_outbuf_size = 262144;
            this.audio_outbuf = new BytePointer(avutil.av_malloc(this.audio_outbuf_size));
            if (this.audio_c.frame_size() <= 1) {
                this.audio_outbuf_size = 16384;
                this.audio_input_frame_size = this.audio_outbuf_size / this.audio_c.channels();
                switch (this.audio_c.codec_id()) {
                    case 65536: 
                    case 65537: 
                    case 65538: 
                    case 65539: {
                        this.audio_input_frame_size >>= 1;
                        break;
                    }
                }
            } else {
                this.audio_input_frame_size = this.audio_c.frame_size();
            }
            int planes = avutil.av_sample_fmt_is_planar(this.audio_c.sample_fmt()) != 0 ? this.audio_c.channels() : 1;
            int data_size = avutil.av_samples_get_buffer_size((IntPointer)null, this.audio_c.channels(), this.audio_input_frame_size, this.audio_c.sample_fmt(), 1) / planes;
            this.samples_out = new BytePointer[planes];
            for (int i = 0; i < this.samples_out.length; ++i) {
                this.samples_out[i] = new BytePointer(avutil.av_malloc(data_size)).capacity(data_size);
            }
            this.samples_in = new Pointer[8];
            this.samples_in_ptr = new PointerPointer(8);
            this.samples_out_ptr = new PointerPointer(8);
            this.frame = avcodec.avcodec_alloc_frame();
            if (this.frame == null) {
                this.release();
                throw new FrameRecorder.Exception("avcodec_alloc_frame() error: Could not allocate audio frame.");
            }
        }
        if ((this.oformat.flags() & 1) == 0) {
            avformat.AVIOContext pb = new avformat.AVIOContext(null);
            ret = avformat.avio_open(pb, this.filename, 2);
            if (ret < 0) {
                this.release();
                throw new FrameRecorder.Exception("avio_open error() error " + ret + ": Could not open '" + this.filename + "'");
            }
            this.oc.pb(pb);
        }
        avformat.avformat_write_header(this.oc, (PointerPointer)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws FrameRecorder.Exception {
        if (this.oc != null) {
            try {
                while (this.video_st != null && this.record((opencv_core.IplImage)null, -1)) {
                }
                while (this.audio_st != null && this.record((avutil.AVFrame)null)) {
                }
                if (this.interleaved && this.video_st != null && this.audio_st != null) {
                    avformat.av_interleaved_write_frame(this.oc, null);
                } else {
                    avformat.av_write_frame(this.oc, null);
                }
                avformat.av_write_trailer(this.oc);
            }
            finally {
                this.release();
            }
        }
    }

    public boolean record(opencv_core.IplImage image) throws FrameRecorder.Exception {
        return this.record(image, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean record(opencv_core.IplImage image, int pixelFormat) throws FrameRecorder.Exception {
        int ret;
        if (this.video_st == null) {
            throw new FrameRecorder.Exception("No video output stream (Is imageWidth > 0 && imageHeight > 0 and has start() been called?)");
        }
        if (image != null) {
            int width = image.width();
            int height = image.height();
            int step = image.widthStep();
            BytePointer data = image.imageData();
            if (pixelFormat == -1) {
                int depth = image.depth();
                int channels = image.nChannels();
                if ((depth == 8 || depth == -2147483640) && channels == 3) {
                    pixelFormat = 3;
                } else if ((depth == 8 || depth == -2147483640) && channels == 1) {
                    pixelFormat = 8;
                } else if ((depth == 16 || depth == -2147483632) && channels == 1) {
                    pixelFormat = ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN) ? 31 : 32;
                } else if ((depth == 8 || depth == -2147483640) && channels == 4) {
                    pixelFormat = 28;
                } else if ((depth == 8 || depth == -2147483640) && channels == 2) {
                    pixelFormat = 26;
                    step = width;
                } else {
                    throw new FrameRecorder.Exception("Could not guess pixel format of image: depth=" + depth + ", channels=" + channels);
                }
            }
            if (this.video_c.pix_fmt() != pixelFormat || this.video_c.width() != width || this.video_c.height() != height) {
                this.img_convert_ctx = swscale.sws_getCachedContext(this.img_convert_ctx, width, height, pixelFormat, this.video_c.width(), this.video_c.height(), this.video_c.pix_fmt(), 2, null, null, (DoublePointer)null);
                if (this.img_convert_ctx == null) {
                    throw new FrameRecorder.Exception("sws_getCachedContext() error: Cannot initialize the conversion context.");
                }
                avcodec.avpicture_fill(new avcodec.AVPicture(this.tmp_picture), data, pixelFormat, width, height);
                avcodec.avpicture_fill(new avcodec.AVPicture(this.picture), this.picture_buf, this.video_c.pix_fmt(), this.video_c.width(), this.video_c.height());
                this.tmp_picture.linesize(0, step);
                swscale.sws_scale(this.img_convert_ctx, new PointerPointer((Pointer)this.tmp_picture), this.tmp_picture.linesize(), 0, height, new PointerPointer((Pointer)this.picture), this.picture.linesize());
            } else {
                avcodec.avpicture_fill(new avcodec.AVPicture(this.picture), data, pixelFormat, width, height);
                this.picture.linesize(0, step);
            }
        }
        if ((this.oformat.flags() & 0x20) != 0) {
            if (image == null) {
                return false;
            }
            avcodec.av_init_packet(this.video_pkt);
            this.video_pkt.flags(this.video_pkt.flags() | 1);
            this.video_pkt.stream_index(this.video_st.index());
            this.video_pkt.data(new BytePointer(this.picture));
            this.video_pkt.size(Loader.sizeof(avcodec.AVPicture.class));
        } else {
            avcodec.av_init_packet(this.video_pkt);
            this.video_pkt.data(this.video_outbuf);
            this.video_pkt.size(this.video_outbuf_size);
            this.picture.quality(this.video_c.global_quality());
            ret = avcodec.avcodec_encode_video2(this.video_c, this.video_pkt, image == null ? null : this.picture, this.got_video_packet);
            if (ret < 0) {
                throw new FrameRecorder.Exception("avcodec_encode_video2() error " + ret + ": Could not encode video packet.");
            }
            this.picture.pts(this.picture.pts() + 1L);
            if (this.got_video_packet[0] != 0) {
                if (this.video_pkt.pts() != avutil.AV_NOPTS_VALUE) {
                    this.video_pkt.pts(avutil.av_rescale_q(this.video_pkt.pts(), this.video_c.time_base(), this.video_st.time_base()));
                }
                if (this.video_pkt.dts() != avutil.AV_NOPTS_VALUE) {
                    this.video_pkt.dts(avutil.av_rescale_q(this.video_pkt.dts(), this.video_c.time_base(), this.video_st.time_base()));
                }
                this.video_pkt.stream_index(this.video_st.index());
            } else {
                return false;
            }
        }
        avformat.AVFormatContext aVFormatContext = this.oc;
        synchronized (aVFormatContext) {
            if (this.interleaved && this.audio_st != null) {
                ret = avformat.av_interleaved_write_frame(this.oc, this.video_pkt);
                if (ret < 0) {
                    throw new FrameRecorder.Exception("av_interleaved_write_frame() error " + ret + " while writing interleaved video frame.");
                }
            } else {
                ret = avformat.av_write_frame(this.oc, this.video_pkt);
                if (ret < 0) {
                    throw new FrameRecorder.Exception("av_write_frame() error " + ret + " while writing video frame.");
                }
            }
        }
        return this.picture.key_frame() != 0;
    }

    public boolean record(Buffer ... samples) throws FrameRecorder.Exception {
        int ret;
        Buffer b;
        int i;
        if (this.audio_st == null) {
            throw new FrameRecorder.Exception("No audio output stream (Is audioChannels > 0 and has start() been called?)");
        }
        int inputSize = samples[0].limit() - samples[0].position();
        int inputFormat = -1;
        int inputChannels = samples.length > 1 ? 1 : this.audioChannels;
        int inputDepth = 0;
        int outputFormat = this.audio_c.sample_fmt();
        int outputChannels = this.samples_out.length > 1 ? 1 : this.audioChannels;
        int outputDepth = avutil.av_get_bytes_per_sample(outputFormat);
        if (samples[0] instanceof ByteBuffer) {
            inputFormat = samples.length > 1 ? 5 : 0;
            inputDepth = 1;
            for (i = 0; i < samples.length; ++i) {
                b = (ByteBuffer)samples[i];
                if (this.samples_in[i] instanceof BytePointer && this.samples_in[i].capacity() >= inputSize && ((ByteBuffer)b).hasArray()) {
                    ((BytePointer)this.samples_in[i]).position(0).put(((ByteBuffer)b).array(), b.position(), inputSize);
                    continue;
                }
                this.samples_in[i] = new BytePointer((ByteBuffer)b);
            }
        } else if (samples[0] instanceof ShortBuffer) {
            inputFormat = samples.length > 1 ? 6 : 1;
            inputDepth = 2;
            for (i = 0; i < samples.length; ++i) {
                b = (ShortBuffer)samples[i];
                if (this.samples_in[i] instanceof ShortPointer && this.samples_in[i].capacity() >= inputSize && ((ShortBuffer)b).hasArray()) {
                    ((ShortPointer)this.samples_in[i]).position(0).put(((ShortBuffer)b).array(), samples[i].position(), inputSize);
                    continue;
                }
                this.samples_in[i] = new ShortPointer((ShortBuffer)b);
            }
        } else if (samples[0] instanceof IntBuffer) {
            inputFormat = samples.length > 1 ? 7 : 2;
            inputDepth = 4;
            for (i = 0; i < samples.length; ++i) {
                b = (IntBuffer)samples[i];
                if (this.samples_in[i] instanceof IntPointer && this.samples_in[i].capacity() >= inputSize && ((IntBuffer)b).hasArray()) {
                    ((IntPointer)this.samples_in[i]).position(0).put(((IntBuffer)b).array(), samples[i].position(), inputSize);
                    continue;
                }
                this.samples_in[i] = new IntPointer((IntBuffer)b);
            }
        } else if (samples[0] instanceof FloatBuffer) {
            inputFormat = samples.length > 1 ? 8 : 3;
            inputDepth = 4;
            for (i = 0; i < samples.length; ++i) {
                b = (FloatBuffer)samples[i];
                if (this.samples_in[i] instanceof FloatPointer && this.samples_in[i].capacity() >= inputSize && ((FloatBuffer)b).hasArray()) {
                    ((FloatPointer)this.samples_in[i]).position(0).put(((FloatBuffer)b).array(), b.position(), inputSize);
                    continue;
                }
                this.samples_in[i] = new FloatPointer((FloatBuffer)b);
            }
        } else if (samples[0] instanceof DoubleBuffer) {
            inputFormat = samples.length > 1 ? 9 : 4;
            inputDepth = 8;
            for (i = 0; i < samples.length; ++i) {
                b = (DoubleBuffer)samples[i];
                if (this.samples_in[i] instanceof DoublePointer && this.samples_in[i].capacity() >= inputSize && ((DoubleBuffer)b).hasArray()) {
                    ((DoublePointer)this.samples_in[i]).position(0).put(((DoubleBuffer)b).array(), b.position(), inputSize);
                    continue;
                }
                this.samples_in[i] = new DoublePointer((DoubleBuffer)b);
            }
        } else {
            throw new FrameRecorder.Exception("Audio samples Buffer has unsupported type: " + samples);
        }
        if (this.samples_convert_ctx == null) {
            this.samples_convert_ctx = swresample.swr_alloc_set_opts(null, this.audio_c.channel_layout(), outputFormat, this.audio_c.sample_rate(), this.audio_c.channel_layout(), inputFormat, this.audio_c.sample_rate(), 0, null);
            if (this.samples_convert_ctx == null) {
                throw new FrameRecorder.Exception("swr_alloc_set_opts() error: Cannot allocate the conversion context.");
            }
            ret = swresample.swr_init(this.samples_convert_ctx);
            if (ret < 0) {
                throw new FrameRecorder.Exception("swr_init() error " + ret + ": Cannot initialize the conversion context.");
            }
        }
        for (i = 0; i < samples.length; ++i) {
            ((Pointer)this.samples_in[i].position(this.samples_in[i].position() * inputDepth)).limit((this.samples_in[i].position() + inputSize) * inputDepth);
        }
        while (this.samples_in[0].position() < this.samples_in[0].limit()) {
            int i2;
            int inputCount = (this.samples_in[0].limit() - this.samples_in[0].position()) / (inputChannels * inputDepth);
            int outputCount = (this.samples_out[0].limit() - this.samples_out[0].position()) / (outputChannels * outputDepth);
            int count = Math.min(inputCount, outputCount);
            for (i2 = 0; i2 < samples.length; ++i2) {
                this.samples_in_ptr.put(i2, this.samples_in[i2]);
            }
            for (i2 = 0; i2 < this.samples_out.length; ++i2) {
                this.samples_out_ptr.put(i2, (Pointer)this.samples_out[i2]);
            }
            ret = swresample.swr_convert(this.samples_convert_ctx, this.samples_out_ptr, count, this.samples_in_ptr, count);
            if (ret < 0) {
                throw new FrameRecorder.Exception("swr_convert() error " + ret + ": Cannot convert audio samples.");
            }
            for (i2 = 0; i2 < samples.length; ++i2) {
                this.samples_in[i2].position(this.samples_in[i2].position() + ret * inputChannels * inputDepth);
            }
            for (i2 = 0; i2 < this.samples_out.length; ++i2) {
                this.samples_out[i2].position(this.samples_out[i2].position() + ret * outputChannels * outputDepth);
            }
            if (this.samples_out[0].position() < this.samples_out[0].limit()) continue;
            this.frame.nb_samples(this.audio_input_frame_size);
            avcodec.avcodec_fill_audio_frame(this.frame, this.audio_c.channels(), outputFormat, this.samples_out[0], this.samples_out[0].limit(), 0);
            for (i2 = 0; i2 < this.samples_out.length; ++i2) {
                this.frame.data(i2, this.samples_out[i2].position(0));
                this.frame.linesize(i2, this.samples_out[i2].limit());
            }
            this.frame.quality(this.audio_c.global_quality());
            this.record(this.frame);
        }
        return this.frame.key_frame() != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean record(avutil.AVFrame frame) throws FrameRecorder.Exception {
        avcodec.av_init_packet(this.audio_pkt);
        this.audio_pkt.data(this.audio_outbuf);
        this.audio_pkt.size(this.audio_outbuf_size);
        int ret = avcodec.avcodec_encode_audio2(this.audio_c, this.audio_pkt, frame, this.got_audio_packet);
        if (ret < 0) {
            throw new FrameRecorder.Exception("avcodec_encode_audio2() error " + ret + ": Could not encode audio packet.");
        }
        if (this.got_audio_packet[0] != 0) {
            if (this.audio_pkt.pts() != avutil.AV_NOPTS_VALUE) {
                this.audio_pkt.pts(avutil.av_rescale_q(this.audio_pkt.pts(), this.audio_c.time_base(), this.audio_c.time_base()));
            }
            if (this.audio_pkt.dts() != avutil.AV_NOPTS_VALUE) {
                this.audio_pkt.dts(avutil.av_rescale_q(this.audio_pkt.dts(), this.audio_c.time_base(), this.audio_c.time_base()));
            }
        } else {
            return false;
        }
        this.audio_pkt.flags(this.audio_pkt.flags() | 1);
        this.audio_pkt.stream_index(this.audio_st.index());
        avformat.AVFormatContext aVFormatContext = this.oc;
        synchronized (aVFormatContext) {
            if (this.interleaved && this.video_st != null) {
                ret = avformat.av_interleaved_write_frame(this.oc, this.audio_pkt);
                if (ret < 0) {
                    throw new FrameRecorder.Exception("av_interleaved_write_frame() error " + ret + " while writing interleaved audio frame.");
                }
            } else {
                ret = avformat.av_write_frame(this.oc, this.audio_pkt);
                if (ret < 0) {
                    throw new FrameRecorder.Exception("av_write_frame() error " + ret + " while writing audio frame.");
                }
            }
        }
        return true;
    }
}

