/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javacv;

import com.googlecode.javacpp.BytePointer;
import com.googlecode.javacpp.DoublePointer;
import com.googlecode.javacpp.IntPointer;
import com.googlecode.javacpp.Loader;
import com.googlecode.javacpp.Pointer;
import com.googlecode.javacpp.PointerPointer;
import com.googlecode.javacv.Frame;
import com.googlecode.javacv.FrameGrabber;
import com.googlecode.javacv.cpp.avcodec;
import com.googlecode.javacv.cpp.avdevice;
import com.googlecode.javacv.cpp.avformat;
import com.googlecode.javacv.cpp.avutil;
import com.googlecode.javacv.cpp.opencv_core;
import com.googlecode.javacv.cpp.swscale;
import java.io.File;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public class FFmpegFrameGrabber
extends FrameGrabber {
    private static FrameGrabber.Exception loadingException = null;
    private String filename;
    private avformat.AVFormatContext oc;
    private avformat.AVStream video_st;
    private avformat.AVStream audio_st;
    private avcodec.AVCodecContext video_c;
    private avcodec.AVCodecContext audio_c;
    private avutil.AVFrame picture;
    private avutil.AVFrame picture_rgb;
    private BytePointer buffer_rgb;
    private avutil.AVFrame samples_frame;
    private BytePointer[] samples_ptr;
    private Buffer[] samples_buf;
    private avcodec.AVPacket pkt;
    private avcodec.AVPacket pkt2;
    private int sizeof_pkt;
    private int[] got_frame;
    private swscale.SwsContext img_convert_ctx;
    private opencv_core.IplImage return_image;
    private boolean frameGrabbed;
    private Frame frame;

    public static String[] getDeviceDescriptions() throws FrameGrabber.Exception {
        FFmpegFrameGrabber.tryLoad();
        throw new UnsupportedOperationException("Device enumeration not support by FFmpeg.");
    }

    public static FFmpegFrameGrabber createDefault(File deviceFile) throws FrameGrabber.Exception {
        return new FFmpegFrameGrabber(deviceFile);
    }

    public static FFmpegFrameGrabber createDefault(String devicePath) throws FrameGrabber.Exception {
        return new FFmpegFrameGrabber(devicePath);
    }

    public static FFmpegFrameGrabber createDefault(int deviceNumber) throws FrameGrabber.Exception {
        return null;
    }

    public static void tryLoad() throws FrameGrabber.Exception {
        if (loadingException != null) {
            throw loadingException;
        }
        try {
            Loader.load(avutil.class);
            Loader.load(avcodec.class);
            Loader.load(avformat.class);
            Loader.load(avdevice.class);
            Loader.load(swscale.class);
        }
        catch (Throwable t) {
            if (t instanceof FrameGrabber.Exception) {
                loadingException = (FrameGrabber.Exception)t;
                throw loadingException;
            }
            loadingException = new FrameGrabber.Exception("Failed to load " + FFmpegFrameGrabber.class, t);
            throw loadingException;
        }
    }

    public FFmpegFrameGrabber(File file) {
        this(file.getAbsolutePath());
    }

    public FFmpegFrameGrabber(String filename) {
        avcodec.avcodec_register_all();
        avdevice.avdevice_register_all();
        avformat.av_register_all();
        avformat.avformat_network_init();
        this.filename = filename;
    }

    public void release() throws FrameGrabber.Exception {
        if (this.pkt != null && this.pkt2 != null) {
            if (this.pkt2.size() > 0) {
                avcodec.av_free_packet(this.pkt);
            }
            this.pkt2 = null;
            this.pkt = null;
        }
        if (this.buffer_rgb != null) {
            avutil.av_free(this.buffer_rgb);
            this.buffer_rgb = null;
        }
        if (this.picture_rgb != null) {
            avcodec.avcodec_free_frame(this.picture_rgb);
            this.picture_rgb = null;
        }
        if (this.picture != null) {
            avcodec.avcodec_free_frame(this.picture);
            this.picture = null;
        }
        if (this.video_c != null) {
            avcodec.avcodec_close(this.video_c);
            this.video_c = null;
        }
        if (this.samples_frame != null) {
            avcodec.avcodec_free_frame(this.samples_frame);
            this.samples_frame = null;
        }
        if (this.audio_c != null) {
            avcodec.avcodec_close(this.audio_c);
            this.audio_c = null;
        }
        if (this.oc != null && !this.oc.isNull()) {
            avformat.avformat_close_input(this.oc);
            this.oc = null;
        }
        if (this.img_convert_ctx != null) {
            swscale.sws_freeContext(this.img_convert_ctx);
            this.img_convert_ctx = null;
        }
        this.got_frame = null;
        this.return_image = null;
        this.frameGrabbed = false;
        this.frame = null;
        this.timestamp = 0L;
        this.frameNumber = 0;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.release();
    }

    public double getGamma() {
        if (this.gamma == 0.0) {
            return 2.2;
        }
        return this.gamma;
    }

    public String getFormat() {
        if (this.oc == null) {
            return super.getFormat();
        }
        return this.oc.iformat().name().getString();
    }

    public int getImageWidth() {
        return this.return_image == null ? super.getImageWidth() : this.return_image.width();
    }

    public int getImageHeight() {
        return this.return_image == null ? super.getImageHeight() : this.return_image.height();
    }

    public int getAudioChannels() {
        return this.audio_c == null ? super.getAudioChannels() : this.audio_c.channels();
    }

    public int getPixelFormat() {
        if (this.imageMode == FrameGrabber.ImageMode.COLOR || this.imageMode == FrameGrabber.ImageMode.GRAY) {
            if (this.pixelFormat == -1) {
                return this.imageMode == FrameGrabber.ImageMode.COLOR ? 3 : 8;
            }
            return this.pixelFormat;
        }
        if (this.video_c != null) {
            return this.video_c.pix_fmt();
        }
        return super.getPixelFormat();
    }

    public double getFrameRate() {
        if (this.video_st == null) {
            return super.getFrameRate();
        }
        avutil.AVRational r = this.video_st.r_frame_rate();
        return (double)r.num() / (double)r.den();
    }

    public int getSampleFormat() {
        return this.audio_c == null ? super.getSampleFormat() : this.audio_c.sample_fmt();
    }

    public int getSampleRate() {
        return this.audio_c == null ? super.getSampleRate() : this.audio_c.sample_rate();
    }

    public void setFrameNumber(int frameNumber) throws FrameGrabber.Exception {
        this.setTimestamp(Math.round((double)(1000000L * (long)frameNumber) / this.getFrameRate()));
    }

    public void setTimestamp(long timestamp) throws FrameGrabber.Exception {
        if (this.oc == null || this.video_c == null) {
            super.setTimestamp(timestamp);
        } else {
            int ret;
            timestamp = timestamp * 1000000L / 1000000L;
            if (this.oc.start_time() != avutil.AV_NOPTS_VALUE) {
                timestamp += this.oc.start_time();
            }
            if ((ret = avformat.avformat_seek_file(this.oc, -1, Long.MIN_VALUE, timestamp, Long.MAX_VALUE, 1)) < 0) {
                throw new FrameGrabber.Exception("avformat_seek_file() error " + ret + ": Could not seek file to timestamp " + timestamp + ".");
            }
            avcodec.avcodec_flush_buffers(this.video_c);
            if (this.audio_c != null) {
                avcodec.avcodec_flush_buffers(this.audio_c);
            }
            while (this.timestamp > timestamp && this.grab(false) != null) {
            }
            while (this.timestamp < timestamp && this.grab(false) != null) {
            }
            this.frameGrabbed = true;
        }
    }

    public int getLengthInFrames() {
        return (int)((double)this.getLengthInTime() * this.getFrameRate() / 1000000.0);
    }

    public long getLengthInTime() {
        return this.oc.duration() * 1000000L / 1000000L;
    }

    public void start() throws FrameGrabber.Exception {
        int ret;
        this.img_convert_ctx = null;
        this.oc = new avformat.AVFormatContext(null);
        this.video_c = null;
        this.audio_c = null;
        this.pkt = new avcodec.AVPacket();
        this.pkt2 = new avcodec.AVPacket();
        this.sizeof_pkt = this.pkt.sizeof();
        this.got_frame = new int[1];
        this.return_image = null;
        this.frameGrabbed = false;
        this.frame = new Frame();
        this.timestamp = 0L;
        this.frameNumber = 0;
        this.pkt2.size(0);
        avformat.AVInputFormat f = null;
        if (this.format != null && this.format.length() > 0 && (f = avformat.av_find_input_format(this.format)) == null) {
            throw new FrameGrabber.Exception("av_find_input_format() error: Could not find input format \"" + this.format + "\".");
        }
        avutil.AVDictionary options = new avutil.AVDictionary(null);
        if (this.frameRate > 0.0) {
            avutil.AVRational r = avutil.av_d2q(this.frameRate, 1001000);
            avutil.av_dict_set(options, "framerate", r.num() + "/" + r.den(), 0);
        }
        if (this.imageMode != FrameGrabber.ImageMode.RAW) {
            avutil.av_dict_set(options, "pixel_format", this.imageMode == FrameGrabber.ImageMode.COLOR ? "bgr24" : "gray8", 0);
        }
        if (this.imageWidth > 0 && this.imageHeight > 0) {
            avutil.av_dict_set(options, "video_size", this.imageWidth + "x" + this.imageHeight, 0);
        }
        if (this.sampleRate > 0) {
            avutil.av_dict_set(options, "sample_rate", "" + this.sampleRate, 0);
        }
        if (this.audioChannels > 0) {
            avutil.av_dict_set(options, "channels", "" + this.audioChannels, 0);
        }
        if ((ret = avformat.avformat_open_input(this.oc, this.filename, f, options)) < 0) {
            throw new FrameGrabber.Exception("avformat_open_input() error " + ret + ": Could not open input \"" + this.filename + "\". (Has setFormat() been called?)");
        }
        avutil.av_dict_free(options);
        ret = avformat.avformat_find_stream_info(this.oc, (PointerPointer)null);
        if (ret < 0) {
            throw new FrameGrabber.Exception("avformat_find_stream_info() error " + ret + ": Could not find stream information.");
        }
        avformat.av_dump_format(this.oc, 0, this.filename, 0);
        this.audio_st = null;
        this.video_st = null;
        int nb_streams = this.oc.nb_streams();
        for (int i = 0; i < nb_streams; ++i) {
            avformat.AVStream st = this.oc.streams(i);
            avcodec.AVCodecContext c = st.codec();
            if (this.video_st == null && c.codec_type() == 0) {
                this.video_st = st;
                this.video_c = c;
                continue;
            }
            if (this.audio_st != null || c.codec_type() != 1) continue;
            this.audio_st = st;
            this.audio_c = c;
        }
        if (this.video_st == null && this.audio_st == null) {
            throw new FrameGrabber.Exception("Did not find a video or audio stream inside \"" + this.filename + "\".");
        }
        if (this.video_st != null) {
            avcodec.AVCodec codec = avcodec.avcodec_find_decoder(this.video_c.codec_id());
            if (codec == null) {
                throw new FrameGrabber.Exception("avcodec_find_decoder() error: Unsupported video format or codec not found: " + this.video_c.codec_id() + ".");
            }
            ret = avcodec.avcodec_open2(this.video_c, codec, (PointerPointer)null);
            if (ret < 0) {
                throw new FrameGrabber.Exception("avcodec_open2() error " + ret + ": Could not open video codec.");
            }
            if (this.video_c.time_base().num() > 1000 && this.video_c.time_base().den() == 1) {
                this.video_c.time_base().den(1000);
            }
            if ((this.picture = avcodec.avcodec_alloc_frame()) == null) {
                throw new FrameGrabber.Exception("avcodec_alloc_frame() error: Could not allocate raw picture frame.");
            }
            this.picture_rgb = avcodec.avcodec_alloc_frame();
            if (this.picture_rgb == null) {
                throw new FrameGrabber.Exception("avcodec_alloc_frame() error: Could not allocate RGB picture frame.");
            }
            int width = this.getImageWidth() > 0 ? this.getImageWidth() : this.video_c.width();
            int height = this.getImageHeight() > 0 ? this.getImageHeight() : this.video_c.height();
            switch (this.imageMode) {
                case COLOR: 
                case GRAY: {
                    int fmt = this.getPixelFormat();
                    int size = avcodec.avpicture_get_size(fmt, width, height);
                    this.buffer_rgb = new BytePointer(avutil.av_malloc(size));
                    avcodec.avpicture_fill(new avcodec.AVPicture(this.picture_rgb), this.buffer_rgb, fmt, width, height);
                    this.return_image = opencv_core.IplImage.createHeader(width, height, 8, 1);
                    break;
                }
                case RAW: {
                    this.buffer_rgb = null;
                    this.return_image = opencv_core.IplImage.createHeader(this.video_c.width(), this.video_c.height(), 8, 1);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }
        if (this.audio_st != null) {
            avcodec.AVCodec codec = avcodec.avcodec_find_decoder(this.audio_c.codec_id());
            if (codec == null) {
                throw new FrameGrabber.Exception("avcodec_find_decoder() error: Unsupported audio format or codec not found: " + this.audio_c.codec_id() + ".");
            }
            ret = avcodec.avcodec_open2(this.audio_c, codec, (PointerPointer)null);
            if (ret < 0) {
                throw new FrameGrabber.Exception("avcodec_open2() error " + ret + ": Could not open audio codec.");
            }
            this.samples_frame = avcodec.avcodec_alloc_frame();
            if (this.samples_frame == null) {
                throw new FrameGrabber.Exception("avcodec_alloc_frame() error: Could not allocate audio frame.");
            }
        }
    }

    public void stop() throws FrameGrabber.Exception {
        this.release();
    }

    public void trigger() throws FrameGrabber.Exception {
        if (this.oc == null || this.oc.isNull()) {
            throw new FrameGrabber.Exception("Could not trigger: No AVFormatContext. (Has start() been called?)");
        }
        if (this.pkt2.size() > 0) {
            this.pkt2.size(0);
            avcodec.av_free_packet(this.pkt);
        }
        for (int i = 0; i < this.numBuffers + 1; ++i) {
            if (avformat.av_read_frame(this.oc, this.pkt) < 0) {
                return;
            }
            avcodec.av_free_packet(this.pkt);
        }
    }

    private void processImage() throws FrameGrabber.Exception {
        switch (this.imageMode) {
            case COLOR: 
            case GRAY: {
                if (this.deinterlace) {
                    avcodec.AVPicture p = new avcodec.AVPicture(this.picture);
                    avcodec.avpicture_deinterlace(p, p, this.video_c.pix_fmt(), this.video_c.width(), this.video_c.height());
                }
                this.img_convert_ctx = swscale.sws_getCachedContext(this.img_convert_ctx, this.video_c.width(), this.video_c.height(), this.video_c.pix_fmt(), this.getImageWidth(), this.getImageHeight(), this.getPixelFormat(), 2, null, null, (DoublePointer)null);
                if (this.img_convert_ctx == null) {
                    throw new FrameGrabber.Exception("sws_getCachedContext() error: Cannot initialize the conversion context.");
                }
                swscale.sws_scale(this.img_convert_ctx, new PointerPointer((Pointer)this.picture), this.picture.linesize(), 0, this.video_c.height(), new PointerPointer((Pointer)this.picture_rgb), this.picture_rgb.linesize());
                this.return_image.imageData(this.buffer_rgb);
                this.return_image.widthStep(this.picture_rgb.linesize(0));
                break;
            }
            case RAW: {
                assert (this.video_c.width() == this.return_image.width() && this.video_c.height() == this.return_image.height());
                this.return_image.imageData(this.picture.data(0));
                this.return_image.widthStep(this.picture.linesize(0));
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        this.return_image.imageSize(this.return_image.height() * this.return_image.widthStep());
        this.return_image.nChannels(this.return_image.widthStep() / this.return_image.width());
    }

    public opencv_core.IplImage grab() throws FrameGrabber.Exception {
        Frame frame = this.grabFrame(true, false);
        return frame != null ? frame.image : null;
    }

    private opencv_core.IplImage grab(boolean processImage) throws FrameGrabber.Exception {
        Frame frame = this.grabFrame(processImage, false);
        return frame != null ? frame.image : null;
    }

    public Frame grabFrame() throws FrameGrabber.Exception {
        return this.grabFrame(true, true);
    }

    private Frame grabFrame(boolean processImage, boolean doAudio) throws FrameGrabber.Exception {
        this.frame.keyFrame = false;
        this.frame.image = null;
        this.frame.samples = null;
        if (this.frameGrabbed) {
            this.frameGrabbed = false;
            if (processImage) {
                this.processImage();
            }
            this.frame.image = this.return_image;
            return this.frame;
        }
        if (this.oc == null || this.oc.isNull()) {
            throw new FrameGrabber.Exception("Could not grab: No AVFormatContext. (Has start() been called?)");
        }
        boolean done = false;
        while (!done) {
            avutil.AVRational time_base;
            long pts;
            int len;
            if (this.pkt2.size() <= 0 && avformat.av_read_frame(this.oc, this.pkt) < 0) {
                if (this.video_st != null) {
                    this.pkt.stream_index(this.video_st.index());
                    this.pkt.data(null);
                    this.pkt.size(0);
                } else {
                    return null;
                }
            }
            if (this.video_st != null && this.pkt.stream_index() == this.video_st.index()) {
                len = avcodec.avcodec_decode_video2(this.video_c, this.picture, this.got_frame, this.pkt);
                if (len >= 0 && this.got_frame[0] != 0) {
                    pts = avutil.av_frame_get_best_effort_timestamp(this.picture);
                    time_base = this.video_st.time_base();
                    this.timestamp = 1000000L * pts * (long)time_base.num() / (long)time_base.den();
                    this.frameNumber = (int)((double)this.timestamp * this.getFrameRate() / 1000000.0);
                    if (processImage) {
                        this.processImage();
                    }
                    done = true;
                    this.frame.keyFrame = this.picture.key_frame() != 0;
                    this.frame.image = this.return_image;
                } else if (this.pkt.data() == null && this.pkt.size() == 0) {
                    return null;
                }
            } else if (doAudio && this.audio_st != null && this.pkt.stream_index() == this.audio_st.index()) {
                if (this.pkt2.size() <= 0) {
                    BytePointer.memcpy(this.pkt2, this.pkt, this.sizeof_pkt);
                }
                avcodec.avcodec_get_frame_defaults(this.samples_frame);
                len = avcodec.avcodec_decode_audio4(this.audio_c, this.samples_frame, this.got_frame, this.pkt2);
                if (len <= 0) {
                    this.pkt2.size(0);
                } else {
                    this.pkt2.data(this.pkt2.data().position(len));
                    this.pkt2.size(this.pkt2.size() - len);
                    if (this.got_frame[0] != 0) {
                        pts = avutil.av_frame_get_best_effort_timestamp(this.samples_frame);
                        time_base = this.audio_st.time_base();
                        this.timestamp = 1000000L * pts * (long)time_base.num() / (long)time_base.den();
                        done = true;
                        int sample_format = this.samples_frame.format();
                        int planes = avutil.av_sample_fmt_is_planar(sample_format) != 0 ? this.samples_frame.channels() : 1;
                        int data_size = avutil.av_samples_get_buffer_size((IntPointer)null, this.audio_c.channels(), this.samples_frame.nb_samples(), this.audio_c.sample_fmt(), 1) / planes;
                        if (this.samples_buf == null || this.samples_buf.length != planes) {
                            this.samples_ptr = new BytePointer[planes];
                            this.samples_buf = new Buffer[planes];
                        }
                        this.frame.keyFrame = this.samples_frame.key_frame() != 0;
                        this.frame.samples = this.samples_buf;
                        int sample_size = data_size / avutil.av_get_bytes_per_sample(sample_format);
                        for (int i = 0; i < planes; ++i) {
                            BytePointer p = this.samples_frame.data(i);
                            if (!p.equals(this.samples_ptr[i]) || this.samples_ptr[i].capacity() < data_size) {
                                this.samples_ptr[i] = p.capacity(data_size);
                                ByteBuffer b = p.asBuffer();
                                switch (sample_format) {
                                    case 0: 
                                    case 5: {
                                        this.samples_buf[i] = b;
                                        break;
                                    }
                                    case 1: 
                                    case 6: {
                                        this.samples_buf[i] = b.asShortBuffer();
                                        break;
                                    }
                                    case 2: 
                                    case 7: {
                                        this.samples_buf[i] = b.asIntBuffer();
                                        break;
                                    }
                                    case 3: 
                                    case 8: {
                                        this.samples_buf[i] = b.asFloatBuffer();
                                        break;
                                    }
                                    case 4: 
                                    case 9: {
                                        this.samples_buf[i] = b.asDoubleBuffer();
                                        break;
                                    }
                                    default: {
                                        assert (false);
                                        break;
                                    }
                                }
                            }
                            this.samples_buf[i].position(0).limit(sample_size);
                        }
                    }
                }
            }
            if (this.pkt2.size() > 0) continue;
            avcodec.av_free_packet(this.pkt);
        }
        return this.frame;
    }
}

