/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.tools.tags;

import java.util.StringTokenizer;
import javax.speech.recognition.Rule;
import javax.speech.recognition.RuleAlternatives;
import javax.speech.recognition.RuleName;
import javax.speech.recognition.RuleParse;
import javax.speech.recognition.RuleSequence;
import javax.speech.recognition.RuleTag;
import javax.speech.recognition.RuleToken;

public class ActionTagsUtilities {
    protected static final String TOKENS = "$tokens";
    protected static final String PHRASE = "$phrase";
    protected static final String VALUE = "$value";
    protected static final String LAST_RULE = "$";
    protected static final String RULE_PREFIX = "$";
    protected static final String CLASS_NAME = "Rule";
    protected static final String METHOD_NAME = "__constructor";
    protected static final String INDENT = "    ";
    private static boolean debug;

    public static void setDebugging(boolean newDebug) {
        debug = newDebug;
    }

    public static boolean isDebugging() {
        return debug;
    }

    public static String getClassDefinitions() {
        return "// Constructor for the Rule class\nfunction Rule() {\n    this.$tokens = new Array();\n    this.$phrase = '';\n}\n\nRule.prototype.valueOf = function() {\n    var tmp = this.getValue();\n    if (tmp == undefined)\n        return this;\n    else\n        return tmp;\n}\n\nRule.prototype.getValue = function() {\n    return this.$value;\n}\n\nRule.prototype.setValue = function(v) {\n    this.$value = v;\n}\n\nRule.prototype.toString = function() {\n    return this.getPhrase();\n}\n\nRule.prototype.addTokens = function(token, phrase) {\n    this.$tokens = this.$tokens.concat(token);\n    if (this.$phrase == '')\n        this.$phrase = phrase;\n    else\n        this.$phrase = this.$phrase.concat(' ' + phrase);\n}\n\nRule.prototype.getTokens = function() {\n    return this.$tokens;\n}\n\nRule.prototype.setTokens = function(v) {\n    this.$tokens = v;\n}\n\nRule.prototype.getPhrase = function() {\n    return this.$phrase;\n}\n\nRule.prototype.setPhrase = function(v) {\n    this.$phrase = v;\n}\n\n";
    }

    public static String getScript(RuleParse ruleParse) {
        StringBuilder script = new StringBuilder();
        ActionTagsUtilities.parseTags((Rule)ruleParse, script, null, "", true);
        return script.toString();
    }

    public static String getParseTree(RuleParse ruleParse) {
        StringBuilder parseTree = new StringBuilder();
        ActionTagsUtilities.parseTags((Rule)ruleParse, null, parseTree, "", true);
        return parseTree.toString();
    }

    protected static void appendDebugScript(StringBuilder script, String indent, String tag) {
        StringTokenizer st = new StringTokenizer(tag.trim(), "\"");
        StringBuilder sb = new StringBuilder();
        if (st.hasMoreTokens()) {
            sb.append(st.nextToken());
            while (st.hasMoreTokens()) {
                sb.append("\\\"");
                sb.append(st.nextToken());
            }
        }
        script.append(indent).append("//vvvvvvvvvvvvvv DEBUG vvvvvvvvvvvvvv//\n");
        st = new StringTokenizer(sb.toString(), "\n");
        sb = new StringBuilder();
        sb.append(st.nextToken());
        while (st.hasMoreTokens()) {
            sb.append("\\n");
            sb.append(st.nextToken());
        }
        script.append(indent).append("var dbgStr = debug(\"<\" + this.$name + \"> ").append((CharSequence)sb).append("\");\n");
        script.append(indent).append("while (dbgStr != null) {\n");
        script.append(indent).append("    print(\"dbgStr = \" + dbgStr);\n");
        script.append(indent).append("    if (dbgStr == \"skip\") {\n");
        script.append(indent).append("        dbgStr = null;\n");
        script.append(indent).append("    } else if (dbgStr == \"step\") {\n");
        script.append(indent).append("        //vvvvvvvvvv FROM GRAMMAR vvvvvvvvvv\n");
        script.append(indent).append("        ").append(tag.trim()).append('\n');
        script.append(indent).append("        //^^^^^^^^^^ FROM GRAMMAR ^^^^^^^^^^\n");
        script.append(indent).append("        dbgStr = null;\n");
        script.append(indent).append("    } else {\n");
        script.append(indent).append("        dbgStr = debug(eval(dbgStr));\n");
        script.append(indent).append("    }\n");
        script.append(indent).append("}\n");
        script.append(indent).append("//^^^^^^^^^^^^^^ DEBUG ^^^^^^^^^^^^^^//\n");
    }

    protected static void parseTags(Rule rule, StringBuilder script, StringBuilder parseTree, String indent, boolean root) {
        if (rule instanceof RuleParse) {
            RuleParse p = (RuleParse)rule;
            String simpleRuleName = p.getRuleName().getSimpleRuleName();
            String ruleName = p.getRuleName().getRuleName();
            String objName = "$" + simpleRuleName;
            if (parseTree != null) {
                parseTree.append(indent).append('<').append(ruleName).append(">\n");
            }
            if (script != null) {
                script.append(indent).append("var $;\n");
                script.append(indent).append("var ").append(objName).append(" = new Rule();\n");
                script.append(indent).append(objName).append(".__constructor = function() {\n");
                script.append(indent).append("    this.$name = \"").append(objName).append("\";\n");
            }
            ActionTagsUtilities.parseTags(p.getRule(), script, parseTree, indent + INDENT, false);
            if (script != null) {
                script.append(indent).append("    if (this.$value == undefined) {\n");
                script.append(indent).append("        this.$value = this.getPhrase();\n");
                script.append(indent).append("    }\n");
                script.append(indent).append("}\n");
                script.append(indent).append(objName).append(".__constructor();\n");
                script.append(indent).append("$ = ").append(objName).append(";\n");
                if (!root) {
                    script.append(indent).append("this.addTokens($.getTokens(), $.getPhrase());\n");
                } else {
                    script.append(indent).append("delete ").append(objName).append(";\n");
                }
            }
        } else if (rule instanceof RuleSequence || rule instanceof RuleAlternatives) {
            Rule[] rules = rule instanceof RuleSequence ? ((RuleSequence)rule).getRules() : ((RuleAlternatives)rule).getRules();
            if (rules != null) {
                for (Rule rule1 : rules) {
                    ActionTagsUtilities.parseTags(rule1, script, parseTree, indent, false);
                }
            }
        } else if (rule instanceof RuleToken) {
            String t = '\'' + ((RuleToken)rule).getText() + '\'';
            if (parseTree != null) {
                parseTree.append(indent).append(t).append('\n');
            }
            if (script != null) {
                script.append(indent).append("this.addTokens(").append(t).append(',').append(t).append(");\n");
            }
        } else if (rule instanceof RuleTag) {
            ActionTagsUtilities.parseTags(((RuleTag)rule).getRule(), script, parseTree, indent, false);
            String tag = ((RuleTag)rule).getTag();
            if (parseTree != null) {
                parseTree.append(indent).append('{').append(tag).append("}\n");
            }
            if (script != null) {
                if (ActionTagsUtilities.isDebugging()) {
                    ActionTagsUtilities.appendDebugScript(script, indent, tag);
                } else {
                    script.append(indent).append("    //vvvvvvvvvv FROM GRAMMAR vvvvvvvvvv\n");
                    script.append(indent).append('{').append(tag).append("}\n");
                    script.append(indent).append("    //^^^^^^^^^^ FROM GRAMMAR ^^^^^^^^^^\n");
                }
            }
        } else if (rule instanceof RuleName) {
            String name;
            if (parseTree != null && !(name = ((RuleName)rule).getRuleName()).equals("NULL") && !name.equals("VOID")) {
                parseTree.append(indent).append(name).append('\n');
            }
        } else {
            throw new RuntimeException("Unexected rule type " + rule.getClass().getName());
        }
    }
}

