/*
 * Decompiled with CFR 0.152.
 */
package topcodes;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import topcodes.TopCode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Scanner {
    protected BufferedImage image = null;
    protected int w = 0;
    protected int h = 0;
    protected int[] data = null;
    protected BufferedImage preview = null;
    protected int ccount = 0;
    protected int tcount = 0;
    protected int maxu = 80;

    public List<TopCode> scan(String string) throws IOException {
        return this.scan(ImageIO.read(new File(string)));
    }

    public List<TopCode> scan(BufferedImage bufferedImage) {
        this.image = bufferedImage;
        this.preview = null;
        this.w = bufferedImage.getWidth();
        this.h = bufferedImage.getHeight();
        this.data = bufferedImage.getRGB(0, 0, this.w, this.h, null, 0, this.w);
        this.threshold();
        return this.findCodes();
    }

    public List<TopCode> scan(int[] nArray, int n, int n2) {
        this.w = n;
        this.h = n2;
        this.data = nArray;
        this.preview = null;
        this.image = new BufferedImage(this.w, this.h, 1);
        this.image.setRGB(0, 0, this.w, this.h, nArray, 0, this.w);
        this.threshold();
        return this.findCodes();
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public int getImageWidth() {
        return this.w;
    }

    public int getImageHeight() {
        return this.h;
    }

    public void setMaxCodeDiameter(int n) {
        float f = (float)n / 8.0f;
        this.maxu = (int)Math.ceil(f);
    }

    protected int getCandidateCount() {
        return this.ccount;
    }

    protected int getTestedCount() {
        return this.tcount;
    }

    protected int getBW(int n, int n2) {
        int n3 = this.data[n2 * this.w + n];
        return n3 >> 24 & 1;
    }

    protected int getSample3x3(int n, int n2) {
        if (n < 1 || n > this.w - 2 || n2 < 1 || n2 >= this.h - 2) {
            return 0;
        }
        int n3 = 0;
        for (int i = n2 - 1; i <= n2 + 1; ++i) {
            for (int j = n - 1; j <= n + 1; ++j) {
                int n4 = this.data[i * this.w + j];
                if ((n4 & 0x1000000) <= 0) continue;
                n3 += 255;
            }
        }
        return n3 / 9;
    }

    protected int getBW3x3(int n, int n2) {
        if (n < 1 || n > this.w - 2 || n2 < 1 || n2 >= this.h - 2) {
            return 0;
        }
        int n3 = 0;
        for (int i = n2 - 1; i <= n2 + 1; ++i) {
            for (int j = n - 1; j <= n + 1; ++j) {
                int n4 = this.data[i * this.w + j];
                n3 += n4 >> 24 & 1;
            }
        }
        return n3 >= 5 ? 1 : 0;
    }

    protected void threshold() {
        int n = 128;
        int n2 = 30;
        this.ccount = 0;
        for (int i = 0; i < this.h; ++i) {
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = i % 2 == 0 ? 0 : this.w - 1;
            n7 += i * this.w;
            for (int j = 0; j < this.w; ++j) {
                int n8 = this.data[n7];
                int n9 = n8 >> 16 & 0xFF;
                int n10 = n8 >> 8 & 0xFF;
                int n11 = n8 & 0xFF;
                int n12 = (n9 + n10 + n11) / 3;
                n += n12 - n / n2;
                int n13 = n7 >= this.w ? (n + (this.data[n7 - this.w] & 0xFFFFFF)) / (2 * n2) : n / n2;
                double d = 0.85;
                d = 0.975;
                n12 = (double)n12 < (double)n13 * d ? 0 : 1;
                this.data[n7] = (n12 << 24) + (n & 0xFFFFFF);
                switch (n6) {
                    case 0: {
                        if (n12 != 0) break;
                        n6 = 1;
                        n5 = 1;
                        n3 = 0;
                        n4 = 0;
                        break;
                    }
                    case 1: {
                        if (n12 == 0) {
                            ++n5;
                            break;
                        }
                        n6 = 2;
                        n3 = 1;
                        break;
                    }
                    case 2: {
                        if (n12 == 0) {
                            n6 = 3;
                            n4 = 1;
                            break;
                        }
                        ++n3;
                        break;
                    }
                    case 3: {
                        if (n12 == 0) {
                            ++n4;
                            break;
                        }
                        if (n5 >= 2 && n4 >= 2 && n5 <= this.maxu && n4 <= this.maxu && n3 <= this.maxu + this.maxu && Math.abs(n5 + n4 - n3) <= n5 + n4 && Math.abs(n5 + n4 - n3) <= n3 && Math.abs(n5 - n4) <= n5 && Math.abs(n5 - n4) <= n4) {
                            int n14 = 0x2000000;
                            int n15 = 1 + n4 + n3 / 2;
                            n15 = i % 2 == 0 ? n7 - n15 : n7 + n15;
                            int n16 = n15 - 1;
                            this.data[n16] = this.data[n16] | n14;
                            int n17 = n15;
                            this.data[n17] = this.data[n17] | n14;
                            int n18 = n15 + 1;
                            this.data[n18] = this.data[n18] | n14;
                            this.ccount += 3;
                        }
                        n5 = n4;
                        n3 = 1;
                        n4 = 0;
                        n6 = 2;
                    }
                }
                n7 += i % 2 == 0 ? 1 : -1;
            }
        }
    }

    protected List<TopCode> findCodes() {
        this.tcount = 0;
        ArrayList<TopCode> arrayList = new ArrayList<TopCode>();
        TopCode topCode = new TopCode();
        int n = this.w * 2;
        for (int i = 2; i < this.h - 2; ++i) {
            for (int j = 0; j < this.w; ++j) {
                if ((this.data[n] & 0x2000000) > 0 && (this.data[n - 1] & 0x2000000) > 0 && (this.data[n + 1] & 0x2000000) > 0 && (this.data[n - this.w] & 0x2000000) > 0 && (this.data[n + this.w] & 0x2000000) > 0 && !this.overlaps(arrayList, j, i)) {
                    ++this.tcount;
                    topCode.decode(this, j, i);
                    if (topCode.isValid()) {
                        arrayList.add(topCode);
                        topCode = new TopCode();
                    }
                }
                ++n;
            }
        }
        return arrayList;
    }

    protected boolean overlaps(List<TopCode> list, int n, int n2) {
        for (TopCode topCode : list) {
            if (!topCode.inBullsEye(n, n2)) continue;
            return true;
        }
        return false;
    }

    protected int ydist(int n, int n2, int n3) {
        int n4 = this.getBW3x3(n, n2);
        for (int i = n2 + n3; i > 1 && i < this.h - 1; i += n3) {
            int n5 = this.getBW3x3(n, i);
            if (n4 + n5 != 1) continue;
            return n3 > 0 ? i - n2 : n2 - i;
        }
        return -1;
    }

    protected int xdist(int n, int n2, int n3) {
        int n4 = this.getBW3x3(n, n2);
        for (int i = n + n3; i > 1 && i < this.w - 1; i += n3) {
            int n5 = this.getBW3x3(i, n2);
            if (n4 + n5 != 1) continue;
            return n3 > 0 ? i - n : n - i;
        }
        return -1;
    }

    public BufferedImage getPreview() {
        if (this.preview != null) {
            return this.preview;
        }
        this.preview = new BufferedImage(this.w, this.h, 2);
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.h; ++i) {
            for (int j = 0; j < this.w; ++j) {
                if ((n = this.data[n2++] >> 24) == 0) {
                    n = -16777216;
                } else if (n == 1) {
                    n = -1;
                } else if (n == 3) {
                    n = -16711936;
                } else if (n == 7) {
                    n = -65536;
                }
                this.preview.setRGB(j, i, n);
            }
        }
        return this.preview;
    }
}

