/*
 * Decompiled with CFR 0.152.
 */
package org.java_websocket;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.SelectionKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.java_websocket.WebSocket;
import org.java_websocket.WebSocketListener;
import org.java_websocket.drafts.Draft;
import org.java_websocket.drafts.Draft_10;
import org.java_websocket.drafts.Draft_17;
import org.java_websocket.drafts.Draft_75;
import org.java_websocket.drafts.Draft_76;
import org.java_websocket.exceptions.IncompleteHandshakeException;
import org.java_websocket.exceptions.InvalidDataException;
import org.java_websocket.exceptions.InvalidHandshakeException;
import org.java_websocket.exceptions.WebsocketNotConnectedException;
import org.java_websocket.framing.CloseFrame;
import org.java_websocket.framing.CloseFrameBuilder;
import org.java_websocket.framing.Framedata;
import org.java_websocket.handshake.ClientHandshake;
import org.java_websocket.handshake.ClientHandshakeBuilder;
import org.java_websocket.handshake.Handshakedata;
import org.java_websocket.server.WebSocketServer;
import org.java_websocket.util.Charsetfunctions;

public class WebSocketImpl
implements WebSocket {
    public static int RCVBUF = 16384;
    public static boolean DEBUG = false;
    public static final List<Draft> defaultdraftlist = new ArrayList<Draft>(4);
    public SelectionKey key;
    public ByteChannel channel;
    public final BlockingQueue<ByteBuffer> outQueue;
    public final BlockingQueue<ByteBuffer> inQueue;
    public volatile WebSocketServer.WebSocketWorker workerThread;
    private volatile boolean flushandclosestate = false;
    private WebSocket.READYSTATE readystate = WebSocket.READYSTATE.NOT_YET_CONNECTED;
    private final WebSocketListener wsl;
    private List<Draft> knownDrafts;
    private Draft draft = null;
    private WebSocket.Role role;
    private Framedata.Opcode current_continuous_frame_opcode = null;
    private ByteBuffer tmpHandshakeBytes = ByteBuffer.allocate(0);
    private ClientHandshake handshakerequest = null;
    private String closemessage = null;
    private Integer closecode = null;
    private Boolean closedremotely = null;
    private String resourceDescriptor = null;

    static {
        defaultdraftlist.add(new Draft_17());
        defaultdraftlist.add(new Draft_10());
        defaultdraftlist.add(new Draft_76());
        defaultdraftlist.add(new Draft_75());
    }

    public WebSocketImpl(WebSocketListener listener, List<Draft> drafts) {
        this(listener, (Draft)null);
        this.role = WebSocket.Role.SERVER;
        this.knownDrafts = drafts == null || drafts.isEmpty() ? defaultdraftlist : drafts;
    }

    public WebSocketImpl(WebSocketListener listener, Draft draft) {
        if (listener == null || draft == null && this.role == WebSocket.Role.SERVER) {
            throw new IllegalArgumentException("parameters must not be null");
        }
        this.outQueue = new LinkedBlockingQueue<ByteBuffer>();
        this.inQueue = new LinkedBlockingQueue<ByteBuffer>();
        this.wsl = listener;
        this.role = WebSocket.Role.CLIENT;
        if (draft != null) {
            this.draft = draft.copyInstance();
        }
    }

    @Deprecated
    public WebSocketImpl(WebSocketListener listener, Draft draft, Socket socket) {
        this(listener, draft);
    }

    @Deprecated
    public WebSocketImpl(WebSocketListener listener, List<Draft> drafts, Socket socket) {
        this(listener, drafts);
    }

    public void decode(ByteBuffer socketBuffer) {
        assert (socketBuffer.hasRemaining());
        if (DEBUG) {
            System.out.println("process(" + socketBuffer.remaining() + "): {" + (socketBuffer.remaining() > 1000 ? "too big to display" : new String(socketBuffer.array(), socketBuffer.position(), socketBuffer.remaining())) + "}");
        }
        if (this.readystate != WebSocket.READYSTATE.NOT_YET_CONNECTED) {
            this.decodeFrames(socketBuffer);
        } else if (this.decodeHandshake(socketBuffer)) {
            assert (this.tmpHandshakeBytes.hasRemaining() != socketBuffer.hasRemaining() || !socketBuffer.hasRemaining());
            if (socketBuffer.hasRemaining()) {
                this.decodeFrames(socketBuffer);
            } else if (this.tmpHandshakeBytes.hasRemaining()) {
                this.decodeFrames(this.tmpHandshakeBytes);
            }
        }
        assert (this.isClosing() || this.isFlushAndClose() || !socketBuffer.hasRemaining());
    }

    /*
     * Exception decompiling
     */
    private boolean decodeHandshake(ByteBuffer socketBufferNew) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK], 2[TRYBLOCK]], but top level block is 28[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void open(ByteBuffer d) {
        this.readystate = WebSocket.READYSTATE.OPEN;
        try {
            this.wsl.onRawOpen(this, d);
        }
        catch (RuntimeException e) {
            this.wsl.onWebsocketError(this, e);
        }
    }

    private void decodeFrames(ByteBuffer socketBuffer) {
        try {
            if (this.draft == null) {
                return;
            }
            List<Framedata> frames = this.draft.translateFrame(socketBuffer);
            for (Framedata f : frames) {
                if (DEBUG) {
                    System.out.println("matched frame: " + f);
                }
                Framedata.Opcode curop = f.getOpcode();
                boolean fin = f.isFin();
                if (curop == Framedata.Opcode.CLOSING) {
                    int code = 1005;
                    String reason = "";
                    if (f instanceof CloseFrame) {
                        CloseFrame cf = (CloseFrame)f;
                        code = cf.getCloseCode();
                        reason = cf.getMessage();
                    }
                    if (this.readystate == WebSocket.READYSTATE.CLOSING) {
                        this.closeConnection(code, reason, true);
                        continue;
                    }
                    if (this.draft.getCloseHandshakeType() == Draft.CloseHandshakeType.TWOWAY) {
                        this.close(code, reason, true);
                        continue;
                    }
                    this.flushAndClose(code, reason, false);
                    continue;
                }
                if (curop == Framedata.Opcode.PING) {
                    this.wsl.onWebsocketPing(this, f);
                    continue;
                }
                if (curop == Framedata.Opcode.PONG) {
                    this.wsl.onWebsocketPong(this, f);
                    continue;
                }
                if (!fin || curop == Framedata.Opcode.CONTINUOUS) {
                    if (curop != Framedata.Opcode.CONTINUOUS) {
                        if (this.current_continuous_frame_opcode != null) {
                            throw new InvalidDataException(1002, "Previous continuous frame sequence not completed.");
                        }
                        this.current_continuous_frame_opcode = curop;
                    } else if (fin) {
                        if (this.current_continuous_frame_opcode == null) {
                            throw new InvalidDataException(1002, "Continuous frame sequence was not started.");
                        }
                        this.current_continuous_frame_opcode = null;
                    } else if (this.current_continuous_frame_opcode == null) {
                        throw new InvalidDataException(1002, "Continuous frame sequence was not started.");
                    }
                    try {
                        this.wsl.onWebsocketMessageFragment(this, f);
                    }
                    catch (RuntimeException e) {
                        this.wsl.onWebsocketError(this, e);
                    }
                    continue;
                }
                if (this.current_continuous_frame_opcode != null) {
                    throw new InvalidDataException(1002, "Continuous frame sequence not completed.");
                }
                if (curop == Framedata.Opcode.TEXT) {
                    try {
                        this.wsl.onWebsocketMessage((WebSocket)this, Charsetfunctions.stringUtf8(f.getPayloadData()));
                    }
                    catch (RuntimeException e) {
                        this.wsl.onWebsocketError(this, e);
                    }
                    continue;
                }
                if (curop == Framedata.Opcode.BINARY) {
                    try {
                        this.wsl.onWebsocketMessage((WebSocket)this, f.getPayloadData());
                    }
                    catch (RuntimeException e) {
                        this.wsl.onWebsocketError(this, e);
                    }
                    continue;
                }
                throw new InvalidDataException(1002, "non control or continious frame expected");
            }
        }
        catch (InvalidDataException e1) {
            this.wsl.onWebsocketError(this, e1);
            this.close(e1);
            return;
        }
    }

    private void close(int code, String message, boolean remote) {
        if (this.readystate != WebSocket.READYSTATE.CLOSING && this.readystate != WebSocket.READYSTATE.CLOSED) {
            if (this.readystate == WebSocket.READYSTATE.OPEN) {
                if (code == 1006) {
                    assert (!remote);
                    this.readystate = WebSocket.READYSTATE.CLOSING;
                    this.flushAndClose(code, message, false);
                    return;
                }
                if (this.draft == null) {
                    this.readystate = WebSocket.READYSTATE.CLOSED;
                    this.outQueue.clear();
                    if (this.channel != null) {
                        try {
                            this.channel.close();
                        }
                        catch (IOException e) {
                            this.wsl.onWebsocketError(this, e);
                        }
                    }
                    return;
                }
                if (this.draft.getCloseHandshakeType() != Draft.CloseHandshakeType.NONE) {
                    try {
                        if (!remote) {
                            try {
                                this.wsl.onWebsocketCloseInitiated(this, code, message);
                            }
                            catch (RuntimeException e) {
                                this.wsl.onWebsocketError(this, e);
                            }
                        }
                        this.sendFrame(new CloseFrameBuilder(code, message));
                    }
                    catch (InvalidDataException e) {
                        this.wsl.onWebsocketError(this, e);
                        this.flushAndClose(1006, "generated frame is invalid", false);
                    }
                }
                this.flushAndClose(code, message, remote);
            } else if (code == -3) {
                assert (remote);
                this.flushAndClose(-3, message, true);
            } else {
                this.flushAndClose(-1, message, false);
            }
            if (code == 1002) {
                this.flushAndClose(code, message, remote);
            }
            this.readystate = WebSocket.READYSTATE.CLOSING;
            this.tmpHandshakeBytes = null;
            return;
        }
    }

    @Override
    public void close(int code, String message) {
        this.close(code, message, false);
    }

    protected synchronized void closeConnection(int code, String message, boolean remote) {
        if (this.readystate == WebSocket.READYSTATE.CLOSED) {
            return;
        }
        if (this.key != null) {
            this.key.cancel();
        }
        if (this.channel != null) {
            try {
                this.channel.close();
            }
            catch (IOException e) {
                this.wsl.onWebsocketError(this, e);
            }
        }
        try {
            this.wsl.onWebsocketClose(this, code, message, remote);
        }
        catch (RuntimeException e) {
            this.wsl.onWebsocketError(this, e);
        }
        if (this.draft != null) {
            this.draft.reset();
        }
        this.handshakerequest = null;
        this.readystate = WebSocket.READYSTATE.CLOSED;
        this.outQueue.clear();
    }

    protected void closeConnection(int code, boolean remote) {
        this.closeConnection(code, "", remote);
    }

    public void closeConnection() {
        if (this.closedremotely == null) {
            throw new IllegalStateException("this method must be used in conjuction with flushAndClose");
        }
        this.closeConnection(this.closecode, this.closemessage, this.closedremotely);
    }

    @Override
    public void closeConnection(int code, String message) {
        this.closeConnection(code, message, false);
    }

    protected synchronized void flushAndClose(int code, String message, boolean remote) {
        if (this.flushandclosestate) {
            return;
        }
        this.closecode = code;
        this.closemessage = message;
        this.closedremotely = remote;
        this.flushandclosestate = true;
        this.wsl.onWriteDemand(this);
        try {
            this.wsl.onWebsocketClosing(this, code, message, remote);
        }
        catch (RuntimeException e) {
            this.wsl.onWebsocketError(this, e);
        }
        if (this.draft != null) {
            this.draft.reset();
        }
        this.handshakerequest = null;
    }

    public void eot() {
        if (this.getReadyState() == WebSocket.READYSTATE.NOT_YET_CONNECTED) {
            this.closeConnection(-1, true);
        } else if (this.flushandclosestate) {
            this.closeConnection(this.closecode, this.closemessage, this.closedremotely);
        } else if (this.draft.getCloseHandshakeType() == Draft.CloseHandshakeType.NONE) {
            this.closeConnection(1000, true);
        } else if (this.draft.getCloseHandshakeType() == Draft.CloseHandshakeType.ONEWAY) {
            if (this.role == WebSocket.Role.SERVER) {
                this.closeConnection(1006, true);
            } else {
                this.closeConnection(1000, true);
            }
        } else {
            this.closeConnection(1006, true);
        }
    }

    @Override
    public void close(int code) {
        this.close(code, "", false);
    }

    public void close(InvalidDataException e) {
        this.close(e.getCloseCode(), e.getMessage(), false);
    }

    @Override
    public void send(String text) throws WebsocketNotConnectedException {
        if (text == null) {
            throw new IllegalArgumentException("Cannot send 'null' data to a WebSocketImpl.");
        }
        if (this.draft == null) {
            try {
                this.channel.write(ByteBuffer.wrap(Charsetfunctions.utf8Bytes(text)));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            this.send(this.draft.createFrames(text, this.role == WebSocket.Role.CLIENT));
        }
    }

    @Override
    public void send(ByteBuffer bytes) throws IllegalArgumentException, WebsocketNotConnectedException {
        if (bytes == null) {
            throw new IllegalArgumentException("Cannot send 'null' data to a WebSocketImpl.");
        }
        if (this.draft == null) {
            try {
                int limit = bytes.limit();
                int written = 0;
                while (written < limit) {
                    written += this.channel.write(bytes);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            this.send(this.draft.createFrames(bytes, this.role == WebSocket.Role.CLIENT));
        }
    }

    @Override
    public void send(byte[] bytes) throws IllegalArgumentException, WebsocketNotConnectedException {
        this.send(ByteBuffer.wrap(bytes));
    }

    private void send(Collection<Framedata> frames) {
        if (!this.isOpen()) {
            throw new WebsocketNotConnectedException();
        }
        for (Framedata f : frames) {
            this.sendFrame(f);
        }
    }

    @Override
    public void sendFragmentedFrame(Framedata.Opcode op, ByteBuffer buffer, boolean fin) {
        this.send(this.draft.continuousFrame(op, buffer, fin));
    }

    @Override
    public void sendFrame(Framedata framedata) {
        if (DEBUG) {
            System.out.println("send frame: " + framedata);
        }
        this.write(this.draft.createBinaryFrame(framedata));
    }

    @Override
    public boolean hasBufferedData() {
        return !this.outQueue.isEmpty();
    }

    private Draft.HandshakeState isFlashEdgeCase(ByteBuffer request) throws IncompleteHandshakeException {
        request.mark();
        if (request.limit() > Draft.FLASH_POLICY_REQUEST.length) {
            return Draft.HandshakeState.NOT_MATCHED;
        }
        if (request.limit() < Draft.FLASH_POLICY_REQUEST.length) {
            throw new IncompleteHandshakeException(Draft.FLASH_POLICY_REQUEST.length);
        }
        int flash_policy_index = 0;
        while (request.hasRemaining()) {
            if (Draft.FLASH_POLICY_REQUEST[flash_policy_index] != request.get()) {
                request.reset();
                return Draft.HandshakeState.NOT_MATCHED;
            }
            ++flash_policy_index;
        }
        return Draft.HandshakeState.MATCHED;
    }

    public void startHandshake(ClientHandshakeBuilder handshakedata) throws InvalidHandshakeException {
        assert (this.readystate != WebSocket.READYSTATE.CONNECTING) : "shall only be called once";
        this.handshakerequest = this.draft.postProcessHandshakeRequestAsClient(handshakedata);
        this.resourceDescriptor = handshakedata.getResourceDescriptor();
        assert (this.resourceDescriptor != null);
        try {
            this.wsl.onWebsocketHandshakeSentAsClient(this, this.handshakerequest);
        }
        catch (InvalidDataException e) {
            throw new InvalidHandshakeException("Handshake data rejected by client.");
        }
        catch (RuntimeException e) {
            this.wsl.onWebsocketError(this, e);
            throw new InvalidHandshakeException("rejected because of" + e);
        }
        this.write(this.draft.createHandshake(this.handshakerequest, this.role));
    }

    private void write(ByteBuffer buf) {
        if (DEBUG) {
            System.out.println("write(" + buf.remaining() + "): {" + (buf.remaining() > 1000 ? "too big to display" : new String(buf.array())) + "}");
        }
        this.outQueue.add(buf);
        this.wsl.onWriteDemand(this);
    }

    private void write(List<ByteBuffer> bufs) {
        for (ByteBuffer b : bufs) {
            this.write(b);
        }
    }

    private void open(Handshakedata d) {
        if (DEBUG) {
            System.out.println("open using draft: " + this.draft.getClass().getSimpleName());
        }
        this.readystate = WebSocket.READYSTATE.OPEN;
        try {
            this.wsl.onWebsocketOpen(this, d);
        }
        catch (RuntimeException e) {
            this.wsl.onWebsocketError(this, e);
        }
    }

    @Override
    public boolean isConnecting() {
        assert (!this.flushandclosestate || this.readystate == WebSocket.READYSTATE.CONNECTING);
        return this.readystate == WebSocket.READYSTATE.CONNECTING;
    }

    @Override
    public boolean isOpen() {
        assert (this.readystate != WebSocket.READYSTATE.OPEN || !this.flushandclosestate);
        return this.readystate == WebSocket.READYSTATE.OPEN;
    }

    @Override
    public boolean isClosing() {
        return this.readystate == WebSocket.READYSTATE.CLOSING;
    }

    @Override
    public boolean isFlushAndClose() {
        return this.flushandclosestate;
    }

    @Override
    public boolean isClosed() {
        return this.readystate == WebSocket.READYSTATE.CLOSED;
    }

    @Override
    public WebSocket.READYSTATE getReadyState() {
        return this.readystate;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return super.toString();
    }

    @Override
    public InetSocketAddress getRemoteSocketAddress() {
        return this.wsl.getRemoteSocketAddress(this);
    }

    @Override
    public InetSocketAddress getLocalSocketAddress() {
        return this.wsl.getLocalSocketAddress(this);
    }

    @Override
    public Draft getDraft() {
        return this.draft;
    }

    @Override
    public void close() {
        this.close(1000);
    }

    @Override
    public String getResourceDescriptor() {
        return this.resourceDescriptor;
    }
}

