/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javacpp;

import com.googlecode.javacpp.Loader;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Scanner;
import java.util.TreeSet;

public class Parser {
    Properties properties = null;
    InfoMap infoMap = null;
    Token[] tokenArray = null;
    int tokenIndex = 0;

    public Parser(Properties properties, InfoMap infoMap) {
        this.properties = properties;
        this.infoMap = infoMap;
    }

    Token getToken() {
        return this.getToken(0);
    }

    Token getToken(int i) {
        return this.tokenIndex + i < this.tokenArray.length ? this.tokenArray[this.tokenIndex + i] : Token.EOF;
    }

    Token nextToken() {
        return this.nextToken(true);
    }

    Token nextToken(boolean skipComment) {
        ++this.tokenIndex;
        while (skipComment && this.getToken().match(4)) {
            ++this.tokenIndex;
        }
        return this.getToken();
    }

    TemplateMap template(TemplateMap defaults) throws Exception {
        if (!this.getToken().match(Token.TEMPLATE)) {
            return defaults;
        }
        TemplateMap map = new TemplateMap(defaults);
        this.nextToken().expect(Character.valueOf('<'));
        Token token = this.nextToken();
        while (!token.match(Token.EOF)) {
            if (token.match(Token.CLASS, Token.TYPENAME)) {
                map.put(this.nextToken().expect((Object[])new Object[]{Integer.valueOf((int)5)}).value, null);
            }
            if (this.nextToken().expect(Character.valueOf(','), Character.valueOf('>')).match(Character.valueOf('>'))) {
                this.nextToken();
                break;
            }
            token = this.nextToken();
        }
        return map;
    }

    Declarator declarator(TemplateMap typeMap, String defaultName, int infoNumber, int varNumber, boolean arrayAsPointer, boolean pointerAsArray) throws Exception {
        Parameters params;
        boolean isTypedef = this.getToken().match(Token.TYPEDEF);
        Declarator decl = new Declarator();
        String cppName = "";
        boolean simpleType = false;
        Token token = this.getToken();
        while (!token.match(Token.EOF) && token.match(5)) {
            if (token.match(Token.CONST)) {
                decl.constValue = true;
            } else if (!token.match(Token.TYPEDEF, Token.ENUM, Token.CLASS, Token.STRUCT, Token.UNION)) {
                if (token.match("signed", "unsigned", "char", "short", "int", "long", "bool", "float", "double")) {
                    cppName = !simpleType ? token.value + " " : cppName + token.value + " ";
                    simpleType = true;
                } else {
                    if (cppName.length() > 0 && !this.getToken(1).match(Character.valueOf('*'), Character.valueOf('&'), 5, Token.CONST)) break;
                    LinkedList<Info> infoList = this.infoMap.get(token.value);
                    if (infoList.size() > 0 && infoList.getFirst().annotations != null) {
                        for (String s : infoList.getFirst().annotations) {
                            decl.annotations = decl.annotations + s + " ";
                        }
                    } else {
                        cppName = token.value;
                    }
                }
            }
            token = this.nextToken();
        }
        cppName = cppName.trim();
        if (typeMap != null && typeMap.containsKey(cppName)) {
            cppName = typeMap.get(cppName);
        }
        decl.cppType = decl.javaType = cppName;
        if ("...".equals(this.getToken().value)) {
            this.nextToken();
            return null;
        }
        int count = 0;
        Token token2 = this.getToken();
        while (varNumber > 0 && !token2.match(Token.EOF)) {
            if (token2.match(Character.valueOf('('))) {
                ++count;
            } else if (token2.match(Character.valueOf(')'))) {
                --count;
            } else if (count == 0) {
                if (token2.match(Character.valueOf(','))) {
                    --varNumber;
                } else if (token2.match(Character.valueOf(';'))) {
                    this.nextToken();
                    return null;
                }
            }
            token2 = this.nextToken();
        }
        String cast = cppName;
        int indirections = 0;
        boolean reference = false;
        Token token3 = this.getToken();
        while (!token3.match(Token.EOF)) {
            if (token3.match(Character.valueOf('*'))) {
                ++indirections;
            } else if (token3.match(Character.valueOf('&'))) {
                reference = true;
            } else {
                if (!token3.match(Token.CONST)) break;
                decl.constPointer = true;
            }
            cast = cast + token3.toString();
            token3 = this.nextToken();
        }
        int indirections2 = 0;
        decl.objectName = defaultName;
        if (this.getToken().match(Character.valueOf('('))) {
            while (this.getToken().match(Character.valueOf('('))) {
                this.nextToken();
            }
            Token token4 = this.getToken();
            while (!token4.match(Token.EOF)) {
                if (token4.match(5)) {
                    decl.objectName = token4.value;
                } else if (token4.match(Character.valueOf('*'))) {
                    ++indirections2;
                    decl.convention = decl.objectName;
                    decl.objectName = defaultName;
                } else if (token4.match(Character.valueOf('['))) {
                    ++decl.indices;
                } else if (token4.match(Character.valueOf(')'))) {
                    this.nextToken();
                    break;
                }
                token4 = this.nextToken();
            }
            while (this.getToken().match(Character.valueOf(')'))) {
                this.nextToken();
            }
        } else if (this.getToken().match(5)) {
            decl.objectName = this.getToken().value;
            this.nextToken();
        }
        boolean bracket = false;
        Token token5 = this.getToken();
        while (!token5.match(Token.EOF)) {
            if (!bracket && token5.match(Character.valueOf('['))) {
                bracket = true;
                ++decl.indices;
            } else {
                if (!bracket) break;
                if (bracket && token5.match(Character.valueOf(']'))) {
                    bracket = false;
                }
            }
            token5 = this.nextToken();
        }
        while (decl.indices > 0 && indirections2 > 0) {
            ++decl.indices;
            --indirections2;
        }
        if (arrayAsPointer && decl.indices > 0) {
            ++indirections;
            cast = cast + "*";
        }
        if (pointerAsArray && indirections > 1) {
            ++decl.indices;
            --indirections;
            cast = cast.substring(0, cast.length() - 1);
        }
        if (this.getToken().match(Character.valueOf(':'))) {
            decl.annotations = decl.annotations + "@NoOffset ";
            this.nextToken().expect(1);
            this.nextToken().expect(Character.valueOf(','), Character.valueOf(';'));
        }
        int infoLength = 1;
        boolean primitive = false;
        boolean needCast = false;
        boolean implicitConst = false;
        String key = decl.constValue && indirections < 2 && !reference ? "const " + decl.cppType : decl.cppType;
        LinkedList<Info> infoList = this.infoMap.get(key);
        if (infoList.size() > 0) {
            Info info = infoList.getFirst();
            primitive = info.primitiveTypes != null && indirections == 0 && !reference;
            needCast = info.cast;
            implicitConst = info.cppNames[0].startsWith("const ");
            infoLength = primitive ? info.primitiveTypes.length : (info.pointerTypes != null ? info.pointerTypes.length : 1);
            int n = decl.infoNumber = infoNumber < 0 ? 0 : infoNumber % infoLength;
            String string = primitive ? info.primitiveTypes[decl.infoNumber] : (decl.javaType = info.pointerTypes != null ? info.pointerTypes[decl.infoNumber] : decl.cppType);
        }
        if (!primitive) {
            if (indirections == 0 && !reference) {
                decl.annotations = decl.annotations + "@ByVal ";
            } else if (indirections == 0 && reference) {
                decl.annotations = decl.annotations + "@ByRef ";
            } else if (indirections == 1 && reference) {
                decl.annotations = decl.annotations + "@ByPtrRef ";
            } else if (indirections == 2 && !reference && infoNumber >= 0) {
                decl.annotations = decl.annotations + "@ByPtrPtr ";
                if (decl.cppType.equals("void")) {
                    needCast = true;
                }
            } else if (indirections >= 2) {
                decl.infoNumber += infoLength;
                needCast = true;
                decl.javaType = "PointerPointer";
                if (reference) {
                    decl.annotations = decl.annotations + "@ByRef ";
                }
            }
            if (!needCast && decl.constValue && !implicitConst) {
                decl.annotations = "@Const " + decl.annotations;
            }
        }
        if (needCast || arrayAsPointer && decl.indices > 1) {
            if (decl.constValue) {
                cast = "const " + cast;
            }
            decl.annotations = !primitive && indirections == 0 && !reference ? decl.annotations + "@Cast(\"" + cast + "*\") " : "@Cast(\"" + cast + "\") " + decl.annotations;
        }
        if ((params = this.parameters(typeMap, infoNumber)) != null) {
            decl.infoNumber = Math.max(decl.infoNumber, params.infoNumber);
            if (params.definitions.length() > 0) {
                decl.definitions = decl.definitions + params.definitions + "\n";
            }
            if (indirections2 == 0) {
                decl.parameters = params.list;
            } else {
                String functionType;
                String string = functionType = isTypedef ? decl.objectName : Character.toUpperCase(decl.objectName.charAt(0)) + decl.objectName.substring(1) + params.signature;
                if (infoNumber <= params.infoNumber) {
                    decl.definitions = decl.definitions + "public static class " + functionType + " extends FunctionPointer {\n" + "    static { Loader.load(); }\n" + "    public    " + functionType + "(Pointer p) { super(p); }\n" + "    protected " + functionType + "() { allocate(); }\n" + "    private native void allocate();\n" + "    public native " + decl.annotations + decl.javaType + " call" + params.list + ";\n" + "}\n";
                }
                decl.annotations = "";
                decl.javaType = functionType;
                decl.parameters = "";
            }
        }
        if ((infoList = this.infoMap.get(decl.objectName)).size() > 0) {
            Info info = infoList.getFirst();
            if (info.javaNames != null && info.javaNames.length > 0) {
                decl.annotations = decl.annotations + "@Name(\"" + decl.objectName + "\") ";
                decl.objectName = info.javaNames[0];
            }
        }
        return decl;
    }

    String commentBefore() throws Exception {
        String comment = "";
        while (this.tokenIndex > 0 && this.getToken(-1).match(4)) {
            --this.tokenIndex;
        }
        Token token = this.getToken();
        while (token.match(4)) {
            if (token.value.length() <= 3 || token.value.charAt(3) != '<') {
                comment = comment + token.spacing + token.value;
            }
            token = this.nextToken(false);
        }
        return comment;
    }

    String commentAfter() throws Exception {
        String comment = "";
        while (this.tokenIndex > 0 && this.getToken(-1).match(4)) {
            --this.tokenIndex;
        }
        Token token = this.getToken();
        while (token.match(4)) {
            if (token.value.length() > 3 && token.value.charAt(3) == '<') {
                String value = token.value;
                comment = comment + (comment.length() > 0 ? " * " : "/**") + value.substring(4);
            }
            token = this.nextToken(false);
        }
        if (comment.length() > 0 && !comment.endsWith("*/")) {
            comment = comment + " */";
        }
        return comment;
    }

    boolean attribute() throws Exception {
        if (!this.getToken().match(5)) {
            return false;
        }
        if (!this.nextToken().match(Character.valueOf('('))) {
            return true;
        }
        int count = 1;
        Token token = this.nextToken();
        while (!token.match(Token.EOF) && count > 0) {
            if (token.match(Character.valueOf('('))) {
                ++count;
            } else if (token.match(Character.valueOf(')'))) {
                --count;
            }
            token = this.nextToken(false);
        }
        return true;
    }

    boolean body() throws Exception {
        if (!this.getToken().match(Character.valueOf('{'))) {
            return false;
        }
        int count = 1;
        Token token = this.nextToken();
        while (!token.match(Token.EOF) && count > 0) {
            if (token.match(Character.valueOf('{'))) {
                ++count;
            } else if (token.match(Character.valueOf('}'))) {
                --count;
            }
            token = this.nextToken(false);
        }
        return true;
    }

    Parameters parameters(TemplateMap templateMap, int infoNumber) throws Exception {
        if (!this.getToken().match(Character.valueOf('('))) {
            return null;
        }
        int count = 0;
        Parameters params = new Parameters();
        params.list = "(";
        Token token = this.nextToken();
        while (!token.match(Token.EOF)) {
            String spacing = token.spacing;
            if (token.match(Character.valueOf(')'))) {
                params.list = params.list + spacing + ")";
                this.nextToken();
                break;
            }
            Declarator decl = this.declarator(templateMap, "arg" + count++, infoNumber, 0, true, false);
            if (decl != null && !decl.javaType.equals("void")) {
                params.infoNumber = Math.max(params.infoNumber, decl.infoNumber);
                params.list = params.list + (count > 1 ? "," : "") + spacing + decl.annotations + decl.javaType + " " + decl.objectName;
                params.definitions = params.definitions + decl.definitions;
                params.signature = params.signature + '_';
                for (char c : decl.javaType.substring(decl.javaType.lastIndexOf(32) + 1).toCharArray()) {
                    if (!Character.isDigit(c) && !Character.isLetter(c) && c != '_') continue;
                    params.signature = params.signature + c;
                }
                if (decl.objectName.startsWith("arg")) {
                    try {
                        count = Integer.parseInt(decl.objectName.substring(3)) + 1;
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
            }
            if (this.getToken().expect(Character.valueOf(','), Character.valueOf(')')).match(Character.valueOf(','))) {
                this.nextToken();
            }
            token = this.getToken();
        }
        return params;
    }

    String function(String group, TemplateMap templateMap) throws Exception {
        int backIndex = this.tokenIndex;
        String spacing = this.getToken().spacing;
        String access = group == null || group.length() == 0 ? "public static native " : "public native ";
        Token token = this.getToken();
        while (!token.match(Token.EOF)) {
            if (token.match(Token.STATIC)) {
                access = "public static native ";
            } else if (!token.match(Token.INLINE)) break;
            token = this.nextToken();
        }
        int startIndex = this.tokenIndex;
        Declarator decl = this.declarator(templateMap, null, 0, 0, false, false);
        String name = decl.objectName;
        if (name == null || decl.parameters.length() == 0) {
            this.tokenIndex = backIndex;
            return null;
        }
        String text = "";
        String statements = "";
        String definitions = "";
        LinkedList<Info> infoList = this.infoMap.get(name);
        if (infoList.size() == 0) {
            infoList.add(null);
        }
        for (Info info : infoList) {
            if (info != null) {
                if (info.genericTypes != null && templateMap != null) {
                    int count = 0;
                    for (String key : templateMap.keySet()) {
                        if (count >= info.genericTypes.length) continue;
                        templateMap.put(key, info.genericTypes[count++]);
                    }
                }
                String string = info.javaNames == null ? info.cppNames[0] : (name = info.javaNames.length == 0 ? "" : info.javaNames[0]);
                if (!name.equals(info.cppNames[0]) && name.length() > 0) {
                    name = "@Name(\"" + info.cppNames[0] + "\") " + name;
                }
            }
            LinkedList<Declarator> prevDecl = new LinkedList<Declarator>();
            for (int n = -1; n < Integer.MAX_VALUE; ++n) {
                this.tokenIndex = startIndex;
                decl = this.declarator(templateMap, null, n, 0, false, false);
                boolean found = false;
                for (Declarator d : prevDecl) {
                    found |= decl.parameters.equals(d.parameters);
                }
                if (found && n > 0) break;
                if (name.length() > 0 && !found) {
                    statements = statements + access + decl.annotations + decl.javaType + " " + name + decl.parameters + ";\n";
                    definitions = definitions + decl.definitions;
                }
                prevDecl.add(decl);
            }
            while (this.attribute()) {
            }
            if (this.getToken().match(Character.valueOf('{'))) {
                this.body();
                continue;
            }
            this.nextToken();
        }
        String comment = this.commentAfter();
        if (comment.length() > 0) {
            statements = comment + "\n" + statements;
        }
        Scanner scanner = new Scanner(definitions);
        while (scanner.hasNextLine()) {
            text = text + spacing + scanner.nextLine();
            int newline = spacing.lastIndexOf(10);
            if (newline <= 0) continue;
            spacing = spacing.substring(newline);
        }
        scanner = new Scanner(statements);
        while (scanner.hasNextLine()) {
            text = text + spacing + scanner.nextLine();
            int newline = spacing.lastIndexOf(10);
            if (newline <= 0) continue;
            spacing = spacing.substring(newline);
        }
        return text;
    }

    String variable(String group) throws Exception {
        String comment;
        int backIndex = this.tokenIndex;
        String spacing = this.getToken().spacing;
        Declarator decl = this.declarator(null, null, 0, 0, false, true);
        String name = decl.objectName;
        if (name == null || !this.getToken().match(Character.valueOf('['), Character.valueOf('='), Character.valueOf(','), Character.valueOf(':'), Character.valueOf(';'))) {
            this.tokenIndex = backIndex;
            return null;
        }
        String text = "";
        String statements = "";
        String definitions = "";
        for (int n = 0; n < Integer.MAX_VALUE; ++n) {
            this.tokenIndex = backIndex;
            decl = this.declarator(null, null, -1, n, false, true);
            if (decl == null) break;
            String access = group == null || group.length() == 0 ? "public static native " : "public native ";
            String setterType = group == null || group.length() == 0 ? "void " : group + " ";
            name = decl.objectName;
            String indices = "";
            for (int i = 0; i < decl.indices; ++i) {
                if (i > 0) {
                    indices = indices + ", ";
                }
                indices = indices + "int " + (char)(105 + i);
            }
            if (decl.constValue) {
                statements = statements + "@MemberGetter ";
            }
            statements = statements + access + decl.annotations + decl.javaType + " " + name + "(" + indices + ");";
            if (!decl.constValue) {
                if (decl.indices > 0) {
                    indices = indices + ", ";
                }
                statements = statements + " " + access + setterType + name + "(" + indices + decl.javaType + " " + name + ");";
            }
            statements = statements + "\n";
            definitions = definitions + decl.definitions;
            if (decl.indices <= 0) continue;
            this.tokenIndex = backIndex;
            decl = this.declarator(null, null, -1, n, true, false);
            statements = statements + "@MemberGetter " + access + decl.annotations + decl.javaType + " " + name + "();\n";
        }
        if ((comment = this.commentAfter()).length() > 0) {
            statements = comment + "\n" + statements;
        }
        Scanner scanner = new Scanner(definitions);
        while (scanner.hasNextLine()) {
            text = text + spacing + scanner.nextLine();
            int newline = spacing.lastIndexOf(10);
            if (newline <= 0) continue;
            spacing = spacing.substring(newline);
        }
        scanner = new Scanner(statements);
        while (scanner.hasNextLine()) {
            text = text + spacing + scanner.nextLine();
            int newline = spacing.lastIndexOf(10);
            if (newline <= 0) continue;
            spacing = spacing.substring(newline);
        }
        return text;
    }

    String macro() throws Exception {
        String text;
        block36: {
            int endIndex;
            int beginIndex;
            Token keyword;
            String spacing;
            block37: {
                block35: {
                    if (!this.getToken().match(Character.valueOf('#'))) {
                        return null;
                    }
                    spacing = this.getToken().spacing;
                    keyword = this.nextToken();
                    this.nextToken();
                    beginIndex = this.tokenIndex;
                    Token token = this.getToken();
                    while (!token.match(Token.EOF) && !token.match(4) && token.spacing.indexOf(10) < 0) {
                        token = this.nextToken(false);
                    }
                    endIndex = this.tokenIndex;
                    text = "";
                    if (!keyword.match(Token.DEFINE) || beginIndex + 1 >= endIndex) break block35;
                    this.tokenIndex = beginIndex;
                    String name = this.getToken().value;
                    Token first = this.nextToken();
                    String statements = "";
                    LinkedList<Info> infoList = this.infoMap.get(name);
                    if (first.spacing.length() == 0 && first.match(Character.valueOf('('))) {
                        for (Info info : infoList) {
                            if (info.genericTypes == null || info.genericTypes.length == 0) continue;
                            int count = 1;
                            this.tokenIndex = beginIndex + 2;
                            String type = "";
                            String params = "(";
                            Token token2 = this.getToken();
                            while (this.tokenIndex < endIndex && count < info.genericTypes.length) {
                                if (token2.match(5)) {
                                    type = info.genericTypes[count];
                                    name = token2.value;
                                    if (name.equals("...")) {
                                        name = "arg" + count;
                                    }
                                    params = params + type + " " + name;
                                    if (++count < info.genericTypes.length) {
                                        params = params + ", ";
                                    }
                                } else if (token2.match(Character.valueOf(')'))) break;
                                token2 = this.nextToken();
                            }
                            while (count < info.genericTypes.length) {
                                type = info.genericTypes[count];
                                name = "arg" + count;
                                params = params + type + " " + name;
                                if (++count >= info.genericTypes.length) continue;
                                params = params + ", ";
                            }
                            params = params + ")";
                            type = info.genericTypes[0];
                            String string = name = info.javaNames == null ? info.cppNames[0] : info.javaNames[0];
                            if (!name.equals(info.cppNames[0])) {
                                name = "@Name(\"" + info.cppNames[0] + "\") " + name;
                            }
                            statements = statements + "public static native " + type + " " + name + params + ";\n";
                        }
                    } else if (infoList.size() == 0 || infoList.getFirst().genericTypes == null || infoList.getFirst().genericTypes.length > 0) {
                        String value = "";
                        String type = "int";
                        String cat = "";
                        this.tokenIndex = beginIndex + 1;
                        Token prevToken = new Token();
                        boolean complex = false;
                        Token token3 = this.getToken();
                        while (this.tokenIndex < endIndex) {
                            if (token3.match(3)) {
                                type = "String";
                                cat = " + ";
                                break;
                            }
                            if (token3.match(2)) {
                                type = "double";
                                cat = "";
                                break;
                            }
                            if (token3.match(1) && token3.value.endsWith("L")) {
                                type = "long";
                                cat = "";
                                break;
                            }
                            if (prevToken.match(5) && token3.match(Character.valueOf('(')) || token3.match(Character.valueOf('{'), Character.valueOf('}'))) {
                                complex = true;
                            }
                            prevToken = token3;
                            token3 = this.nextToken();
                        }
                        if (infoList.size() > 0) {
                            Info info = infoList.getFirst();
                            if (info.genericTypes != null) {
                                type = info.genericTypes[0];
                            }
                            name = info.cppNames[0];
                            if (info.javaNames != null) {
                                name = info.javaNames[0];
                            }
                            if (info.complex) {
                                complex = true;
                            }
                        }
                        this.tokenIndex = beginIndex + 1;
                        if (complex) {
                            statements = statements + "public static native @MemberGetter " + type + " " + name + "();\n";
                            value = " " + name + "()";
                        } else {
                            token3 = this.getToken();
                            while (this.tokenIndex < endIndex) {
                                value = value + token3.spacing + token3 + (this.tokenIndex < endIndex ? cat : "");
                                token3 = this.nextToken();
                            }
                        }
                        int i = type.lastIndexOf(32);
                        if (i > 0) {
                            type = type.substring(i + 1);
                        }
                        statements = statements + "public static final " + type + " " + name + " =" + value + ";\n";
                    }
                    this.tokenIndex = endIndex;
                    String comment = this.commentAfter();
                    if (comment.length() > 0) {
                        statements = comment + "\n" + statements;
                    }
                    Scanner scanner = new Scanner(statements);
                    while (scanner.hasNextLine()) {
                        text = text + spacing + scanner.nextLine();
                        int newline = spacing.lastIndexOf(10);
                        if (newline <= 0) continue;
                        spacing = spacing.substring(newline);
                    }
                    break block36;
                }
                if (!keyword.match(Token.IF, Token.IFDEF, Token.IFNDEF, Token.ELIF) || beginIndex >= endIndex) break block37;
                this.tokenIndex = beginIndex;
                String value = "";
                Token token = this.getToken();
                while (this.tokenIndex < endIndex) {
                    value = value + token.spacing + token;
                    token = this.nextToken();
                }
                text = spacing + "// #" + keyword + value;
                LinkedList<Info> infoList = this.infoMap.get(value);
                boolean define = true;
                if (infoList.size() > 0) {
                    Info info = infoList.getFirst();
                    boolean bl = keyword.match(Token.IFNDEF) ? !info.define : (define = info.define);
                }
                if (define) break block36;
                int count = 1;
                Token prevToken = new Token();
                Token token4 = this.getToken();
                while (!token4.match(Token.EOF) && count > 0) {
                    if (prevToken.match(Character.valueOf('#')) && token4.match(Token.IF, Token.IFDEF, Token.IFNDEF)) {
                        ++count;
                    } else if (prevToken.match(Character.valueOf('#')) && token4.match(Token.ELIF, Token.ELSE, Token.ENDIF)) {
                        --count;
                    }
                    prevToken = token4;
                    token4 = this.nextToken(false);
                }
                this.tokenIndex -= 2;
                break block36;
            }
            this.tokenIndex = beginIndex;
            text = spacing + "// #" + keyword;
            Token token = this.getToken();
            while (this.tokenIndex < endIndex) {
                text = text + token.spacing + token;
                token = this.nextToken();
            }
        }
        return text;
    }

    String typedef() throws Exception {
        if (!this.getToken().match(Token.TYPEDEF)) {
            return null;
        }
        String spacing = this.getToken().spacing;
        Declarator decl = this.declarator(null, null, 0, 0, false, false);
        this.nextToken();
        LinkedList<Info> infoList = this.infoMap.get(decl.cppType);
        Info info = infoList.size() > 0 ? infoList.getFirst().clone() : new Info();
        this.infoMap.put(info.cppNames(decl.objectName).cast(true));
        String text = "";
        String comment = this.commentAfter();
        if (comment.length() > 0) {
            text = comment + "\n" + text;
        }
        Scanner scanner = new Scanner(decl.definitions);
        while (scanner.hasNextLine()) {
            text = text + spacing + scanner.nextLine();
            int newline = spacing.lastIndexOf(10);
            if (newline <= 0) continue;
            spacing = spacing.substring(newline);
        }
        return text;
    }

    String group(TemplateMap templateMap) throws Exception {
        int backIndex = this.tokenIndex;
        String spacing = this.getToken().spacing;
        boolean isTypedef = this.getToken().match(Token.TYPEDEF);
        boolean foundGroup = false;
        boolean doOutput = true;
        Token token = this.getToken();
        while (!token.match(Token.EOF)) {
            if (token.match(Token.CLASS, Token.STRUCT, Token.UNION)) {
                foundGroup = true;
                break;
            }
            if (token.match(Token.EXTERN) && this.nextToken().match(3)) {
                foundGroup = true;
                doOutput = false;
                break;
            }
            if (!token.match(5)) break;
            token = this.nextToken();
        }
        if (!foundGroup) {
            this.tokenIndex = backIndex;
            return null;
        }
        if (isTypedef && !this.getToken(1).match(Character.valueOf('{')) && this.getToken(2).match(5)) {
            this.nextToken();
        }
        String text = "";
        String name = this.nextToken().expect((Object[])new Object[]{Integer.valueOf((int)3), Integer.valueOf((int)5), Character.valueOf((char)'{')}).value;
        if (!this.getToken(0).match(Character.valueOf('{'), Character.valueOf(';')) && !this.getToken(1).match(Character.valueOf('{'), Character.valueOf(';'))) {
            this.tokenIndex = backIndex;
            return null;
        }
        if (doOutput) {
            LinkedList<Info> infoList = this.infoMap.get(name);
            if (this.getToken().match(5) && this.nextToken().match(Character.valueOf(';'))) {
                this.nextToken();
                if (infoList.size() == 0 || !infoList.getFirst().forwardDeclared) {
                    this.infoMap.put(new Info(name).forwardDeclared(true));
                    return spacing + "@Opaque public static class " + name + " extends Pointer {\n" + "    public " + name + "() { }\n" + "    public " + name + "(Pointer p) { super(p); }\n" + "}";
                }
                return "";
            }
            int index = this.tokenIndex;
            if (this.body() && isTypedef && this.getToken().match(5)) {
                name = this.getToken().value;
                infoList = this.infoMap.get(name);
            }
            if (name.length() == 0) {
                Token token2 = this.nextToken();
                while (!token2.match(Token.EOF)) {
                    if (token2.match(Character.valueOf(';'))) {
                        this.nextToken();
                        break;
                    }
                    token2 = this.nextToken();
                }
                return "";
            }
            this.tokenIndex = index;
            text = text + spacing + "public static class " + name + " extends Pointer {\n" + "    static { Loader.load(); }\n" + "    public " + name + "() { allocate(); }\n" + "    public " + name + "(int size) { allocateArray(size); }\n" + "    public " + name + "(Pointer p) { super(p); }\n" + "    private native void allocate();\n" + "    private native void allocateArray(int size);\n" + "    @Override public " + name + " position(int position) {\n" + "        return (" + name + ")super.position(position);\n" + "    }\n";
        }
        if (this.getToken().match(Character.valueOf('{'))) {
            this.nextToken();
        }
        while (!this.getToken().match(Token.EOF, Character.valueOf('}'))) {
            text = text + this.declaration(name, templateMap);
        }
        if (doOutput) {
            text = text + this.getToken().spacing + '}';
            Token token3 = this.nextToken();
            if (token3.match(5)) {
                token3 = this.nextToken();
            }
            text = text + token3.expect((Object[])new Object[]{Character.valueOf((char)';')}).spacing;
        }
        this.nextToken();
        return text;
    }

    String enumeration() throws Exception {
        int backIndex = this.tokenIndex;
        String enumSpacing = this.getToken().spacing;
        boolean isTypedef = this.getToken().match(Token.TYPEDEF);
        boolean foundEnum = false;
        Token token = this.getToken();
        while (!token.match(Token.EOF)) {
            if (token.match(Token.ENUM)) {
                foundEnum = true;
                break;
            }
            if (!token.match(5)) break;
            token = this.nextToken();
        }
        if (!foundEnum) {
            this.tokenIndex = backIndex;
            return null;
        }
        if (isTypedef && !this.getToken(1).match(Character.valueOf('{')) && this.getToken(2).match(5)) {
            this.nextToken();
        }
        boolean first = true;
        int count = 0;
        String countPrefix = " ";
        String enumerators = "";
        String macroText = "";
        String name = this.nextToken().expect((Object[])new Object[]{Integer.valueOf((int)5), Character.valueOf((char)'{')}).value;
        if (!this.getToken().match(Character.valueOf('{')) && !this.nextToken().match(Character.valueOf('{'))) {
            this.tokenIndex = backIndex;
            return null;
        }
        Token token2 = this.nextToken();
        while (!token2.match(Token.EOF, Character.valueOf('}'))) {
            String s = this.macro();
            if (s != null) {
                macroText = macroText + s;
            } else {
                String separator;
                String spacing2;
                Token enumerator;
                String comment;
                block25: {
                    comment = this.commentBefore();
                    enumerator = this.getToken();
                    spacing2 = " ";
                    String string = separator = first ? "" : ",";
                    if (this.nextToken().match(Character.valueOf('='))) {
                        spacing2 = this.getToken().spacing;
                        countPrefix = " ";
                        int count2 = 0;
                        Token prevToken = new Token();
                        boolean complex = false;
                        token2 = this.nextToken();
                        while (!token2.match(Token.EOF, Character.valueOf(','), Character.valueOf('}')) || count2 > 0) {
                            countPrefix = countPrefix + token2.spacing + token2;
                            if (token2.match(Character.valueOf('('))) {
                                ++count2;
                            } else if (token2.match(Character.valueOf(')'))) {
                                --count2;
                            }
                            if (prevToken.match(5) && token2.match(Character.valueOf('('))) {
                                complex = true;
                            }
                            prevToken = token2;
                            token2 = this.nextToken();
                        }
                        try {
                            count = Integer.parseInt(countPrefix.trim());
                            countPrefix = " ";
                        }
                        catch (NumberFormatException e) {
                            count = 0;
                            if (!complex) break block25;
                            if (!first) {
                                separator = ";\n";
                                first = true;
                            }
                            separator = separator + "public static native @MemberGetter int " + enumerator.value + "();\npublic static final int";
                            countPrefix = " " + enumerator.value + "()";
                        }
                    }
                }
                first = false;
                enumerators = enumerators + separator + macroText + comment;
                macroText = "";
                comment = this.commentAfter();
                if (comment.length() == 0 && this.getToken().match(Character.valueOf(','))) {
                    this.nextToken();
                    comment = this.commentAfter();
                }
                String spacing = enumerator.spacing;
                if (comment.length() > 0) {
                    enumerators = enumerators + spacing + comment;
                    int newline = spacing.lastIndexOf(10);
                    if (newline > 0) {
                        spacing = spacing.substring(newline);
                    }
                }
                enumerators = enumerators + spacing + enumerator.value + spacing2 + "=" + countPrefix;
                if (countPrefix.trim().length() > 0) {
                    if (count > 0) {
                        enumerators = enumerators + " + " + count;
                    }
                } else {
                    enumerators = enumerators + count;
                }
                ++count;
            }
            token2 = this.getToken();
        }
        String comment = this.commentBefore();
        String text = "";
        Token token3 = this.nextToken();
        if (token3.match(5)) {
            name = token3.value;
            token3 = this.nextToken();
        }
        text = text + enumSpacing + "/** enum " + name + " */\n";
        int newline = enumSpacing.lastIndexOf(10);
        if (newline >= 0) {
            enumSpacing = enumSpacing.substring(newline + 1);
        }
        text = text + enumSpacing + "public static final int" + enumerators + token3.expect((Object[])new Object[]{Character.valueOf((char)';')}).spacing + ";";
        this.infoMap.put(new Info(name).primitiveTypes("int").pointerTypes("IntPointer", "IntBuffer", "int[]").cast(true));
        this.nextToken();
        return text + macroText + comment;
    }

    String declaration(String group, TemplateMap templateMap) throws Exception {
        String text;
        String comment = this.commentBefore();
        Token token = this.getToken();
        String spacing = token.spacing;
        TemplateMap map = this.template(templateMap);
        if (map != templateMap) {
            comment = comment + spacing.substring(0, spacing.lastIndexOf(10));
        }
        if ((text = this.macro()) != null) {
            return comment + text;
        }
        text = this.enumeration();
        if (text != null) {
            return comment + text;
        }
        text = this.group(map);
        if (text != null) {
            return comment + text;
        }
        text = this.typedef();
        if (text != null) {
            return comment + text;
        }
        text = this.function(group, map);
        if (text != null) {
            return comment + text;
        }
        text = this.variable(group);
        if (text != null) {
            return comment + text;
        }
        if (this.attribute()) {
            return comment + spacing;
        }
        throw new Exception(token.file + ":" + token.lineNumber + ": Could not parse declaration at '" + token + "'");
    }

    public void parse(String outputFilename, String ... inputFilenames) throws IOException, Exception {
        File[] files = new File[inputFilenames.length];
        for (int i = 0; i < files.length; ++i) {
            files[i] = new File(inputFilenames[i]);
        }
        this.parse(new File(outputFilename), files);
    }

    public void parse(File outputFile, File ... inputFiles) throws IOException, Exception {
        ArrayList<Token> tokens = new ArrayList<Token>();
        String lineSeparator = "\n";
        for (File file : inputFiles) {
            System.out.println("Parsing header file: " + file);
            Token token = new Token();
            token.type = 4;
            token.value = "\n/* Wrapper for header file " + file + " */\n\n";
            tokens.add(token);
            Tokenizer tokenizer = new Tokenizer(file);
            while (!(token = tokenizer.nextToken()).isEmpty()) {
                if (token.type == -1) {
                    token.type = 4;
                }
                tokens.add(token);
            }
            if (lineSeparator == null) {
                lineSeparator = tokenizer.lineSeparator;
            }
            tokenizer.close();
            token = new Token();
            token.type = 4;
            token.spacing = "\n";
            tokens.add(token);
        }
        this.tokenArray = tokens.toArray(new Token[tokens.size()]);
        this.tokenIndex = 0;
        Writer out = outputFile != null ? new FileWriter(outputFile) : new Writer(){

            public void write(char[] cbuf, int off, int len) {
            }

            public void flush() {
            }

            public void close() {
            }
        };
        LinkedList<Info> infoList = this.infoMap.get(null);
        for (Info info : infoList) {
            if (info.textBefore == null) continue;
            out.append(info.textBefore.replaceAll("\n", lineSeparator));
        }
        out.append("{" + lineSeparator);
        out.append("    static { Loader.load(); }" + lineSeparator);
        for (Info info : infoList) {
            if (info.textAfter == null) continue;
            out.append(info.textAfter.replaceAll("\n", lineSeparator));
        }
        while (!this.getToken().match(Token.EOF)) {
            out.append(this.declaration(null, null).replaceAll("\n", lineSeparator));
        }
        String comment = this.commentBefore();
        if (comment != null) {
            out.append(comment.replaceAll("\n", lineSeparator));
        }
        out.append(lineSeparator + "}" + lineSeparator);
        out.close();
    }

    public File parse(String outputDirectory, Class cls) throws IOException, Exception {
        return this.parse(new File(outputDirectory), cls);
    }

    public File parse(File outputDirectory, Class cls) throws IOException, Exception {
        Loader.ClassProperties allProperties = Loader.loadProperties(cls, this.properties, true);
        Loader.ClassProperties clsProperties = Loader.loadProperties(cls, this.properties, false);
        LinkedList<File> allFiles = allProperties.getHeaderFiles();
        LinkedList<File> clsFiles = clsProperties.getHeaderFiles();
        LinkedList<String> allTargets = allProperties.get("parser.target");
        LinkedList<String> clsTargets = clsProperties.get("parser.target");
        String target = clsTargets.getFirst();
        String text = "/* DO NOT EDIT THIS FILE - IT IS MACHINE GENERATED */\n\n";
        int n = target.lastIndexOf(46);
        if (n > 0) {
            text = text + "package " + target.substring(0, n) + ";\n\n";
        }
        text = text + "import com.googlecode.javacpp.*;\nimport com.googlecode.javacpp.annotation.*;\nimport java.nio.*;\n\n";
        for (String s : allTargets) {
            if (target.equals(s)) continue;
            text = text + "import static " + s + ".*;\n";
        }
        if (allTargets.size() > 1) {
            text = text + "\n";
        }
        text = text + "public class " + target.substring(n + 1) + " extends " + cls.getCanonicalName() + " ";
        this.infoMap.put(new Info().textBefore(text));
        File targetFile = new File(outputDirectory, target.replace('.', '/') + ".java");
        System.out.println("Targeting file: " + targetFile);
        for (File f : allFiles) {
            if (clsFiles.contains(f)) continue;
            this.parse(null, f);
        }
        this.parse(targetFile, clsFiles.toArray(new File[clsFiles.size()]));
        return targetFile;
    }

    static class Parameters {
        int infoNumber = 0;
        String list = "";
        String definitions = "";
        String signature = "";

        Parameters() {
        }
    }

    static class Declarator {
        int infoNumber = 0;
        int indices = 0;
        boolean constValue = false;
        boolean constPointer = false;
        String annotations = "";
        String cppType = "";
        String javaType = "";
        String objectName = "";
        String convention = "";
        String definitions = "";
        String parameters = "";

        Declarator() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TemplateMap
    extends LinkedHashMap<String, String> {
        LinkedHashMap<String, String> defaults = null;

        TemplateMap(TemplateMap defaults) {
            this.defaults = defaults;
        }

        String get(String key) {
            String value = (String)super.get(key);
            if (value == null && this.defaults != null) {
                return this.defaults.get(key);
            }
            return value;
        }
    }

    static class Tokenizer
    implements Closeable {
        File file = null;
        Reader reader = null;
        String lineSeparator = null;
        int lastChar = -1;
        int lineNumber = 1;
        StringBuilder buffer = new StringBuilder();

        Tokenizer(Reader reader) {
            this.reader = reader;
        }

        Tokenizer(File file) throws FileNotFoundException {
            this.file = file;
            this.reader = new BufferedReader(new FileReader(file));
        }

        public void close() throws IOException {
            this.reader.close();
        }

        int readChar() throws IOException {
            if (this.lastChar != -1) {
                int c = this.lastChar;
                this.lastChar = -1;
                return c;
            }
            int c = this.reader.read();
            if (c == 13 || c == 10) {
                int c2;
                ++this.lineNumber;
                int n = c2 = c == 13 ? this.reader.read() : -1;
                if (this.lineSeparator == null) {
                    String string = c == 13 && c2 == 10 ? "\r\n" : (this.lineSeparator = c == 13 ? "\r" : "\n");
                }
                if (c2 != 10) {
                    this.lastChar = c2;
                }
                c = 10;
            }
            return c;
        }

        public Token nextToken() throws IOException {
            Token token = new Token();
            int c = this.readChar();
            this.buffer.setLength(0);
            if (Character.isWhitespace(c)) {
                this.buffer.append((char)c);
                while ((c = this.readChar()) != -1 && Character.isWhitespace(c)) {
                    this.buffer.append((char)c);
                }
            }
            token.file = this.file;
            token.lineNumber = this.lineNumber;
            token.spacing = this.buffer.toString();
            this.buffer.setLength(0);
            if (Character.isLetter(c) || c == 95) {
                token.type = 5;
                this.buffer.append((char)c);
                while ((c = this.readChar()) != -1 && (Character.isDigit(c) || Character.isLetter(c) || c == 95)) {
                    this.buffer.append((char)c);
                }
                token.value = this.buffer.toString();
                this.lastChar = c;
            } else if (Character.isDigit(c) || c == 46 || c == 45 || c == 43) {
                token.type = c == 46 ? 2 : 1;
                this.buffer.append((char)c);
                int prevc = 0;
                while ((c = this.readChar()) != -1 && (Character.isDigit(c) || c == 46 || c == 45 || c == 43 || c >= 97 && c <= 102 || c == 108 || c == 117 || c == 120 || c >= 65 && c <= 70 || c == 76 || c == 85 || c == 88)) {
                    if (c == 46) {
                        token.type = 2;
                    }
                    if (c != 117 && c != 85) {
                        this.buffer.append((char)c);
                    }
                    prevc = c;
                }
                if (prevc == 102 || prevc == 70) {
                    token.type = 2;
                }
                token.value = this.buffer.toString();
                if (token.type == 1 && token.value.endsWith("LL")) {
                    token.value = token.value.substring(0, token.value.length() - 1);
                }
                this.lastChar = c;
            } else if (c == 34) {
                token.type = 3;
                this.buffer.append('\"');
                int prevc = 0;
                while ((c = this.readChar()) != -1 && (prevc == 92 || c != 34)) {
                    this.buffer.append((char)c);
                    prevc = c;
                }
                this.buffer.append('\"');
                token.value = this.buffer.toString();
            } else if (c == 47) {
                c = this.readChar();
                if (c == 47) {
                    token.type = 4;
                    this.buffer.append('/').append('/');
                    int prevc = 0;
                    while ((c = this.readChar()) != -1 && (prevc == 92 || c != 10)) {
                        this.buffer.append((char)c);
                        prevc = c;
                    }
                    token.value = this.buffer.toString();
                    this.lastChar = c;
                } else if (c == 42) {
                    token.type = 4;
                    this.buffer.append('/').append('*');
                    int prevc = 0;
                    while ((c = this.readChar()) != -1 && (prevc != 42 || c != 47)) {
                        this.buffer.append((char)c);
                        prevc = c;
                    }
                    this.buffer.append('/');
                    token.value = this.buffer.toString();
                } else {
                    this.lastChar = c;
                    token.type = 47;
                }
            } else {
                if (c == 92) {
                    int c2 = this.readChar();
                    if (c2 == 10) {
                        String s = token.spacing;
                        token = this.nextToken();
                        token.spacing = s;
                        return token;
                    }
                    this.lastChar = c2;
                }
                token.type = c;
            }
            return token;
        }
    }

    static class Token
    implements Cloneable {
        static final int INTEGER = 1;
        static final int FLOAT = 2;
        static final int STRING = 3;
        static final int COMMENT = 4;
        static final int IDENTIFIER = 5;
        static final Token EOF = new Token();
        static final Token CONST = new Token(5, "const");
        static final Token DEFINE = new Token(5, "define");
        static final Token IF = new Token(5, "if");
        static final Token IFDEF = new Token(5, "ifdef");
        static final Token IFNDEF = new Token(5, "ifndef");
        static final Token ELIF = new Token(5, "elif");
        static final Token ELSE = new Token(5, "else");
        static final Token ENDIF = new Token(5, "endif");
        static final Token ENUM = new Token(5, "enum");
        static final Token EXTERN = new Token(5, "extern");
        static final Token INLINE = new Token(5, "inline");
        static final Token STATIC = new Token(5, "static");
        static final Token CLASS = new Token(5, "class");
        static final Token STRUCT = new Token(5, "struct");
        static final Token UNION = new Token(5, "union");
        static final Token TEMPLATE = new Token(5, "template");
        static final Token TYPEDEF = new Token(5, "typedef");
        static final Token TYPENAME = new Token(5, "typename");
        File file = null;
        int lineNumber = 0;
        int type = -1;
        String spacing = "";
        String value = "";

        Token() {
        }

        Token(int type, String value) {
            this.type = type;
            this.value = value;
        }

        boolean match(Object ... tokens) {
            boolean found = false;
            for (Object t : tokens) {
                found = found || this.equals(t);
            }
            return found;
        }

        Token expect(Object ... tokens) throws Exception {
            if (!this.match(tokens)) {
                throw new Exception(this.file + ":" + this.lineNumber + ": Unexpected token '" + this.toString() + "'");
            }
            return this;
        }

        boolean isEmpty() {
            return this.type == -1 && this.spacing.isEmpty();
        }

        public Token clone() {
            Token t = new Token();
            t.file = this.file;
            t.lineNumber = this.lineNumber;
            t.type = this.type;
            t.spacing = this.spacing;
            t.value = this.value;
            return t;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (obj.getClass() == Integer.class) {
                return this.type == (Integer)obj;
            }
            if (obj.getClass() == Character.class) {
                return this.type == ((Character)obj).charValue();
            }
            if (obj.getClass() == String.class) {
                return obj.equals(this.value);
            }
            if (obj.getClass() == this.getClass()) {
                Token other = (Token)obj;
                return this.type == other.type && (this.value == null && other.value == null || this.value != null && this.value.equals(other.value));
            }
            return false;
        }

        public int hashCode() {
            return this.type;
        }

        public String toString() {
            return this.value != null && this.value.length() > 0 ? this.value : String.valueOf((char)this.type);
        }
    }

    public static interface InfoMapper {
        public void map(InfoMap var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class InfoMap
    extends HashMap<String, LinkedList<Info>> {
        InfoMap parent = null;
        static final InfoMap defaults = new InfoMap(null).put(new Info("void").primitiveTypes("void").pointerTypes("Pointer")).put(new Info("FILE").pointerTypes("Pointer").cast(true)).put(new Info("va_list").pointerTypes("Pointer").cast(true)).put(new Info("int8_t", "jbyte", "signed char").primitiveTypes("byte").pointerTypes("BytePointer", "ByteBuffer", "byte[]")).put(new Info("uint8_t", "char", "unsigned char").primitiveTypes("byte").pointerTypes("BytePointer", "ByteBuffer", "byte[]").cast(true)).put(new Info("int16_t", "jshort", "short", "signed short", "short int", "signed short int").primitiveTypes("short").pointerTypes("ShortPointer", "ShortBuffer", "short[]")).put(new Info("uint16_t", "unsigned short", "unsigned short int").primitiveTypes("short").pointerTypes("ShortPointer", "ShortBuffer", "short[]").cast(true)).put(new Info("int32_t", "jint", "int", "signed int", "signed").primitiveTypes("int").pointerTypes("IntPointer", "IntBuffer", "int[]")).put(new Info("uint32_t", "unsigned int", "unsigned").primitiveTypes("int").pointerTypes("IntPointer", "IntBuffer", "int[]").cast(true)).put(new Info("int64_t", "__int64", "jlong", "long long", "signed long long", "long long int", "signed long long int").primitiveTypes("long").pointerTypes("LongPointer", "LongBuffer", "long[]")).put(new Info("uint64_t", "__uint64", "unsigned long long", "unsigned long long int").primitiveTypes("long").pointerTypes("LongPointer", "LongBuffer", "long[]").cast(true)).put(new Info("long", "signed long", "long int", "signed long int").primitiveTypes("long").pointerTypes("CLongPointer")).put(new Info("unsigned long", "unsigned long int").primitiveTypes("long").pointerTypes("CLongPointer").cast(true)).put(new Info("size_t").primitiveTypes("long").pointerTypes("SizeTPointer")).put(new Info("float", "jfloat").primitiveTypes("float").pointerTypes("FloatPointer", "FloatBuffer", "float[]")).put(new Info("double", "jdouble").primitiveTypes("double").pointerTypes("DoublePointer", "DoubleBuffer", "double[]")).put(new Info("bool", "jboolean").primitiveTypes("boolean").pointerTypes("BoolPointer").cast(true)).put(new Info("const char").primitiveTypes("byte").pointerTypes("@Cast(\"const char*\") BytePointer", "String")).put(new Info("position").javaNames("_position")).put(new Info("limit").javaNames("_limit")).put(new Info("capacity").javaNames("_capacity"));

        public InfoMap() {
            this.parent = defaults;
        }

        public InfoMap(InfoMap parent) {
            this.parent = parent;
        }

        static String sort(String name) {
            return InfoMap.sort(name, false);
        }

        static String sort(String name, boolean unconst) {
            if (name == null) {
                return null;
            }
            TreeSet<String> set = new TreeSet<String>();
            try {
                Token token;
                Tokenizer tokenizer = new Tokenizer(new StringReader(name));
                while (!(token = tokenizer.nextToken()).isEmpty()) {
                    set.add(token.value);
                }
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            boolean foundConst = false;
            name = "";
            for (String s : set) {
                if ("const".equals(s)) {
                    foundConst = true;
                    continue;
                }
                name = name + s + " ";
            }
            if (!unconst && foundConst) {
                return "const " + name.trim();
            }
            return name.trim();
        }

        public LinkedList<Info> get(String cppName) {
            String key = InfoMap.sort(cppName, false);
            LinkedList<Info> infoList = (LinkedList<Info>)super.get(key);
            if (infoList == null) {
                key = InfoMap.sort(cppName, true);
                infoList = (LinkedList<Info>)super.get(key);
            }
            if (infoList == null && this.parent != null) {
                infoList = this.parent.get(cppName);
            }
            if (infoList == null) {
                infoList = new LinkedList<Info>();
            }
            return infoList;
        }

        public InfoMap put(Info info) {
            String[] stringArray;
            if (info.cppNames != null) {
                stringArray = info.cppNames;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = null;
            }
            for (String cppName : stringArray) {
                String key = InfoMap.sort(cppName, false);
                LinkedList<Info> infoList = (LinkedList<Info>)super.get(key);
                if (infoList == null) {
                    infoList = new LinkedList<Info>();
                }
                if (!infoList.contains(info)) {
                    infoList.add(info);
                }
                super.put(key, infoList);
            }
            return this;
        }
    }

    public static class Info
    implements Cloneable {
        String[] cppNames = null;
        String[] javaNames = null;
        String[] annotations = null;
        String[] primitiveTypes = null;
        String[] pointerTypes = null;
        String[] genericTypes = null;
        boolean cast = false;
        boolean define = false;
        boolean complex = false;
        boolean forwardDeclared = false;
        String textBefore = null;
        String textAfter = null;

        public Info() {
        }

        public Info(String ... cppNames) {
            this.cppNames = cppNames;
        }

        public Info cppNames(String ... cppNames) {
            this.cppNames = cppNames;
            return this;
        }

        public Info javaNames(String ... javaNames) {
            this.javaNames = javaNames;
            return this;
        }

        public Info annotations(String ... annotations) {
            this.annotations = annotations;
            return this;
        }

        public Info primitiveTypes(String ... primitiveTypes) {
            this.primitiveTypes = primitiveTypes;
            return this;
        }

        public Info pointerTypes(String ... pointerTypes) {
            this.pointerTypes = pointerTypes;
            return this;
        }

        public Info genericTypes(String ... genericTypes) {
            this.genericTypes = genericTypes;
            return this;
        }

        public Info cast(boolean cast) {
            this.cast = cast;
            return this;
        }

        public Info define(boolean define) {
            this.define = define;
            return this;
        }

        public Info complex(boolean complex) {
            this.complex = complex;
            return this;
        }

        public Info forwardDeclared(boolean forwardDeclared) {
            this.forwardDeclared = forwardDeclared;
            return this;
        }

        public Info textBefore(String textBefore) {
            this.textBefore = textBefore;
            return this;
        }

        public Info textAfter(String textAfter) {
            this.textAfter = textAfter;
            return this;
        }

        public Info clone() {
            Info i = new Info();
            i.cppNames = this.cppNames != null ? (String[])this.cppNames.clone() : null;
            i.javaNames = this.javaNames != null ? (String[])this.javaNames.clone() : null;
            i.annotations = this.annotations != null ? (String[])this.annotations.clone() : null;
            i.primitiveTypes = this.primitiveTypes != null ? (String[])this.primitiveTypes.clone() : null;
            i.pointerTypes = this.pointerTypes != null ? (String[])this.pointerTypes.clone() : null;
            i.genericTypes = this.genericTypes != null ? (String[])this.genericTypes.clone() : null;
            i.cast = this.cast;
            i.define = this.define;
            i.forwardDeclared = this.forwardDeclared;
            i.textBefore = this.textBefore;
            i.textAfter = this.textAfter;
            return i;
        }
    }

    public static class Exception
    extends java.lang.Exception {
        public Exception(String message) {
            super(message);
        }

        public Exception(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

