/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javacpp;

import com.googlecode.javacpp.Pointer;
import com.googlecode.javacpp.annotation.Platform;
import com.googlecode.javacpp.annotation.Properties;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Loader {
    private static final String platformName;
    private static java.util.Properties platformProperties;
    static File tempDir;
    static boolean loadLibraries;
    static Map<String, String> loadedLibraries;
    static WeakHashMap<Class<? extends Pointer>, HashMap<String, Integer>> memberOffsets;

    public static String getPlatformName() {
        return System.getProperty("com.googlecode.javacpp.platform.name", platformName);
    }

    public static java.util.Properties loadProperties() {
        String name = Loader.getPlatformName();
        if (platformProperties != null && name.equals(platformProperties.getProperty("platform.name"))) {
            return platformProperties;
        }
        platformProperties = Loader.loadProperties(name);
        return platformProperties;
    }

    public static java.util.Properties loadProperties(String name) {
        java.util.Properties p = new java.util.Properties();
        p.put("platform.name", name);
        name = "properties/" + name + ".properties";
        InputStream is = Loader.class.getResourceAsStream(name);
        try {
            try {
                p.load(new InputStreamReader(is));
            }
            catch (NoSuchMethodError e) {
                p.load(is);
            }
        }
        catch (Exception e) {
            name = "properties/generic.properties";
            is = Loader.class.getResourceAsStream(name);
            try {
                try {
                    p.load(new InputStreamReader(is));
                }
                catch (NoSuchMethodError e2) {
                    p.load(is);
                }
            }
            catch (Exception e2) {
                throw new MissingResourceException("Could not even get generic properties: " + e2.getMessage(), Loader.class.getName(), name);
            }
        }
        return p;
    }

    public static Class getEnclosingClass(Class cls) {
        Platform p;
        Class<?> c = cls;
        while (c.getDeclaringClass() != null && !c.isAnnotationPresent(Properties.class) && (!c.isAnnotationPresent(Platform.class) || (p = c.getAnnotation(Platform.class)).define().length <= 0 && p.include().length <= 0 && p.cinclude().length <= 0 && p.includepath().length <= 0 && p.options().length <= 0 && p.linkpath().length <= 0 && p.link().length <= 0 && p.framework().length <= 0 && p.preloadpath().length <= 0 && p.preload().length <= 0 && p.library().length() <= 0)) {
            c = c.getDeclaringClass();
        }
        return c;
    }

    public static ClassProperties loadProperties(Class[] cls, java.util.Properties properties, boolean inherit) {
        ClassProperties cp = new ClassProperties(properties);
        for (Class c : cls) {
            cp.load(c, inherit);
        }
        return cp;
    }

    public static ClassProperties loadProperties(Class cls, java.util.Properties properties, boolean inherit) {
        ClassProperties cp = new ClassProperties(properties);
        cp.load(cls, inherit);
        return cp;
    }

    public static Class getCallerClass(int i) {
        Class[] classContext = new SecurityManager(){

            public Class[] getClassContext() {
                return super.getClassContext();
            }
        }.getClassContext();
        if (classContext != null) {
            for (int j = 0; j < classContext.length; ++j) {
                if (classContext[j] != Loader.class) continue;
                return classContext[i + j];
            }
        } else {
            try {
                StackTraceElement[] classNames = Thread.currentThread().getStackTrace();
                for (int j = 0; j < classNames.length; ++j) {
                    if (Class.forName(classNames[j].getClassName()) != Loader.class) continue;
                    return Class.forName(classNames[i + j].getClassName());
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    public static File extractResource(String name, File directory, String prefix, String suffix) throws IOException {
        Class cls = Loader.getCallerClass(2);
        return Loader.extractResource(cls, name, directory, prefix, suffix);
    }

    public static File extractResource(Class cls, String name, File directory, String prefix, String suffix) throws IOException {
        return Loader.extractResource(cls.getResource(name), directory, prefix, suffix);
    }

    public static File extractResource(URL resourceURL, File directory, String prefix, String suffix) throws IOException {
        InputStream is;
        InputStream inputStream = is = resourceURL != null ? resourceURL.openStream() : null;
        if (is == null) {
            return null;
        }
        File file = null;
        boolean fileExisted = false;
        try {
            int length;
            if (prefix == null && suffix == null) {
                if (directory == null) {
                    directory = new File(System.getProperty("java.io.tmpdir"));
                }
                file = new File(directory, new File(resourceURL.getPath()).getName());
                fileExisted = file.exists();
            } else {
                file = File.createTempFile(prefix, suffix, directory);
            }
            FileOutputStream os = new FileOutputStream(file);
            byte[] buffer = new byte[1024];
            while ((length = is.read(buffer)) != -1) {
                os.write(buffer, 0, length);
            }
            is.close();
            os.close();
        }
        catch (IOException e) {
            if (file != null && !fileExisted) {
                file.delete();
            }
            throw e;
        }
        return file;
    }

    public static File getTempDir() {
        if (tempDir == null) {
            File tmpdir = new File(System.getProperty("java.io.tmpdir"));
            File f = null;
            for (int i = 0; i < 1000; ++i) {
                f = new File(tmpdir, "javacpp" + System.nanoTime());
                if (!f.mkdir()) continue;
                tempDir = f;
                tempDir.deleteOnExit();
                break;
            }
        }
        return tempDir;
    }

    public static boolean isLoadLibraries() {
        return loadLibraries;
    }

    public static String load() {
        Class cls = Loader.getCallerClass(2);
        return Loader.load(cls);
    }

    public static String load(Class cls) {
        if (!loadLibraries || cls == null) {
            return null;
        }
        cls = Loader.getEnclosingClass(cls);
        try {
            cls = Class.forName(cls.getName(), true, cls.getClassLoader());
        }
        catch (ClassNotFoundException ex) {
            NoClassDefFoundError e = new NoClassDefFoundError(ex.toString());
            e.initCause(ex);
            throw e;
        }
        ClassProperties p = Loader.loadProperties(cls, Loader.loadProperties(), true);
        LinkedList<String> preloads = new LinkedList<String>();
        preloads.addAll(p.get("loader.preload"));
        preloads.addAll(p.get("compiler.link"));
        UnsatisfiedLinkError preloadError = null;
        for (String preload : preloads) {
            try {
                URL[] urls = Loader.findLibrary(cls, p, preload);
                Loader.loadLibrary(urls, preload);
            }
            catch (UnsatisfiedLinkError e) {
                preloadError = e;
            }
        }
        try {
            String library = p.getProperty("loader.library");
            URL[] urls = Loader.findLibrary(cls, p, library);
            return Loader.loadLibrary(urls, library);
        }
        catch (UnsatisfiedLinkError e) {
            if (preloadError != null) {
                e.initCause(preloadError);
            }
            throw e;
        }
    }

    public static URL[] findLibrary(Class cls, ClassProperties properties, String libnameversion) {
        int i;
        String[] s = libnameversion.split("@");
        String libname = s[0];
        String version = s.length > 1 ? s[s.length - 1] : "";
        String filename = loadedLibraries.get(libnameversion);
        if (filename != null) {
            try {
                return new URL[]{new File(filename).toURI().toURL()};
            }
            catch (IOException ex) {
                return new URL[0];
            }
        }
        String subdir = properties.getProperty("platform.name") + '/';
        String prefix = properties.getProperty("library.prefix", "") + libname;
        String suffix = properties.getProperty("library.suffix", "");
        String[] styles = new String[]{prefix + suffix + version, prefix + version + suffix, prefix + suffix};
        int k = 0;
        LinkedList<String> paths = new LinkedList<String>();
        paths.addAll(properties.get("loader.preloadpath"));
        paths.addAll(properties.get("compiler.linkpath"));
        URL[] urls = new URL[styles.length * (1 + paths.size())];
        for (i = 0; cls != null && i < styles.length; ++i) {
            URL u = cls.getResource(subdir + styles[i]);
            if (u == null) continue;
            urls[k++] = u;
        }
        for (i = 0; paths.size() > 0 && i < styles.length; ++i) {
            for (String path : paths) {
                File file = new File(path, styles[i]);
                if (!file.exists()) continue;
                try {
                    urls[k++] = file.toURI().toURL();
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
        return Arrays.copyOf(urls, k);
    }

    public static String loadLibrary(URL[] urls, String libnameversion) {
        String libname;
        if (!loadLibraries) {
            return null;
        }
        String filename = loadedLibraries.get(libnameversion);
        if (filename != null) {
            return filename;
        }
        File tempFile = null;
        UnsatisfiedLinkError loadError = null;
        try {
            for (URL url : urls) {
                File file;
                try {
                    file = new File(url.toURI());
                }
                catch (Exception e) {
                    if (tempFile != null && tempFile.exists()) {
                        tempFile.deleteOnExit();
                    }
                    file = tempFile = Loader.extractResource(url, Loader.getTempDir(), null, null);
                }
                if (file == null || !file.exists()) continue;
                filename = file.getAbsolutePath();
                try {
                    loadedLibraries.put(libnameversion, filename);
                    System.load(filename);
                    String e = filename;
                    return e;
                }
                catch (UnsatisfiedLinkError e) {
                    loadError = e;
                    loadedLibraries.remove(libnameversion);
                }
            }
            libname = libnameversion.split("@")[0];
            loadedLibraries.put(libnameversion, libname);
        }
        catch (UnsatisfiedLinkError e) {
            loadedLibraries.remove(libnameversion);
            if (loadError != null) {
                e.initCause(loadError);
            }
            throw e;
        }
        catch (IOException ex) {
            loadedLibraries.remove(libnameversion);
            if (loadError != null) {
                ex.initCause(loadError);
            }
            UnsatisfiedLinkError e = new UnsatisfiedLinkError(ex.toString());
            e.initCause(ex);
            throw e;
        }
        finally {
            if (tempFile != null && tempFile.exists()) {
                tempFile.deleteOnExit();
            }
        }
        System.loadLibrary(libname);
        String len$ = libname;
        return len$;
    }

    public static void main(String[] args) {
        File tempDir;
        File tmpdir = new File(System.getProperty("java.io.tmpdir"));
        if (!tmpdir.equals((tempDir = new File(args[0])).getParentFile()) || !tempDir.getName().startsWith("javacpp")) {
            return;
        }
        for (File file : tempDir.listFiles()) {
            while (file.exists() && !file.delete()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {}
            }
        }
        tempDir.delete();
    }

    static void putMemberOffset(String typeName, String member, int offset) throws ClassNotFoundException {
        Class<?> c = Class.forName(typeName.replace('/', '.'), false, Loader.class.getClassLoader());
        Loader.putMemberOffset(c.asSubclass(Pointer.class), member, offset);
    }

    static synchronized void putMemberOffset(Class<? extends Pointer> type, String member, int offset) {
        HashMap<String, Integer> offsets = memberOffsets.get(type);
        if (offsets == null) {
            offsets = new HashMap();
            memberOffsets.put(type, offsets);
        }
        offsets.put(member, offset);
    }

    public static int offsetof(Class<? extends Pointer> type, String member) {
        return memberOffsets.get(type).get(member);
    }

    public static int sizeof(Class<? extends Pointer> type) {
        return memberOffsets.get(type).get("sizeof");
    }

    static {
        platformProperties = null;
        String jvmName = System.getProperty("java.vm.name").toLowerCase();
        String osName = System.getProperty("os.name").toLowerCase();
        String osArch = System.getProperty("os.arch").toLowerCase();
        if (jvmName.startsWith("dalvik") && osName.startsWith("linux")) {
            osName = "android";
        } else if (osName.startsWith("mac os x")) {
            osName = "macosx";
        } else {
            int spaceIndex = osName.indexOf(32);
            if (spaceIndex > 0) {
                osName = osName.substring(0, spaceIndex);
            }
        }
        if (osArch.equals("i386") || osArch.equals("i486") || osArch.equals("i586") || osArch.equals("i686")) {
            osArch = "x86";
        } else if (osArch.equals("amd64") || osArch.equals("x86-64") || osArch.equals("x64")) {
            osArch = "x86_64";
        } else if (osArch.startsWith("arm")) {
            osArch = "arm";
        }
        platformName = osName + "-" + osArch;
        tempDir = null;
        loadLibraries = true;
        loadedLibraries = Collections.synchronizedMap(new HashMap());
        if (Loader.getPlatformName().startsWith("windows")) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    if (tempDir == null) {
                        return;
                    }
                    try {
                        LinkedList<String> command = new LinkedList<String>();
                        command.add(System.getProperty("java.home") + "/bin/java");
                        command.add("-classpath");
                        command.add(System.getProperty("java.class.path"));
                        command.add(Loader.class.getName());
                        command.add(tempDir.getAbsolutePath());
                        new ProcessBuilder(command).start();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        memberOffsets = new WeakHashMap();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ClassProperties
    extends HashMap<String, LinkedList<String>> {
        String platformName;
        String platformRoot;
        String pathSeparator;

        public ClassProperties() {
        }

        public ClassProperties(java.util.Properties properties) {
            this.platformName = properties.getProperty("platform.name");
            this.platformRoot = properties.getProperty("platform.root");
            this.pathSeparator = properties.getProperty("path.separator");
            if (this.platformRoot == null || this.platformRoot.length() == 0) {
                this.platformRoot = ".";
            }
            if (!this.platformRoot.endsWith(File.separator)) {
                this.platformRoot = this.platformRoot + File.separator;
            }
            for (Map.Entry<Object, Object> e : properties.entrySet()) {
                String k = (String)e.getKey();
                String v = (String)e.getValue();
                if (v == null || v.length() == 0) continue;
                if (k.equals("compiler.includepath") || k.equals("compiler.include") || k.equals("compiler.linkpath") || k.equals("compiler.link") || k.equals("compiler.framework")) {
                    this.addAll(k, v.split(this.pathSeparator));
                    continue;
                }
                this.setProperty(k, v);
            }
        }

        public LinkedList<String> get(String key) {
            LinkedList list = (LinkedList)super.get(key);
            if (list == null) {
                list = new LinkedList();
                this.put(key, list);
            }
            return list;
        }

        public void addAll(String key, String ... values) {
            if (values != null) {
                this.addAll(key, Arrays.asList(values));
            }
        }

        public void addAll(String key, Collection<String> values) {
            if (values != null) {
                String root = null;
                if (key.equals("compiler.path") || key.equals("compiler.sysroot") || key.equals("compiler.includepath") || key.equals("compiler.linkpath")) {
                    root = this.platformRoot;
                }
                LinkedList<String> values2 = this.get(key);
                for (String value : values) {
                    if (value == null || values2.contains(value)) continue;
                    if (root != null && !new File(value).isAbsolute() && new File(root + value).exists()) {
                        value = root + value;
                    }
                    values2.add(value);
                }
            }
        }

        public String getProperty(String key) {
            return this.getProperty(key, null);
        }

        public String getProperty(String key, String defaultValue) {
            LinkedList<String> values = this.get(key);
            return values.isEmpty() ? defaultValue : values.get(0);
        }

        public String setProperty(String key, String value) {
            LinkedList<String> values = this.get(key);
            String oldValue = values.isEmpty() ? null : values.get(0);
            values.clear();
            this.addAll(key, value);
            return oldValue;
        }

        public void load(Class cls, boolean inherit) {
            Platform[] platforms;
            Class c = Loader.getEnclosingClass(cls);
            while (!c.isAnnotationPresent(Properties.class) && !c.isAnnotationPresent(Platform.class) && c.getSuperclass() != null) {
                c = c.getSuperclass();
            }
            Properties classProperties = c.getAnnotation(Properties.class);
            if (classProperties == null) {
                Platform platform = c.getAnnotation(Platform.class);
                if (platform == null) {
                    return;
                }
                platforms = new Platform[]{platform};
            } else {
                String target;
                Class[] classes = classProperties.inherit();
                if (inherit && classes != null) {
                    for (Class c2 : classes) {
                        this.load(c2, inherit);
                    }
                }
                if ((target = classProperties.target()).length() > 0) {
                    this.addAll("parser.target", target);
                }
                if ((platforms = classProperties.value()) == null) {
                    return;
                }
            }
            String[] define = new String[]{};
            String[] include = new String[]{};
            String[] cinclude = new String[]{};
            String[] includepath = new String[]{};
            String[] options = new String[]{};
            String[] linkpath = new String[]{};
            String[] link = new String[]{};
            String[] framework = new String[]{};
            String[] preloadpath = new String[]{};
            String[] preload = new String[]{};
            String library = "jni" + c.getSimpleName();
            for (Platform p : platforms) {
                String[][] names = new String[][]{p.value(), p.not()};
                boolean[] matches = new boolean[]{false, false};
                block3: for (int i = 0; i < names.length; ++i) {
                    for (String s : names[i]) {
                        if (!this.platformName.startsWith(s)) continue;
                        matches[i] = true;
                        continue block3;
                    }
                }
                if (names[0].length != 0 && !matches[0] || names[1].length != 0 && matches[1]) continue;
                if (p.define().length > 0) {
                    define = p.define();
                }
                if (p.include().length > 0) {
                    include = p.include();
                }
                if (p.cinclude().length > 0) {
                    cinclude = p.cinclude();
                }
                if (p.includepath().length > 0) {
                    includepath = p.includepath();
                }
                if (p.options().length > 0) {
                    options = p.options();
                }
                if (p.linkpath().length > 0) {
                    linkpath = p.linkpath();
                }
                if (p.link().length > 0) {
                    link = p.link();
                }
                if (p.framework().length > 0) {
                    framework = p.framework();
                }
                if (p.preloadpath().length > 0) {
                    preloadpath = p.preloadpath();
                }
                if (p.preload().length > 0) {
                    preload = p.preload();
                }
                if (p.library().length() <= 0) continue;
                library = p.library();
            }
            this.addAll("generator.define", define);
            this.addAll("generator.include", include);
            this.addAll("generator.cinclude", cinclude);
            this.addAll("compiler.includepath", includepath);
            this.addAll("compiler.options", options);
            this.addAll("compiler.linkpath", linkpath);
            this.addAll("compiler.link", link);
            this.addAll("compiler.framework", framework);
            this.addAll("loader.preloadpath", preloadpath);
            this.addAll("loader.preload", preload);
            this.setProperty("loader.library", library);
        }

        LinkedList<File> getHeaderFiles() {
            LinkedList<String> paths = this.get("compiler.includepath");
            LinkedList<String> includes = new LinkedList<String>();
            includes.addAll(this.get("generator.include"));
            includes.addAll(this.get("generator.cinclude"));
            LinkedList<File> files = new LinkedList<File>();
            block0: for (String include : includes) {
                if (include.startsWith("<") && include.endsWith(">")) {
                    include = include.substring(1, include.length() - 1);
                } else {
                    File f = new File(include);
                    if (f.exists()) {
                        files.add(f);
                        continue;
                    }
                }
                for (String path : paths) {
                    File f = new File(path, include);
                    if (!f.exists()) continue;
                    files.add(f);
                    continue block0;
                }
            }
            return files;
        }
    }
}

