# ##############################################################################
#                 ARDUINO SERVICE FILE
# ##############################################################################


# ##############################################################################
# ARDUINO RELATED FUNCTIONS
# ##############################################################################

#parse config
ThisServicePart=RuningFolder+'config/service_'+os.path.basename(inspect.stack()[0][1]).replace('.py','')

CheckFileExist(ThisServicePart)
ThisServicePartConfig = ConfigParser.ConfigParser()
ThisServicePartConfig.read(ThisServicePart+'.config')
MyRightPort=ThisServicePartConfig.get('MAIN', 'MyRightPort')
MyLeftPort=ThisServicePartConfig.get('MAIN', 'MyLeftPort')
BoardTypeMyRightPort=ThisServicePartConfig.get('MAIN', 'BoardTypeMyRightPort')
BoardTypeMyLeftPort=ThisServicePartConfig.get('MAIN', 'BoardTypeMyLeftPort')
ForceArduinoIsConnected=ThisServicePartConfig.getboolean('MAIN', 'ForceArduinoIsConnected')
try:
  test=ThisServicePartConfig.get('MAIN', 'ArefRightArduino')
except:
  ThisServicePartConfig.set('MAIN', 'ArefRightArduino', 'DEFAULT')
  ThisServicePartConfig.set('MAIN', 'ArefLeftArduino', 'DEFAULT')
  with open(ThisServicePart+'.config', 'wb') as f:
    ThisServicePartConfig.write(f)
  ThisServicePartConfig.read(ThisServicePart+'.config')
  pass
  
  
#function to check arduino & mrlcomm
def CheckArduinos(Card,Port,slave=0):
  
  #serial
  if slave!=0:
    Card.connect(slave,Port)
    sleep(1)
    for i in range(0,3):
      if not Card.isConnected():
        Card.disconnect()
        sleep(0.1)
        Card.connect(slave,Port)
        sleep(0.5)
      else:
        break
        
  #usb
  else:
    Card.connect(Port)
    sleep(1)
    for i in range(0,3):
      if not Card.isConnected():
        Card.disconnect()
        sleep(0.1)
        Card.connect(Port)
        sleep(0.5)
      else:
        break
    
  if ForceArduinoIsConnected:return True
  else:
  
    #mrlcomm check
    if Card.isConnected():
      print "Mrlcomm version : ",Card.getBoardInfo().version," ( requiered ",MRLCOMM_VERSION," )"
      if Card.getBoardInfo().version!=MRLCOMM_VERSION:errorSpokenFunc('BadMrlcommVersion',Port)
      else:
        print "Arduino ",Port," OK"
        return True
    else:
      #bouuuuuhhhh
      errorSpokenFunc('ArduinoNotConnected',Port)
      return False