/*
 * Decompiled with CFR 0.152.
 */
package org.alicebot.ab;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.alicebot.ab.Bot;
import org.alicebot.ab.Chat;
import org.alicebot.ab.Clause;
import org.alicebot.ab.MagicBooleans;
import org.alicebot.ab.MagicStrings;
import org.alicebot.ab.Tuple;

public class TripleStore {
    public int idCnt = 0;
    public String name = "unknown";
    public Chat chatSession;
    public Bot bot;
    public HashMap<String, Triple> idTriple = new HashMap();
    public HashMap<String, String> tripleStringId = new HashMap();
    public HashMap<String, HashSet<String>> subjectTriples = new HashMap();
    public HashMap<String, HashSet<String>> predicateTriples = new HashMap();
    public HashMap<String, HashSet<String>> objectTriples = new HashMap();

    public TripleStore(String name, Chat chatSession) {
        this.name = name;
        this.chatSession = chatSession;
        this.bot = chatSession.bot;
    }

    public String mapTriple(Triple triple) {
        String id = triple.id;
        this.idTriple.put(id, triple);
        String s = triple.subject;
        String p = triple.predicate;
        String o = triple.object;
        s = s.toUpperCase();
        p = p.toUpperCase();
        o = o.toUpperCase();
        String tripleString = s + ":" + p + ":" + o;
        tripleString = tripleString.toUpperCase();
        if (this.tripleStringId.keySet().contains(tripleString)) {
            return this.tripleStringId.get(tripleString);
        }
        this.tripleStringId.put(tripleString, id);
        HashSet<String> existingTriples = this.subjectTriples.containsKey(s) ? this.subjectTriples.get(s) : new HashSet<String>();
        existingTriples.add(id);
        this.subjectTriples.put(s, existingTriples);
        existingTriples = this.predicateTriples.containsKey(p) ? this.predicateTriples.get(p) : new HashSet();
        existingTriples.add(id);
        this.predicateTriples.put(p, existingTriples);
        existingTriples = this.objectTriples.containsKey(o) ? this.objectTriples.get(o) : new HashSet();
        existingTriples.add(id);
        this.objectTriples.put(o, existingTriples);
        return id;
    }

    public String unMapTriple(Triple triple) {
        String id = MagicStrings.undefined_triple;
        String s = triple.subject;
        String p = triple.predicate;
        String o = triple.object;
        s = s.toUpperCase();
        p = p.toUpperCase();
        o = o.toUpperCase();
        String tripleString = s + ":" + p + ":" + o;
        System.out.println("unMapTriple " + tripleString);
        tripleString = tripleString.toUpperCase();
        triple = this.idTriple.get(this.tripleStringId.get(tripleString));
        System.out.println("unMapTriple " + triple);
        if (triple != null) {
            id = triple.id;
            this.idTriple.remove(id);
            this.tripleStringId.remove(tripleString);
            HashSet<Object> existingTriples = this.subjectTriples.containsKey(s) ? this.subjectTriples.get(s) : new HashSet();
            existingTriples.remove(id);
            this.subjectTriples.put(s, existingTriples);
            existingTriples = this.predicateTriples.containsKey(p) ? this.predicateTriples.get(p) : new HashSet();
            existingTriples.remove(id);
            this.predicateTriples.put(p, existingTriples);
            existingTriples = this.objectTriples.containsKey(o) ? this.objectTriples.get(o) : new HashSet();
            existingTriples.remove(id);
            this.objectTriples.put(o, existingTriples);
        } else {
            id = MagicStrings.undefined_triple;
        }
        return id;
    }

    public Set<String> allTriples() {
        return new HashSet<String>(this.idTriple.keySet());
    }

    public String addTriple(String subject, String predicate, String object) {
        if (subject == null || predicate == null || object == null) {
            return MagicStrings.undefined_triple;
        }
        Triple triple = new Triple(subject, predicate, object);
        String id = this.mapTriple(triple);
        return id;
    }

    public String deleteTriple(String subject, String predicate, String object) {
        if (subject == null || predicate == null || object == null) {
            return MagicStrings.undefined_triple;
        }
        if (MagicBooleans.trace_mode) {
            System.out.println("Deleting " + subject + " " + predicate + " " + object);
        }
        Triple triple = new Triple(subject, predicate, object);
        String id = this.unMapTriple(triple);
        return id;
    }

    public void printTriples() {
        for (String x : this.idTriple.keySet()) {
            Triple triple = this.idTriple.get(x);
            System.out.println(x + ":" + triple.subject + ":" + triple.predicate + ":" + triple.object);
        }
    }

    HashSet<String> emptySet() {
        return new HashSet<String>();
    }

    public HashSet<String> getTriples(String s, String p, String o) {
        if (MagicBooleans.trace_mode) {
            System.out.println("TripleStore: getTriples [" + this.idTriple.size() + "] " + s + ":" + p + ":" + o);
        }
        Set<Object> subjectSet = s == null || s.startsWith("?") ? this.allTriples() : (this.subjectTriples.containsKey(s = s.toUpperCase()) ? (Set<Object>)this.subjectTriples.get(s) : this.emptySet());
        Set<Object> predicateSet = p == null || p.startsWith("?") ? this.allTriples() : (this.predicateTriples.containsKey(p = p.toUpperCase()) ? (Set<Object>)this.predicateTriples.get(p) : this.emptySet());
        Set<Object> objectSet = o == null || o.startsWith("?") ? this.allTriples() : (this.objectTriples.containsKey(o = o.toUpperCase()) ? (Set<Object>)this.objectTriples.get(o) : this.emptySet());
        HashSet resultSet = new HashSet(subjectSet);
        resultSet.retainAll(predicateSet);
        resultSet.retainAll(objectSet);
        HashSet<String> finalResultSet = new HashSet<String>(resultSet);
        return finalResultSet;
    }

    public HashSet<String> getSubjects(HashSet<String> triples) {
        HashSet<String> resultSet = new HashSet<String>();
        for (String id : triples) {
            Triple triple = this.idTriple.get(id);
            resultSet.add(triple.subject);
        }
        return resultSet;
    }

    public HashSet<String> getPredicates(HashSet<String> triples) {
        HashSet<String> resultSet = new HashSet<String>();
        for (String id : triples) {
            Triple triple = this.idTriple.get(id);
            resultSet.add(triple.predicate);
        }
        return resultSet;
    }

    public HashSet<String> getObjects(HashSet<String> triples) {
        HashSet<String> resultSet = new HashSet<String>();
        for (String id : triples) {
            Triple triple = this.idTriple.get(id);
            resultSet.add(triple.object);
        }
        return resultSet;
    }

    public String formatAIMLTripleList(HashSet<String> triples) {
        String result = MagicStrings.default_list_item;
        for (String x : triples) {
            result = x + " " + result;
        }
        return result.trim();
    }

    public String getSubject(String id) {
        if (this.idTriple.containsKey(id)) {
            return this.idTriple.get((Object)id).subject;
        }
        return "Unknown subject";
    }

    public String getPredicate(String id) {
        if (this.idTriple.containsKey(id)) {
            return this.idTriple.get((Object)id).predicate;
        }
        return "Unknown predicate";
    }

    public String getObject(String id) {
        if (this.idTriple.containsKey(id)) {
            return this.idTriple.get((Object)id).object;
        }
        return "Unknown object";
    }

    public String stringTriple(String id) {
        Triple triple = this.idTriple.get(id);
        return id + " " + triple.subject + " " + triple.predicate + " " + triple.object;
    }

    public void printAllTriples() {
        for (String id : this.idTriple.keySet()) {
            System.out.println(this.stringTriple(id));
        }
    }

    public HashSet<Tuple> select(HashSet<String> vars, HashSet<String> visibleVars, ArrayList<Clause> clauses) {
        HashSet<Object> result = new HashSet();
        try {
            Tuple tuple = new Tuple(vars, visibleVars);
            result = this.selectFromRemainingClauses(tuple, clauses);
            if (MagicBooleans.trace_mode) {
                for (Tuple tuple2 : result) {
                    System.out.println(tuple2.printTuple());
                }
            }
        }
        catch (Exception ex) {
            System.out.println("Something went wrong with select " + visibleVars);
            ex.printStackTrace();
        }
        return result;
    }

    public Clause adjustClause(Tuple tuple, Clause clause) {
        String value;
        Set<String> vars = tuple.getVars();
        String subj = clause.subj;
        String pred = clause.pred;
        String obj = clause.obj;
        Clause newClause = new Clause(clause);
        if (vars.contains(subj) && !(value = tuple.getValue(subj)).equals(MagicStrings.unbound_variable)) {
            newClause.subj = value;
        }
        if (vars.contains(pred) && !(value = tuple.getValue(pred)).equals(MagicStrings.unbound_variable)) {
            newClause.pred = value;
        }
        if (vars.contains(obj) && !(value = tuple.getValue(obj)).equals(MagicStrings.unbound_variable)) {
            newClause.obj = value;
        }
        return newClause;
    }

    public Tuple bindTuple(Tuple partial, String triple, Clause clause) {
        Tuple tuple = new Tuple(partial);
        if (clause.subj.startsWith("?")) {
            tuple.bind(clause.subj, this.getSubject(triple));
        }
        if (clause.pred.startsWith("?")) {
            tuple.bind(clause.pred, this.getPredicate(triple));
        }
        if (clause.obj.startsWith("?")) {
            tuple.bind(clause.obj, this.getObject(triple));
        }
        return tuple;
    }

    public HashSet<Tuple> selectFromSingleClause(Tuple partial, Clause clause, Boolean affirm) {
        HashSet<Tuple> result = new HashSet<Tuple>();
        HashSet<String> triples = this.getTriples(clause.subj, clause.pred, clause.obj);
        if (affirm.booleanValue()) {
            for (String triple : triples) {
                Tuple tuple = this.bindTuple(partial, triple, clause);
                result.add(tuple);
            }
        } else if (triples.size() == 0) {
            result.add(partial);
        }
        return result;
    }

    public HashSet<Tuple> selectFromRemainingClauses(Tuple partial, ArrayList<Clause> clauses) {
        HashSet<Tuple> result = new HashSet();
        Clause clause = clauses.get(0);
        clause = this.adjustClause(partial, clause);
        HashSet<Tuple> tuples = this.selectFromSingleClause(partial, clause, clause.affirm);
        if (clauses.size() > 1) {
            ArrayList<Clause> remainingClauses = new ArrayList<Clause>(clauses);
            remainingClauses.remove(0);
            for (Tuple tuple : tuples) {
                result.addAll(this.selectFromRemainingClauses(tuple, remainingClauses));
            }
        } else {
            result = tuples;
        }
        return result;
    }

    public class Triple {
        public String id;
        public String subject;
        public String predicate;
        public String object;

        public Triple(String s, String p, String o) {
            Bot bot = TripleStore.this.bot;
            if (bot != null) {
                s = bot.preProcessor.normalize(s);
                p = bot.preProcessor.normalize(p);
                o = bot.preProcessor.normalize(o);
            }
            if (s != null && p != null && o != null) {
                this.subject = s;
                this.predicate = p;
                this.object = o;
                this.id = TripleStore.this.name + TripleStore.this.idCnt++;
            }
        }
    }
}

