/*
 * Decompiled with CFR 0.152.
 */
package org.alicebot.ab;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import org.alicebot.ab.MagicBooleans;
import org.alicebot.ab.MagicStrings;

public class Properties
extends HashMap<String, String> {
    public String get(String key) {
        String result = (String)super.get(key);
        if (result == null) {
            return MagicStrings.default_property;
        }
        return result;
    }

    public int getPropertiesFromInputStream(InputStream in) {
        int cnt = 0;
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        try {
            String strLine;
            while ((strLine = br.readLine()) != null) {
                if (!strLine.contains(":")) continue;
                String property = strLine.substring(0, strLine.indexOf(":"));
                String value = strLine.substring(strLine.indexOf(":") + 1);
                this.put(property, value);
                ++cnt;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return cnt;
    }

    public int getProperties(String filename) {
        int cnt = 0;
        if (MagicBooleans.trace_mode) {
            System.out.println("Get Properties: " + filename);
        }
        try {
            File file = new File(filename);
            if (file.exists()) {
                if (MagicBooleans.trace_mode) {
                    System.out.println("Exists: " + filename);
                }
                FileInputStream fstream = new FileInputStream(filename);
                cnt = this.getPropertiesFromInputStream(fstream);
                fstream.close();
            }
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
        }
        return cnt;
    }
}

